/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public static final String[] CATEGORIES = new String[]{"World and Dimension", "Rendering", "General", "Custom Recipes", "Potion effects", "Mob Spawning"};
    public static int dimensionId;
    public static int druidCircleFrequency;
    public static int biomeIdSwamplands;
    public static int biomeIdCoarseIslands;
    public static int biomeIdDeepWater;
    public static int biomeIdPatchyIslands;
    public static int biomeIdMarsh1;
    public static int biomeIdMarsh2;
    public static int biomeIdSludgePlains;
    public static boolean biomeIdLimit;
    public static int dimensionBrightness;
    public static int wispQuality;
    public static boolean useShader;
    public static boolean debug;
    public static boolean debugModelLoader;
    public static int skyResolution;
    public static boolean rowboatView;
    public static int maxEntitiesPerLoadedArea;
    public static int hardEntityLimit;
    public static boolean blMainMenu;
    public Configuration config;
    public static String path;

    public void loadConfig(FMLPreInitializationEvent event) {
        path = event.getSuggestedConfigurationFile().getPath();
        this.config = new Configuration(new File(path.replace("thebetweenlands.cfg", "thebetweenlands/config.cfg")));
        this.config.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        dimensionId = this.config.get(CATEGORIES[0], "The Betweenlands Dimension ID", 20).getInt(20);
        druidCircleFrequency = this.config.get(CATEGORIES[0], "Frequency of Druid Circles. Higher numbers de-crease rate.", 80).getInt(80);
        biomeIdSwamplands = this.config.get(CATEGORIES[0], "Swamplands Biome ID", 50).getInt(50);
        biomeIdCoarseIslands = this.config.get(CATEGORIES[0], "Coarse Islands Biome ID", 51).getInt(51);
        biomeIdDeepWater = this.config.get(CATEGORIES[0], "Deep Water Biome ID", 52).getInt(52);
        biomeIdPatchyIslands = this.config.get(CATEGORIES[0], "Patchy Islands Biome ID", 53).getInt(53);
        biomeIdMarsh1 = this.config.get(CATEGORIES[0], "Marsh 1 Biome ID", 54).getInt(54);
        biomeIdMarsh2 = this.config.get(CATEGORIES[0], "Marsh 2 Biome ID", 55).getInt(55);
        biomeIdSludgePlains = this.config.get(CATEGORIES[0], "Sludge Plains Biome ID", 56).getInt(56);
        biomeIdLimit = this.config.getBoolean("Biome ID Limit", CATEGORIES[0], true, "Prevents any biome IDs higher than 127. Setting this to false \nis NOT recommended unless you know what you're doing!");
        dimensionBrightness = this.config.get(CATEGORIES[0], "Dimension brightness (0-100)", 75).setMinValue(0).setMaxValue(100).getInt(75);
        wispQuality = this.config.get(CATEGORIES[1], "Wisp Rendering Quality (0-100)", 50).setMinValue(0).setMaxValue(100).getInt(100);
        useShader = this.config.getBoolean("Use shaders for rendering (this forces FBOs to be enabled)", CATEGORIES[1], true, "");
        skyResolution = this.config.get(CATEGORIES[1], "Sky texture resolution (only when shaders are enabled)", 1024).getInt(1024);
        debug = this.config.getBoolean("Debug mode", CATEGORIES[2], false, "");
        debugModelLoader = this.config.getBoolean("Model loader debug", CATEGORIES[2], false, "");
        blMainMenu = this.config.getBoolean("Betweenlands Main Menu", CATEGORIES[2], true, "If true, the main menu will be replaced by the Betweenlands main menu");
        rowboatView = this.config.getBoolean("Rowboat view", CATEGORIES[2], true, "If true, the camera perspective will be switch to rowboat when you enter a rowboat, otherwise first-person");
        maxEntitiesPerLoadedArea = this.config.get(CATEGORIES[5], "Max. entities per loaded area", 250, "The maximum amount of naturally spawned entities per loaded area (in most cases per player)").setMinValue(0).getInt(100);
        hardEntityLimit = this.config.get(CATEGORIES[5], "Max. entities per world", 600, "The maximum amount of naturally spawned entities per world").setMinValue(0).getInt(600);
        this.save();
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("thebetweenlands")) {
            this.syncConfigs();
        }
    }

    static {
        path = "";
    }
}

