/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class TileEntityHelper {
    public static <P extends IUnlistedProperty<T>, T> T getStatePropertySafely(@Nullable TileEntity te, Class<? extends Block> block, P property, T defaultVal) {
        return TileEntityHelper.getStatePropertySafely(te, block, property, defaultVal, false, false);
    }

    public static <P extends IUnlistedProperty<T>, T> T getStatePropertySafely(@Nullable TileEntity te, Class<? extends Block> block, P property, T defaultVal, boolean actual, boolean extended) {
        if (te == null || te.func_145831_w() == null) {
            return defaultVal;
        }
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (block.isInstance(state.func_177230_c())) {
            if (actual) {
                state = state.func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v());
            }
            if (extended) {
                state = state.func_177230_c().getExtendedState(state, (IBlockAccess)te.func_145831_w(), te.func_174877_v());
            }
            if (state instanceof IExtendedBlockState) {
                return (T)((IExtendedBlockState)state).getValue(property);
            }
        }
        return defaultVal;
    }

    public static <P extends IProperty<T>, T extends Comparable<T>> T getStatePropertySafely(@Nullable TileEntity te, Class<? extends Block> block, P property, T defaultVal) {
        return TileEntityHelper.getStatePropertySafely(te, block, property, defaultVal, false, false);
    }

    public static <P extends IProperty<T>, T extends Comparable<T>> T getStatePropertySafely(@Nullable TileEntity te, Class<? extends Block> block, P property, T defaultVal, boolean actual, boolean extended) {
        if (te == null || te.func_145831_w() == null) {
            return defaultVal;
        }
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (block.isInstance(state.func_177230_c())) {
            if (actual) {
                state = state.func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v());
            }
            if (extended) {
                state = state.func_177230_c().getExtendedState(state, (IBlockAccess)te.func_145831_w(), te.func_174877_v());
            }
            return (T)state.func_177229_b(property);
        }
        return defaultVal;
    }

    public static <T extends TileEntity> T getTileEntityThreadSafe(IBlockAccess world, BlockPos pos, Class<T> cls) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (cls.isInstance(te)) {
            return (T)te;
        }
        return null;
    }
}

