/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thebetweenlands.common.recipe.misc.ShapedRecipesBetweenlands;
import thebetweenlands.common.recipe.misc.ShapelessRecipesBetweenlands;

public class RecipeHelper {
    public static void addRecipe(ItemStack output, Object ... recipeComponents) {
        RecipeHelper.addShapedRecipe(output, recipeComponents);
    }

    public static IRecipe addShapedRecipe(ItemStack output, Object ... recipeComponents) {
        ShapedRecipes recipe = CraftingManager.func_77594_a().func_92103_a(output, recipeComponents);
        CraftingManager.func_77594_a().func_77592_b().remove(recipe);
        recipe = new ShapedRecipesBetweenlands(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, output);
        GameRegistry.addRecipe((IRecipe)recipe);
        return recipe;
    }

    public static IRecipe addShapelessRecipe(ItemStack output, Object ... recipeComponents) {
        ArrayList list = Lists.newArrayList();
        for (Object object : recipeComponents) {
            if (object instanceof ItemStack) {
                list.add(((ItemStack)object).func_77946_l());
                continue;
            }
            if (object instanceof Item) {
                list.add(new ItemStack((Item)object));
                continue;
            }
            if (!(object instanceof Block)) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!");
            }
            list.add(new ItemStack((Block)object));
        }
        ShapelessRecipesBetweenlands recipe = new ShapelessRecipesBetweenlands(output, list);
        GameRegistry.addRecipe((IRecipe)recipe);
        return recipe;
    }
}

