/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public class QuadBuilder {
    public final VertexFormat format;
    private TextureAtlasSprite sprite;
    private boolean switchUV = false;
    private TRSRTransformation transformation;
    private float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private Vec3d normal;
    private final List<Vertex> vertices;

    public QuadBuilder(VertexFormat format) {
        this(50, format);
    }

    public QuadBuilder(int vertices, VertexFormat format) {
        this.vertices = new ArrayList<Vertex>(vertices);
        this.format = format;
    }

    public QuadBuilder setNormal(Vec3d normal) {
        this.normal = normal;
        return this;
    }

    public Vec3d getNormal() {
        return this.normal;
    }

    public QuadBuilder setColor(float r, float g, float b, float a) {
        this.color = new float[4];
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        this.color[3] = a;
        return this;
    }

    public float[] getColor() {
        return this.color;
    }

    public QuadBuilder setTransformation(TRSRTransformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public TRSRTransformation getTransformation() {
        return this.transformation;
    }

    public QuadBuilder setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        return this;
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public QuadBuilder setSwitchUV(boolean switchUV) {
        this.switchUV = switchUV;
        return this;
    }

    public boolean getSwitchUV() {
        return this.switchUV;
    }

    public QuadBuilder addVertex(double x, double y, double z, float u, float v) {
        return this.addVertex(new Vec3d(x, y, z), u, v);
    }

    public QuadBuilder addVertex(double x, double y, double z) {
        return this.addVertex(new Vec3d(x, y, z));
    }

    public QuadBuilder addVertex(Vec3d pos, float u, float v) {
        this.vertices.add(new Vertex(pos, u, v, this.sprite, this.switchUV, this.transformation, this.color, this.normal));
        return this;
    }

    public QuadBuilder addVertex(Vec3d pos) {
        this.vertices.add(new Vertex(pos, 0.0f, 0.0f, this.sprite, this.switchUV, this.transformation, this.color, this.normal));
        return this;
    }

    public QuadBuilder addVertexInferUV(double x, double y, double z) {
        return this.addVertexInferUV(new Vec3d(x, y, z));
    }

    public QuadBuilder addVertexInferUV(Vec3d pos) {
        int relIndex = this.vertices.size() % 4;
        float u = 0.0f;
        float v = 0.0f;
        switch (relIndex) {
            default: {
                break;
            }
            case 1: {
                v = 16.0f;
                break;
            }
            case 2: {
                u = 16.0f;
                v = 16.0f;
                break;
            }
            case 3: {
                u = 16.0f;
            }
        }
        this.vertices.add(new Vertex(pos, u, v, this.sprite, this.switchUV, this.transformation, this.color, this.normal));
        return this;
    }

    public List<BakedQuad> build(@Nullable Consumer<UnpackedBakedQuad.Builder> quadConsumer) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.vertices.size() / 4);
        if (this.vertices.size() % 4 != 0) {
            throw new RuntimeException("Invalid number of vertices");
        }
        for (int i = 0; i < this.vertices.size(); i += 4) {
            Vertex vert1 = this.vertices.get(i);
            Vertex vert2 = this.vertices.get(i + 1);
            Vertex vert3 = this.vertices.get(i + 2);
            Vertex vert4 = this.vertices.get(i + 3);
            quads.add(this.createQuad(this.format, vert1, vert2, vert3, vert4, quadConsumer));
        }
        this.vertices.clear();
        return quads;
    }

    public List<BakedQuad> build() {
        return this.build(null);
    }

    private void putVertex(TRSRTransformation transformation, VertexFormat format, UnpackedBakedQuad.Builder builder, Vec3d quadNormal, double x, double y, double z, float u, float v, @Nullable TextureAtlasSprite sprite, boolean switchUV, float[] color, Vec3d vertexNormal) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    float[] positionData = new float[]{(float)x, (float)y, (float)z, 1.0f};
                    if (transformation != null && transformation != TRSRTransformation.identity()) {
                        Vector4f vec = new Vector4f(positionData);
                        transformation.getMatrix().transform((Tuple4f)vec);
                        vec.get(positionData);
                    }
                    builder.put(e, positionData);
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, color);
                    continue block6;
                }
                case NORMAL: {
                    float[] normalData = vertexNormal != null ? new float[]{(float)vertexNormal.field_72450_a, (float)vertexNormal.field_72448_b, (float)vertexNormal.field_72449_c, 0.0f} : new float[]{(float)(-quadNormal.field_72450_a), (float)(-quadNormal.field_72448_b), (float)(-quadNormal.field_72449_c), 0.0f};
                    if (transformation != null && transformation != TRSRTransformation.identity()) {
                        Vector4f vec = new Vector4f(normalData);
                        Matrix4f matrix = transformation.getMatrix();
                        matrix.invert();
                        matrix.transpose();
                        matrix.transform((Tuple4f)vec);
                        vec.get(normalData);
                    }
                    float dx = normalData[0];
                    float dy = normalData[1];
                    float dz = normalData[2];
                    float len = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                    normalData[0] = dx / len;
                    normalData[1] = dy / len;
                    normalData[2] = dz / len;
                    normalData[3] = 0.0f;
                    builder.put(e, normalData);
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        if (sprite != null) {
                            float pu = u;
                            float pv = v;
                            u = sprite.func_94214_a(switchUV ? (double)pv : (double)pu);
                            v = sprite.func_94207_b(switchUV ? (double)pu : (double)pv);
                        }
                        builder.put(e, new float[]{u, v, switchUV ? 1.0f : 0.0f, switchUV ? 0.0f : 1.0f});
                        continue block6;
                    }
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(VertexFormat format, Vertex vert1, Vertex vert2, Vertex vert3, Vertex vert4, @Nullable Consumer<UnpackedBakedQuad.Builder> quadConsumer) {
        Vec3d quadNormal = null;
        if (vert1.normal == null || vert2.normal == null || vert3.normal == null || vert4.normal == null) {
            quadNormal = vert1.pos.func_178788_d(vert2.pos).func_72431_c(vert3.pos.func_178788_d(vert2.pos));
        }
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setTexture(vert1.sprite);
        this.putVertex(vert1.transformation, format, builder, quadNormal, vert1.pos.field_72450_a, vert1.pos.field_72448_b, vert1.pos.field_72449_c, vert1.u, vert1.v, vert1.sprite, vert1.switchUV, vert1.color, vert1.normal);
        builder.setTexture(vert2.sprite);
        this.putVertex(vert2.transformation, format, builder, quadNormal, vert2.pos.field_72450_a, vert2.pos.field_72448_b, vert2.pos.field_72449_c, vert2.u, vert2.v, vert2.sprite, vert2.switchUV, vert2.color, vert2.normal);
        builder.setTexture(vert3.sprite);
        this.putVertex(vert3.transformation, format, builder, quadNormal, vert3.pos.field_72450_a, vert3.pos.field_72448_b, vert3.pos.field_72449_c, vert3.u, vert3.v, vert3.sprite, vert3.switchUV, vert3.color, vert3.normal);
        builder.setTexture(vert4.sprite);
        this.putVertex(vert4.transformation, format, builder, quadNormal, vert4.pos.field_72450_a, vert4.pos.field_72448_b, vert4.pos.field_72449_c, vert4.u, vert4.v, vert4.sprite, vert4.switchUV, vert4.color, vert4.normal);
        if (quadConsumer != null) {
            quadConsumer.accept(builder);
        }
        return builder.build();
    }

    static class Vertex {
        public final Vec3d pos;
        public final float u;
        public final float v;
        public final TextureAtlasSprite sprite;
        public final boolean switchUV;
        public final TRSRTransformation transformation;
        public final float[] color;
        public final Vec3d normal;

        private Vertex(Vec3d pos, float u, float v, TextureAtlasSprite sprite, boolean switchUV, TRSRTransformation transformation, float[] color, Vec3d normal) {
            this.pos = pos;
            this.u = u;
            this.v = v;
            this.sprite = sprite;
            this.switchUV = switchUV;
            this.transformation = transformation;
            this.color = color;
            this.normal = normal;
        }
    }
}

