/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thebetweenlands.util.RotationMatrix;
import thebetweenlands.util.Vec3UV;

public class ModelConverter {
    private static final RotationMatrix ROTATION_MATRIX = new RotationMatrix();
    private static Field f_mbQuadList = null;
    private final List<Box> modelBoxList = new ArrayList<Box>();
    private final Map<ModelRenderer, ModelRenderer> childOfMap = new HashMap<ModelRenderer, ModelRenderer>();
    private final Map<ModelRenderer, List<ModelRenderer>> parentMap = new HashMap<ModelRenderer, List<ModelRenderer>>();
    private final Map<ModelRenderer, List<Box>> modelRendererBoxMap = new HashMap<ModelRenderer, List<Box>>();
    private final Vec3UV fwdVec = new Vec3UV(0.0, 0.0, 1.0);
    private final Vec3UV upVec = new Vec3UV(0.0, -1.0, 0.0);
    private Model model;

    public ModelConverter(ModelBase model, double scale, boolean renderDoubleFace) {
        this(model, scale, renderDoubleFace, 0.0f, 0.0f, 0.0f);
    }

    public ModelConverter(ModelBase model, double scale, boolean renderDoubleFace, float rotationX, float rotationY, float rotationZ) {
        this(model, scale, renderDoubleFace, rotationX, rotationY, rotationZ, new Vec3UV(0.0, 0.0, 0.0));
    }

    public ModelConverter(ModelBase model, double scale, boolean renderDoubleFace, float rotationX, float rotationY, float rotationZ, Vec3UV rotationCenter) {
        this.constructModel(model, scale, renderDoubleFace);
        this.rotate(1.0f, rotationX + 180.0f, rotationY, rotationZ, rotationCenter);
    }

    private Vec3UV transformPosition(Vec3UV scaledPos, ModelRenderer modelRenderer, RotationMatrix rotationMatrix, double modelScale) {
        Vec3UV scaledRotPos = new Vec3UV((double)modelRenderer.field_78800_c * modelScale, (double)modelRenderer.field_78797_d * modelScale, (double)modelRenderer.field_78798_e * modelScale);
        if (modelRenderer.field_78795_f == 0.0f && modelRenderer.field_78796_g == 0.0f && modelRenderer.field_78808_h == 0.0f) {
            modelRenderer.field_78795_f = 1.0E-4f;
            modelRenderer.field_78796_g = 1.0E-4f;
            modelRenderer.field_78808_h = 1.0E-4f;
        }
        scaledPos.x += scaledRotPos.x;
        scaledPos.y += scaledRotPos.y;
        scaledPos.z += scaledRotPos.z;
        this.applyRotation(modelRenderer, rotationMatrix);
        scaledPos = rotationMatrix.transformVec(scaledPos, scaledRotPos);
        return scaledPos;
    }

    private Vec3UV getBoxCorner(boolean xb, boolean yb, boolean zb, ModelBox modelBox, ModelRenderer modelRenderer, double modelScale, RotationMatrix rotationMatrix) {
        double posX = (!xb ? modelBox.field_78252_a : modelBox.field_78248_d) + modelRenderer.field_82906_o;
        double posY = (!yb ? modelBox.field_78250_b : modelBox.field_78249_e) + modelRenderer.field_82908_p;
        double posZ = (!zb ? modelBox.field_78251_c : modelBox.field_78246_f) + modelRenderer.field_82907_q;
        Vec3UV scaledPos = new Vec3UV(posX * modelScale, posY * modelScale, posZ * modelScale);
        Vec3UV scaledRotPos = new Vec3UV((double)modelRenderer.field_78800_c * modelScale, (double)modelRenderer.field_78797_d * modelScale, (double)modelRenderer.field_78798_e * modelScale);
        if (modelRenderer.field_78795_f == 0.0f && modelRenderer.field_78796_g == 0.0f && modelRenderer.field_78808_h == 0.0f) {
            modelRenderer.field_78795_f = 1.0E-7f;
            modelRenderer.field_78796_g = 1.0E-7f;
            modelRenderer.field_78808_h = 1.0E-7f;
        }
        scaledPos.x += scaledRotPos.x;
        scaledPos.y += scaledRotPos.y;
        scaledPos.z += scaledRotPos.z;
        this.applyRotation(modelRenderer, rotationMatrix);
        scaledPos = rotationMatrix.transformVec(scaledPos, scaledRotPos);
        List<ModelRenderer> parents = this.parentMap.get(modelRenderer);
        if (parents != null && parents.size() > 0) {
            for (ModelRenderer parent : parents) {
                scaledPos = this.transformPosition(scaledPos, parent, ROTATION_MATRIX, modelScale);
            }
        }
        return scaledPos;
    }

    private void constructModel(ModelBase modelBase, double modelScale, boolean renderDoubleFace) {
        this.modelBoxList.clear();
        double modelWidth = modelBase.field_78090_t;
        double modelHeight = modelBase.field_78089_u;
        for (ModelRenderer modelRenderer : modelBase.field_78092_r) {
            if (modelRenderer.field_78805_m == null) continue;
            for (ModelRenderer childModelRenderer : modelRenderer.field_78805_m) {
                this.childOfMap.put(childModelRenderer, modelRenderer);
            }
        }
        for (ModelRenderer modelRenderer : modelBase.field_78092_r) {
            this.parentMap.put(modelRenderer, this.getParentList(new ArrayList<ModelRenderer>(), modelRenderer));
        }
        for (ModelRenderer modelRenderer : modelBase.field_78092_r) {
            for (ModelBox modelBox : modelRenderer.field_78804_l) {
                Vec3UV o = this.getBoxCorner(false, false, false, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                Vec3UV ox = this.getBoxCorner(true, false, false, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                Vec3UV oy = this.getBoxCorner(false, true, false, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                Vec3UV oz = this.getBoxCorner(false, false, true, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                Vec3UV oxy = this.getBoxCorner(true, true, false, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                Vec3UV oyz = this.getBoxCorner(false, true, true, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                Vec3UV oxz = this.getBoxCorner(true, false, true, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                Vec3UV oxyz = this.getBoxCorner(true, true, true, modelBox, modelRenderer, modelScale, ROTATION_MATRIX);
                if (f_mbQuadList == null) {
                    f_mbQuadList = ReflectionHelper.findField(ModelBox.class, (String[])new String[]{"quadList", "field_78254_i", "i"});
                }
                TexturedQuad[] mbQuadList = null;
                try {
                    mbQuadList = (TexturedQuad[])f_mbQuadList.get(modelBox);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                PositionTextureVertex[] mbVertices1 = mbQuadList[0].field_78239_a;
                PositionTextureVertex[] mbVertices2 = mbQuadList[1].field_78239_a;
                PositionTextureVertex[] mbVertices3 = mbQuadList[2].field_78239_a;
                PositionTextureVertex[] mbVertices4 = mbQuadList[3].field_78239_a;
                PositionTextureVertex[] mbVertices5 = mbQuadList[4].field_78239_a;
                PositionTextureVertex[] mbVertices6 = mbQuadList[5].field_78239_a;
                ArrayList<Quad> quadList = new ArrayList<Quad>(12);
                Quad face1 = new Quad(new Vec3UV(o, mbVertices5[0].field_78241_b, mbVertices5[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(oy, mbVertices5[3].field_78241_b, mbVertices5[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxy, mbVertices5[2].field_78241_b, mbVertices5[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(ox, mbVertices5[1].field_78241_b, mbVertices5[1].field_78242_c, modelWidth, modelHeight));
                quadList.add(face1);
                if (renderDoubleFace) {
                    Quad face1d = new Quad(new Vec3UV(o, mbVertices5[0].field_78241_b, mbVertices5[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(ox, mbVertices5[1].field_78241_b, mbVertices5[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxy, mbVertices5[2].field_78241_b, mbVertices5[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(oy, mbVertices5[3].field_78241_b, mbVertices5[3].field_78242_c, modelWidth, modelHeight));
                    quadList.add(face1d);
                }
                Quad face2 = new Quad(new Vec3UV(oz, mbVertices6[1].field_78241_b, mbVertices6[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxz, mbVertices6[0].field_78241_b, mbVertices6[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxyz, mbVertices6[3].field_78241_b, mbVertices6[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oyz, mbVertices6[2].field_78241_b, mbVertices6[2].field_78242_c, modelWidth, modelHeight));
                quadList.add(face2);
                if (renderDoubleFace) {
                    Quad face2d = new Quad(new Vec3UV(oz, mbVertices6[1].field_78241_b, mbVertices6[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oyz, mbVertices6[2].field_78241_b, mbVertices6[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxyz, mbVertices6[3].field_78241_b, mbVertices6[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxz, mbVertices6[0].field_78241_b, mbVertices6[0].field_78242_c, modelWidth, modelHeight));
                    quadList.add(face2d);
                }
                Quad face3 = new Quad(new Vec3UV(oy, mbVertices4[1].field_78241_b, mbVertices4[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oyz, mbVertices4[2].field_78241_b, mbVertices4[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxyz, mbVertices4[3].field_78241_b, mbVertices4[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxy, mbVertices4[0].field_78241_b, mbVertices4[0].field_78242_c, modelWidth, modelHeight));
                quadList.add(face3);
                if (renderDoubleFace) {
                    Quad face3d = new Quad(new Vec3UV(oy, mbVertices4[1].field_78241_b, mbVertices4[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxy, mbVertices4[0].field_78241_b, mbVertices4[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxyz, mbVertices4[3].field_78241_b, mbVertices4[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oyz, mbVertices4[2].field_78241_b, mbVertices4[2].field_78242_c, modelWidth, modelHeight));
                    quadList.add(face3d);
                }
                Quad face4 = new Quad(new Vec3UV(o, mbVertices3[2].field_78241_b, mbVertices3[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(ox, mbVertices3[3].field_78241_b, mbVertices3[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxz, mbVertices3[0].field_78241_b, mbVertices3[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(oz, mbVertices3[1].field_78241_b, mbVertices3[1].field_78242_c, modelWidth, modelHeight));
                quadList.add(face4);
                if (renderDoubleFace) {
                    Quad face4d = new Quad(new Vec3UV(o, mbVertices3[2].field_78241_b, mbVertices3[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(oz, mbVertices3[1].field_78241_b, mbVertices3[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxz, mbVertices3[0].field_78241_b, mbVertices3[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(ox, mbVertices3[3].field_78241_b, mbVertices3[3].field_78242_c, modelWidth, modelHeight));
                    quadList.add(face4d);
                }
                Quad face5 = new Quad(new Vec3UV(ox, mbVertices1[1].field_78241_b, mbVertices1[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxy, mbVertices1[2].field_78241_b, mbVertices1[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxyz, mbVertices1[3].field_78241_b, mbVertices1[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxz, mbVertices1[0].field_78241_b, mbVertices1[0].field_78242_c, modelWidth, modelHeight));
                quadList.add(face5);
                if (renderDoubleFace) {
                    Quad face5d = new Quad(new Vec3UV(ox, mbVertices1[1].field_78241_b, mbVertices1[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxz, mbVertices1[0].field_78241_b, mbVertices1[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxyz, mbVertices1[3].field_78241_b, mbVertices1[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oxy, mbVertices1[2].field_78241_b, mbVertices1[2].field_78242_c, modelWidth, modelHeight));
                    quadList.add(face5d);
                }
                Quad face6 = new Quad(new Vec3UV(o, mbVertices2[0].field_78241_b, mbVertices2[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(oz, mbVertices2[1].field_78241_b, mbVertices2[1].field_78242_c, modelWidth, modelHeight), new Vec3UV(oyz, mbVertices2[2].field_78241_b, mbVertices2[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(oy, mbVertices2[3].field_78241_b, mbVertices2[3].field_78242_c, modelWidth, modelHeight));
                quadList.add(face6);
                if (renderDoubleFace) {
                    Quad face6d = new Quad(new Vec3UV(o, mbVertices2[0].field_78241_b, mbVertices2[0].field_78242_c, modelWidth, modelHeight), new Vec3UV(oy, mbVertices2[3].field_78241_b, mbVertices2[3].field_78242_c, modelWidth, modelHeight), new Vec3UV(oyz, mbVertices2[2].field_78241_b, mbVertices2[2].field_78242_c, modelWidth, modelHeight), new Vec3UV(oz, mbVertices2[1].field_78241_b, mbVertices2[1].field_78242_c, modelWidth, modelHeight));
                    quadList.add(face6d);
                }
                Quad[] quads = quadList.toArray(new Quad[0]);
                this.addBox(new Box(quads, modelRenderer, modelBox));
            }
        }
        HashMap childModelMap = new HashMap();
        for (Box box : this.modelBoxList) {
            ModelRenderer mr = box.modelRenderer;
            ArrayList<ModelRenderer> childList = (ArrayList<ModelRenderer>)childModelMap.get(mr);
            if (childList == null) {
                childList = new ArrayList<ModelRenderer>();
                childModelMap.put(mr, childList);
            }
            List<ModelRenderer> childModels = this.getChildModels(new ArrayList<ModelRenderer>(), mr);
            for (ModelRenderer childModel : childModels) {
                if (childList.contains(childModel)) continue;
                childList.add(childModel);
            }
        }
        for (Box box : this.modelBoxList) {
            List childModels = (List)childModelMap.get(box.modelRenderer);
            for (ModelRenderer childModel : childModels) {
                List<Box> childBoxes = this.modelRendererBoxMap.get(childModel);
                for (Box childBox : childBoxes) {
                    if (box.childBoxes.contains(childBox)) continue;
                    box.childBoxes.add(childBox);
                }
            }
        }
        this.model = new Model(this.modelBoxList, this.fwdVec, this.upVec);
    }

    private List<ModelRenderer> getChildModels(List<ModelRenderer> list, ModelRenderer modelRenderer) {
        if (modelRenderer.field_78805_m != null && modelRenderer.field_78805_m.size() > 0) {
            for (ModelRenderer childModel : modelRenderer.field_78805_m) {
                list.add(childModel);
                if (list.contains(childModel)) continue;
                for (ModelRenderer mr : this.getChildModels(list, childModel)) {
                    if (list.contains(mr)) continue;
                    list.add(mr);
                }
            }
        }
        return list;
    }

    public ModelConverter rotate(float rotation, float x, float y, float z, Vec3UV center) {
        ROTATION_MATRIX.setRotations((float)Math.toRadians(x * rotation), (float)Math.toRadians(y * rotation), (float)Math.toRadians(z * rotation));
        for (Box box : this.modelBoxList) {
            for (Quad quad : box.quads) {
                for (int i = 0; i < 4; ++i) {
                    Vec3UV vec = quad.vertices[i];
                    Vec3UV rotatedPoint = null;
                    rotatedPoint = ROTATION_MATRIX.transformVec(vec, center);
                    vec.x = rotatedPoint.x;
                    vec.y = rotatedPoint.y;
                    vec.z = rotatedPoint.z;
                }
            }
        }
        Vec3UV rotatedFwdVec = ROTATION_MATRIX.transformVec(this.fwdVec, center);
        this.fwdVec.x = rotatedFwdVec.x;
        this.fwdVec.y = rotatedFwdVec.y;
        this.fwdVec.z = rotatedFwdVec.z;
        Vec3UV rotatedUpVec = ROTATION_MATRIX.transformVec(this.upVec, center);
        this.upVec.x = rotatedUpVec.x;
        this.upVec.y = rotatedUpVec.y;
        this.upVec.z = rotatedUpVec.z;
        return this;
    }

    public ModelConverter offsetWS(Vec3UV offset) {
        for (Box box : this.modelBoxList) {
            for (Quad quad : box.quads) {
                for (int i = 0; i < 4; ++i) {
                    Vec3UV vec = quad.vertices[i];
                    vec.x += offset.x;
                    vec.y += offset.y;
                    vec.z += offset.z;
                }
            }
        }
        return this;
    }

    public ModelConverter offsetMS(Vec3UV offset) {
        Vec3UV leftVec = this.fwdVec.cross(this.upVec);
        for (Box box : this.modelBoxList) {
            for (Quad quad : box.quads) {
                for (int i = 0; i < 4; ++i) {
                    Vec3UV vec = quad.vertices[i];
                    vec.x += this.upVec.x * offset.y + this.fwdVec.x * offset.z + leftVec.x * offset.x;
                    vec.y += this.upVec.y * offset.y + this.fwdVec.y * offset.z + leftVec.y * offset.x;
                    vec.z += this.upVec.z * offset.y + this.fwdVec.z * offset.z + leftVec.z * offset.x;
                }
            }
        }
        return this;
    }

    public ModelConverter scale(double x, double y, double z) {
        for (Box box : this.modelBoxList) {
            for (Quad quad : box.quads) {
                for (int i = 0; i < 4; ++i) {
                    Vec3UV vec = quad.vertices[i];
                    vec.x *= x;
                    vec.y *= y;
                    vec.z *= z;
                }
            }
        }
        return this;
    }

    private List<ModelRenderer> getParentList(List<ModelRenderer> parentList, ModelRenderer modelRenderer) {
        if (this.childOfMap.containsKey(modelRenderer)) {
            ModelRenderer parent = this.childOfMap.get(modelRenderer);
            parentList.add(parent);
            this.getParentList(parentList, parent);
        }
        return parentList;
    }

    private void addBox(Box box) {
        this.modelBoxList.add(box);
        List<Box> boxList = this.modelRendererBoxMap.get(box.modelRenderer);
        if (boxList == null) {
            boxList = new ArrayList<Box>();
            this.modelRendererBoxMap.put(box.modelRenderer, boxList);
        }
        boxList.add(box);
    }

    public Model getModel() {
        return this.model;
    }

    protected void applyRotation(ModelRenderer modelRenderer, RotationMatrix rotationMatrix) {
        rotationMatrix.setRotations(modelRenderer.field_78795_f, modelRenderer.field_78796_g, modelRenderer.field_78808_h);
    }

    public static class Model {
        private final Vec3UV fwdVec;
        private final Vec3UV upVec;
        private List<Box> modelBoxes = new ArrayList<Box>();

        private Model(List<Box> modelBoxList, Vec3UV fwdVec, Vec3UV upVec) {
            HashMap<Box, Box> copyReference = new HashMap<Box, Box>();
            this.fwdVec = new Vec3UV(fwdVec);
            this.upVec = new Vec3UV(upVec);
            for (Box box : modelBoxList) {
                Quad[] quads = new Quad[box.quads.length];
                for (int i = 0; i < box.quads.length; ++i) {
                    Quad quad = box.quads[i];
                    quads[i] = new Quad(new Vec3UV(quad.vertices[0]), new Vec3UV(quad.vertices[1]), new Vec3UV(quad.vertices[2]), new Vec3UV(quad.vertices[3]));
                }
                Box b = new Box(quads, box.modelRenderer, box.modelBox);
                this.modelBoxes.add(b);
                copyReference.put(box, b);
            }
            for (Box box : modelBoxList) {
                Box newBox = (Box)copyReference.get(box);
                for (Box childBox : box.childBoxes) {
                    newBox.childBoxes.add(copyReference.get(childBox));
                }
            }
        }

        public Model offsetWS(Vec3UV offset) {
            for (Box box : this.modelBoxes) {
                for (Quad quad : box.quads) {
                    for (int i = 0; i < 4; ++i) {
                        Vec3UV vec = quad.vertices[i];
                        vec.x += offset.x;
                        vec.y += offset.y;
                        vec.z += offset.z;
                    }
                }
            }
            return this;
        }

        public Model offsetMS(Vec3UV offset) {
            Vec3UV leftVec = this.fwdVec.cross(this.upVec);
            for (Box box : this.modelBoxes) {
                for (Quad quad : box.quads) {
                    for (int i = 0; i < 4; ++i) {
                        Vec3UV vec = quad.vertices[i];
                        vec.x += this.upVec.x * offset.y + this.fwdVec.x * offset.z + leftVec.x * offset.x;
                        vec.y += this.upVec.y * offset.y + this.fwdVec.y * offset.z + leftVec.y * offset.x;
                        vec.z += this.upVec.z * offset.y + this.fwdVec.z * offset.z + leftVec.z * offset.x;
                    }
                }
            }
            return this;
        }

        public Model rotate(float rotation, float x, float y, float z, Vec3UV center) {
            ROTATION_MATRIX.setRotations((float)Math.toRadians(x * rotation), (float)Math.toRadians(y * rotation), (float)Math.toRadians(z * rotation));
            for (Box box : this.modelBoxes) {
                for (Quad quad : box.quads) {
                    for (int i = 0; i < 4; ++i) {
                        Vec3UV vec = quad.vertices[i];
                        Vec3UV rotatedPoint = null;
                        rotatedPoint = ROTATION_MATRIX.transformVec(vec, center);
                        vec.x = rotatedPoint.x;
                        vec.y = rotatedPoint.y;
                        vec.z = rotatedPoint.z;
                    }
                }
            }
            Vec3UV rotatedFwdVec = ROTATION_MATRIX.transformVec(this.fwdVec, center);
            this.fwdVec.x = rotatedFwdVec.x;
            this.fwdVec.y = rotatedFwdVec.y;
            this.fwdVec.z = rotatedFwdVec.z;
            Vec3UV rotatedUpVec = ROTATION_MATRIX.transformVec(this.upVec, center);
            this.upVec.x = rotatedUpVec.x;
            this.upVec.y = rotatedUpVec.y;
            this.upVec.z = rotatedUpVec.z;
            return this;
        }

        public Model scale(double x, double y, double z) {
            for (Box box : this.modelBoxes) {
                for (Quad quad : box.quads) {
                    for (int i = 0; i < 4; ++i) {
                        Vec3UV vec = quad.vertices[i];
                        vec.x *= x;
                        vec.y *= y;
                        vec.z *= z;
                    }
                }
            }
            return this;
        }

        public List<Box> getBoxes() {
            return this.modelBoxes;
        }

        public Model copy() {
            return new Model(this.modelBoxes, this.fwdVec, this.upVec);
        }
    }

    public static final class Box {
        private final Quad[] quads;
        private final ModelRenderer modelRenderer;
        private final ModelBox modelBox;
        private final List<Box> childBoxes = new ArrayList<Box>();

        private Box(Quad[] quads, ModelRenderer modelRenderer, ModelBox modelBox) {
            this.quads = quads;
            this.modelRenderer = modelRenderer;
            this.modelBox = modelBox;
        }

        public Quad[] getQuads() {
            return this.quads;
        }

        public ModelRenderer getModelRenderer() {
            return this.modelRenderer;
        }

        public ModelBox getModelBox() {
            return this.modelBox;
        }

        public List<Box> getChildBoxes() {
            return this.childBoxes;
        }

        public Box rotate(float rotation, float x, float y, float z, Vec3UV center) {
            ROTATION_MATRIX.setRotations((float)Math.toRadians(x * rotation), (float)Math.toRadians(y * rotation), (float)Math.toRadians(z * rotation));
            for (Box box : this.childBoxes) {
                box.rotate(rotation, x, y, z, center);
            }
            for (Quad quad : this.quads) {
                for (int i = 0; i < 4; ++i) {
                    Vec3UV vec = quad.vertices[i];
                    Vec3UV rotatedPoint = null;
                    rotatedPoint = ROTATION_MATRIX.transformVec(vec, center);
                    vec.x = rotatedPoint.x;
                    vec.y = rotatedPoint.y;
                    vec.z = rotatedPoint.z;
                }
            }
            return this;
        }

        public AlignedQuad[] getAlignedQuads() {
            AlignedQuad[] alignedQuads = new AlignedQuad[4];
            for (int i = 0; i < 4; ++i) {
                Quad quad = this.quads[i];
                alignedQuads[i] = new AlignedQuad(quad);
            }
            return alignedQuads;
        }
    }

    public static final class AlignedQuad {
        public final Quad originalQuad;
        public final double x;
        public final double y;
        public final double z;
        public final double width;
        public final double height;
        public final double rx;
        public final double ry;
        public final double rz;

        private AlignedQuad(Quad originalQuad) {
            this.originalQuad = originalQuad;
            Vec3UV vert1 = this.originalQuad.vertices[0];
            this.x = vert1.x;
            this.y = vert1.y;
            this.z = vert1.z;
            Vec3UV dirW = this.originalQuad.vertices[1].sub(this.originalQuad.vertices[0]);
            Vec3UV dirH = this.originalQuad.vertices[3].sub(this.originalQuad.vertices[0]);
            this.width = dirW.len();
            this.height = dirH.len();
            dirW = dirW.normalized();
            dirH = dirH.normalized();
            Vec3UV up = new Vec3UV(0.0, 1.0, 0.0);
            this.rx = Math.toDegrees(Math.acos(up.dot(new Vec3UV(0.0, dirH.y, dirH.z))));
            Vec3UV fwd = new Vec3UV(0.0, 0.0, 1.0);
            this.rz = Math.toDegrees(Math.acos(up.dot(new Vec3UV(dirH.x, dirH.y, 0.0))));
            Vec3UV side = new Vec3UV(1.0, 0.0, 0.0);
            this.ry = Math.toDegrees(Math.acos(fwd.dot(new Vec3UV(dirW.x, 0.0, dirW.z))));
        }
    }

    public static final class Quad {
        private Vec3UV[] vertices = new Vec3UV[4];

        private Quad(Vec3UV v1, Vec3UV v2, Vec3UV v3, Vec3UV v4) {
            this.vertices[0] = v1;
            this.vertices[1] = v2;
            this.vertices[2] = v3;
            this.vertices[3] = v4;
        }

        public Vec3UV[] getVertices() {
            return this.vertices;
        }
    }
}

