/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import thebetweenlands.util.ColorUtils;

public class GuiUtils {
    public static void drawLine(float xPos1, float yPos1, float xPos2, float yPos2, int colour) {
        float[] colors = ColorUtils.getRGBA(colour);
        GlStateManager.func_179090_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xPos1, (double)yPos1);
        GL11.glVertex2d((double)xPos2, (double)yPos2);
        GL11.glEnd();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
    }

    public static void drawRect(float xPos1, float yPos1, float xPos2, float yPos2, int colour) {
        float[] colors = ColorUtils.getRGBA(colour);
        GlStateManager.func_179090_x();
        GL11.glEnable((int)2848);
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)xPos1, (double)yPos1);
        GL11.glVertex2d((double)xPos1, (double)yPos2);
        GL11.glVertex2d((double)xPos2, (double)yPos2);
        GL11.glVertex2d((double)xPos2, (double)yPos1);
        GL11.glEnd();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)2848);
        GlStateManager.func_179098_w();
    }

    public static void drawPartialCircle(int x, int y, double radius, int startAngle, int endAngle) {
        GlStateManager.func_179090_x();
        GL11.glBegin((int)8);
        endAngle -= 90;
        for (int angle = startAngle -= 90; angle <= endAngle; ++angle) {
            float rad = (float)(Math.PI * (double)angle / 180.0);
            float x2 = (float)((double)x + radius * Math.cos(rad));
            float y2 = (float)((double)y + radius * Math.sin(rad));
            GL11.glVertex3f((float)x2, (float)y2, (float)0.0f);
            GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        }
        GL11.glEnd();
        GlStateManager.func_179098_w();
    }

    public static void drawCircle(int x, int y, double radius) {
        GlStateManager.func_179090_x();
        GL11.glEnable((int)2848);
        GlStateManager.func_179147_l();
        GL11.glBegin((int)6);
        for (int i = 0; i <= 360; ++i) {
            double sin = Math.sin((double)i * Math.PI / 180.0) * radius;
            double cos = Math.cos((double)i * Math.PI / 180.0) * radius;
            GL11.glVertex2d((double)((double)x + sin), (double)((double)y + cos));
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GlStateManager.func_179098_w();
    }

    public static void drawCircleOutline(int x, int y, double radius) {
        GlStateManager.func_179098_w();
        GL11.glEnable((int)2848);
        GlStateManager.func_179147_l();
        float rotation = (float)Math.PI / 180;
        float moveX = (float)Math.cos(rotation);
        float moveY = (float)Math.sin(rotation);
        float xOffset = (float)radius;
        float yOffset = 0.0f;
        GL11.glBegin((int)2);
        for (int i = 0; i < 360; ++i) {
            GL11.glVertex2f((float)((float)x + xOffset), (float)((float)y + yOffset));
            float prevXOffset = xOffset;
            xOffset = moveX * xOffset - moveY * yOffset;
            yOffset = moveY * prevXOffset + moveX * yOffset;
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GlStateManager.func_179098_w();
    }

    public static void drawCircleOutline(int x, int y, double radius, int corners) {
        GlStateManager.func_179090_x();
        GL11.glEnable((int)2848);
        GlStateManager.func_179147_l();
        float rotation = (float)(Math.PI * 2 / (double)corners);
        float moveX = (float)Math.cos(rotation);
        float moveY = (float)Math.sin(rotation);
        float xOffset = (float)radius;
        float yOffset = 0.0f;
        GL11.glBegin((int)2);
        for (int i = 0; i < corners; ++i) {
            GL11.glVertex2f((float)((float)x + xOffset), (float)((float)y + yOffset));
            float prevXOffset = xOffset;
            xOffset = moveX * xOffset - moveY * yOffset;
            yOffset = moveY * prevXOffset + moveX * yOffset;
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GlStateManager.func_179098_w();
    }

    public static void renderTexturedCircleSegment(int segments, double maxAngle, double wrapAngle, double radius, double innerRadius, double minU, double maxU, double minV, double maxV) {
        GlStateManager.func_179129_p();
        GL11.glBegin((int)7);
        for (int i = 0; i < segments; ++i) {
            double angle = (double)i * (maxAngle / (double)segments);
            double nextAngle = (double)(i + 1) * (maxAngle / (double)segments);
            double sin = Math.sin(angle * Math.PI / 180.0) * radius;
            double cos = Math.cos(angle * Math.PI / 180.0) * radius;
            double len = Math.sqrt(sin * sin + cos * cos);
            double nextSin = Math.sin(nextAngle * Math.PI / 180.0) * radius;
            double nextCos = Math.cos(nextAngle * Math.PI / 180.0) * radius;
            double nextLen = Math.sqrt(nextSin * nextSin + nextCos * nextCos);
            double diffU = maxU - minU;
            double wrapCircumference = Math.PI * wrapAngle * 2.0;
            double circumference = Math.PI * angle * 2.0;
            double textureU = minU + diffU / wrapCircumference * circumference;
            double nextCircumference = Math.PI * nextAngle * 2.0;
            double nextTextureU = minU + diffU / wrapCircumference * nextCircumference;
            if (textureU % diffU > nextTextureU % diffU) {
                double diffToLimit = maxU - textureU % diffU;
                double interpolatedAngle = angle + (nextAngle - angle) / (nextTextureU - textureU) * diffToLimit;
                double interpolatedSin = Math.sin(interpolatedAngle * Math.PI / 180.0) * radius;
                double interpolatedCos = Math.cos(interpolatedAngle * Math.PI / 180.0) * radius;
                double interpolatedLen = Math.sqrt(interpolatedSin * interpolatedSin + interpolatedCos * interpolatedCos);
                nextTextureU %= diffU;
                GL11.glTexCoord2d((double)(textureU %= diffU), (double)maxV);
                GL11.glVertex2d((double)sin, (double)cos);
                GL11.glTexCoord2d((double)maxU, (double)maxV);
                GL11.glVertex2d((double)interpolatedSin, (double)interpolatedCos);
                GL11.glTexCoord2d((double)maxU, (double)minV);
                GL11.glVertex2d((double)(interpolatedSin / interpolatedLen * innerRadius), (double)(interpolatedCos / interpolatedLen * innerRadius));
                GL11.glTexCoord2d((double)textureU, (double)minV);
                GL11.glVertex2d((double)(sin / interpolatedLen * innerRadius), (double)(cos / interpolatedLen * innerRadius));
                GL11.glTexCoord2d((double)minU, (double)maxV);
                GL11.glVertex2d((double)interpolatedSin, (double)interpolatedCos);
                GL11.glTexCoord2d((double)nextTextureU, (double)maxV);
                GL11.glVertex2d((double)nextSin, (double)nextCos);
                GL11.glTexCoord2d((double)nextTextureU, (double)minV);
                GL11.glVertex2d((double)(nextSin / nextLen * innerRadius), (double)(nextCos / nextLen * innerRadius));
                GL11.glTexCoord2d((double)minU, (double)minV);
                GL11.glVertex2d((double)(interpolatedSin / interpolatedLen * innerRadius), (double)(interpolatedCos / interpolatedLen * innerRadius));
                continue;
            }
            nextTextureU = nextTextureU % diffU == (textureU %= diffU) && nextTextureU > textureU ? maxU : (nextTextureU %= diffU);
            GL11.glTexCoord2d((double)textureU, (double)maxV);
            GL11.glVertex2d((double)sin, (double)cos);
            GL11.glTexCoord2d((double)nextTextureU, (double)maxV);
            GL11.glVertex2d((double)nextSin, (double)nextCos);
            GL11.glTexCoord2d((double)nextTextureU, (double)minV);
            GL11.glVertex2d((double)(nextSin / nextLen * innerRadius), (double)(nextCos / nextLen * innerRadius));
            GL11.glTexCoord2d((double)textureU, (double)minV);
            GL11.glVertex2d((double)(sin / len * innerRadius), (double)(cos / len * innerRadius));
        }
        GL11.glEnd();
        GlStateManager.func_179089_o();
    }

    public static void renderTexturedCircleSegment(int segments, double maxAngle, double wrapAngle, double wrapRadius, double radius, double innerRadius, double minU, double maxU, double minV, double maxV) {
        double segmentWidth = radius - innerRadius;
        double requiredSegments = segmentWidth / wrapRadius;
        double diffV = maxV - minV;
        double vPerSegment = MathHelper.func_151237_a((double)(diffV * requiredSegments), (double)0.0, (double)diffV);
        for (int i = 0; i < MathHelper.func_76143_f((double)requiredSegments); ++i) {
            double renderInnerRadius = segmentWidth / requiredSegments * (double)i;
            double renderOuterRadius = segmentWidth / requiredSegments * (double)(i + 1);
            double segmentLength = renderOuterRadius - renderInnerRadius;
            if (renderInnerRadius > segmentWidth) break;
            if (renderOuterRadius > segmentWidth) {
                renderOuterRadius = segmentWidth;
            }
            double textureV = minV;
            double textureVOuter = minV + vPerSegment / segmentLength * (renderOuterRadius - renderInnerRadius);
            if (vPerSegment < diffV) {
                textureVOuter = minV + diffV / segmentLength * (renderOuterRadius - renderInnerRadius);
            }
            GuiUtils.renderTexturedCircleSegment(segments, maxAngle, wrapAngle, renderOuterRadius + innerRadius, renderInnerRadius + innerRadius, minU, maxU, textureV, textureVOuter);
        }
    }

    public static void renderMappedCircleSegmentWrapped(int segments, double maxAngle, double wrapAngle, double wrapRadius, double radius, double innerRadius, double borderWidth, double sminU, double smaxU, double sminV, double smaxV, double b1minU, double b1maxU, double b1minV, double b1maxV, double b2minU, double b2maxU, double b2minV, double b2maxV, double b3minU, double b3maxU, double b3minV, double b3maxV, double b4minU, double b4maxU, double b4minV, double b4maxV, double c1minU, double c1maxU, double c1minV, double c1maxV, double c2minU, double c2maxU, double c2minV, double c2maxV, double c3minU, double c3maxU, double c3minV, double c3maxV, double c4minU, double c4maxU, double c4minV, double c4maxV) {
        double textureVOuter;
        double textureV;
        double segmentLength;
        double renderOuterRadius;
        double renderInnerRadius;
        int i;
        double vPerSegment;
        double diffV;
        double requiredSegments;
        double borderLength;
        double borderAngle = borderWidth / (Math.PI * innerRadius * 2.0 / 360.0);
        double initialMaxAngle = maxAngle;
        double innerSegmentMaxAngle = (maxAngle += borderAngle * 2.0) - 2.0 * borderAngle;
        double wrapAngleInner = wrapAngle * (Math.PI * radius * 2.0) / (Math.PI * (innerRadius -= borderWidth) * 2.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179094_E();
        GuiUtils.renderTexturedCircleSegment(segments, innerSegmentMaxAngle, wrapAngle, wrapRadius, radius - borderWidth, innerRadius + borderWidth, sminU, smaxU, sminV, smaxV);
        GlStateManager.func_179121_F();
        if (initialMaxAngle < 360.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)((float)(-maxAngle + borderAngle * 2.0)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(innerRadius + borderWidth), (double)0.0);
            GlStateManager.func_179129_p();
            GL11.glBegin((int)7);
            borderLength = radius - innerRadius;
            requiredSegments = borderLength / wrapRadius;
            diffV = b1maxV - b1minV;
            vPerSegment = MathHelper.func_151237_a((double)(diffV * requiredSegments), (double)0.0, (double)diffV);
            for (i = 0; i < MathHelper.func_76143_f((double)requiredSegments); ++i) {
                renderInnerRadius = borderLength / requiredSegments * (double)i;
                renderOuterRadius = borderLength / requiredSegments * (double)(i + 1);
                segmentLength = renderOuterRadius - renderInnerRadius;
                if (renderInnerRadius > borderLength - borderWidth * 2.0) break;
                if (renderOuterRadius > borderLength - borderWidth * 2.0) {
                    renderOuterRadius = borderLength - borderWidth * 2.0;
                }
                textureV = b1minV;
                textureVOuter = b1minV + vPerSegment / segmentLength * (renderOuterRadius - renderInnerRadius);
                if (vPerSegment < diffV) {
                    textureVOuter = b1minV + diffV / segmentLength * (renderOuterRadius - renderInnerRadius);
                }
                GL11.glTexCoord2d((double)b1maxU, (double)textureV);
                GL11.glVertex2d((double)0.0, (double)renderInnerRadius);
                GL11.glTexCoord2d((double)b1minU, (double)textureV);
                GL11.glVertex2d((double)borderWidth, (double)renderInnerRadius);
                GL11.glTexCoord2d((double)b1minU, (double)textureVOuter);
                GL11.glVertex2d((double)borderWidth, (double)renderOuterRadius);
                GL11.glTexCoord2d((double)b1maxU, (double)textureVOuter);
                GL11.glVertex2d((double)0.0, (double)renderOuterRadius);
            }
            GL11.glEnd();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GuiUtils.renderTexturedCircleSegment(segments, innerSegmentMaxAngle, wrapAngle, radius, radius - borderWidth, b2minU, b2maxU, b2maxV, b2minV);
        GlStateManager.func_179121_F();
        if (initialMaxAngle < 360.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.05, (double)(innerRadius + borderWidth), (double)0.0);
            GL11.glBegin((int)7);
            borderLength = radius - innerRadius;
            requiredSegments = borderLength / wrapRadius;
            diffV = b3maxV - b3minV;
            vPerSegment = MathHelper.func_151237_a((double)(diffV * requiredSegments), (double)0.0, (double)diffV);
            for (i = 0; i < MathHelper.func_76143_f((double)requiredSegments); ++i) {
                renderInnerRadius = borderLength / requiredSegments * (double)i;
                renderOuterRadius = borderLength / requiredSegments * (double)(i + 1);
                segmentLength = renderOuterRadius - renderInnerRadius;
                if (renderInnerRadius > borderLength - borderWidth * 2.0) break;
                if (renderOuterRadius > borderLength - borderWidth * 2.0) {
                    renderOuterRadius = borderLength - borderWidth * 2.0;
                }
                textureV = b3minV;
                textureVOuter = b3minV + vPerSegment / segmentLength * (renderOuterRadius - renderInnerRadius);
                if (vPerSegment < diffV) {
                    textureVOuter = b1minV + diffV / segmentLength * (renderOuterRadius - renderInnerRadius);
                }
                GL11.glTexCoord2d((double)b3minU, (double)textureV);
                GL11.glVertex2d((double)0.0, (double)renderInnerRadius);
                GL11.glTexCoord2d((double)b3maxU, (double)textureV);
                GL11.glVertex2d((double)(-borderWidth), (double)renderInnerRadius);
                GL11.glTexCoord2d((double)b3maxU, (double)textureVOuter);
                GL11.glVertex2d((double)(-borderWidth), (double)renderOuterRadius);
                GL11.glTexCoord2d((double)b3minU, (double)textureVOuter);
                GL11.glVertex2d((double)0.0, (double)renderOuterRadius);
            }
            GL11.glEnd();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GuiUtils.renderTexturedCircleSegment(segments, innerSegmentMaxAngle, wrapAngleInner, innerRadius + borderWidth + 0.05, innerRadius, b4minU, b4maxU, b4maxV, b4minV);
        GlStateManager.func_179121_F();
        if (initialMaxAngle < 360.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)((float)(-maxAngle + borderAngle * 2.0)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)innerRadius, (double)0.0);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)c1maxU, (double)c1maxV);
            GL11.glVertex2d((double)0.0, (double)borderWidth);
            GL11.glTexCoord2d((double)c1minU, (double)c1maxV);
            GL11.glVertex2d((double)borderWidth, (double)borderWidth);
            GL11.glTexCoord2d((double)c1minU, (double)c1minV);
            GL11.glVertex2d((double)borderWidth, (double)0.0);
            GL11.glTexCoord2d((double)c1maxU, (double)c1minV);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glEnd();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)((float)(-maxAngle + borderAngle * 2.0)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)innerRadius, (double)0.0);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)c2maxU, (double)c2minV);
            GL11.glVertex2d((double)0.0, (double)(radius - innerRadius));
            GL11.glTexCoord2d((double)c2minU, (double)c2minV);
            GL11.glVertex2d((double)borderWidth, (double)(radius - innerRadius));
            GL11.glTexCoord2d((double)c2minU, (double)c2maxV);
            GL11.glVertex2d((double)borderWidth, (double)(radius - innerRadius - borderWidth));
            GL11.glTexCoord2d((double)c2maxU, (double)c2maxV);
            GL11.glVertex2d((double)0.0, (double)(radius - innerRadius - borderWidth));
            GL11.glEnd();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-borderWidth), (double)innerRadius, (double)0.0);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)c3minU, (double)c3minV);
            GL11.glVertex2d((double)0.0, (double)(radius - innerRadius));
            GL11.glTexCoord2d((double)c3maxU, (double)c3minV);
            GL11.glVertex2d((double)borderWidth, (double)(radius - innerRadius));
            GL11.glTexCoord2d((double)c3maxU, (double)c3maxV);
            GL11.glVertex2d((double)borderWidth, (double)(radius - innerRadius - borderWidth));
            GL11.glTexCoord2d((double)c3minU, (double)c3maxV);
            GL11.glVertex2d((double)0.0, (double)(radius - innerRadius - borderWidth));
            GL11.glEnd();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-borderWidth), (double)innerRadius, (double)0.0);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)c4minU, (double)c4maxV);
            GL11.glVertex2d((double)0.0, (double)borderWidth);
            GL11.glTexCoord2d((double)c4maxU, (double)c4maxV);
            GL11.glVertex2d((double)borderWidth, (double)borderWidth);
            GL11.glTexCoord2d((double)c4maxU, (double)c4minV);
            GL11.glVertex2d((double)borderWidth, (double)0.0);
            GL11.glTexCoord2d((double)c4minU, (double)c4minV);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glEnd();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    public static void saveFboToFile(File file, Framebuffer fbo) {
        int prevFBO = GL11.glGetInteger((int)36006);
        fbo.func_147610_a(false);
        GL11.glReadBuffer((int)1028);
        int width = fbo.field_147621_c;
        int height = fbo.field_147618_d;
        int bpp = 4;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * bpp));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        String format = "PNG";
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int i = (x + width * y) * bpp;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                image.setRGB(x, height - (y + 1), a << 24 | r << 16 | g << 8 | b);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153199_f, (int)prevFBO);
    }
}

