/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AdvancedStateMap
extends StateMapperBase {
    private final Function<PropertiesMap, String> nameMapper;
    private final String suffix;
    private final List<IProperty<?>> ignored;
    private final Map<IProperty<?>, Function<?, String>> suffixProperties;
    private final List<Function<UnmodifiablePropertiesMap, List<IProperty<?>>>> suffixExclusions;
    private final List<Function<UnmodifiablePropertiesMap, List<IProperty<?>>>> propertyExclusions;

    private AdvancedStateMap(@Nullable Function<PropertiesMap, String> nameMapper, @Nullable String suffix, List<IProperty<?>> ignored, Map<IProperty<?>, Function<?, String>> suffixProperties, List<Function<UnmodifiablePropertiesMap, List<IProperty<?>>>> suffixExclusions, List<Function<UnmodifiablePropertiesMap, List<IProperty<?>>>> propertyExclusions) {
        this.nameMapper = nameMapper;
        this.suffix = suffix;
        this.ignored = ignored;
        this.suffixProperties = suffixProperties;
        this.suffixExclusions = suffixExclusions;
        this.propertyExclusions = propertyExclusions;
    }

    protected ModelResourceLocation func_178132_a(IBlockState state) {
        LinkedHashMap propertiesMap = Maps.newLinkedHashMap((Map)state.func_177228_b());
        UnmodifiablePropertiesMap wrappedPropertiesMap = new UnmodifiablePropertiesMap(propertiesMap);
        PropertiesMap wrappedPropertiesMapModifiable = new PropertiesMap(propertiesMap);
        String fileName = this.nameMapper == null ? ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString() : String.format("%s:%s", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b(), this.nameMapper.apply(wrappedPropertiesMapModifiable));
        if (this.suffix != null) {
            fileName = fileName + this.suffix;
        }
        ArrayList suffixExclusions = new ArrayList();
        for (Function<UnmodifiablePropertiesMap, List<IProperty<?>>> function : this.suffixExclusions) {
            List<IProperty<?>> list = function.apply(wrappedPropertiesMap);
            for (IProperty<?> iProperty : list) {
                if (suffixExclusions.contains(iProperty)) continue;
                suffixExclusions.add(iProperty);
            }
        }
        ArrayList propertyExclusions = new ArrayList();
        for (Function<UnmodifiablePropertiesMap, List<IProperty<?>>> function : this.propertyExclusions) {
            List<IProperty<?>> list = function.apply(wrappedPropertiesMap);
            for (IProperty<?> excludedProperty : list) {
                if (propertyExclusions.contains(excludedProperty)) continue;
                propertyExclusions.add(excludedProperty);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            String mappedName;
            Function<?, String> function;
            if (suffixExclusions.contains(entry.getKey()) || (function = this.suffixProperties.get(entry.getKey())) == null || (mappedName = function.apply(entry.getValue())) == null) continue;
            arrayList.add(mappedName);
        }
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList);
            StringBuilder stringBuilder = new StringBuilder(fileName);
            for (String string : arrayList) {
                stringBuilder.append("_").append(string);
            }
            fileName = stringBuilder.toString();
        }
        for (IProperty iProperty : propertyExclusions) {
            propertiesMap.remove(iProperty);
        }
        for (IProperty<?> iProperty : this.ignored) {
            propertiesMap.remove(iProperty);
        }
        return new ModelResourceLocation(fileName, this.func_178131_a(propertiesMap));
    }

    public static class PropertiesMap
    extends UnmodifiablePropertiesMap {
        protected PropertiesMap(Map<IProperty<?>, Comparable<?>> propertiesMap) {
            super(propertiesMap);
        }

        public <T extends Comparable<T>> T remove(IProperty<T> property) {
            return (T)((Comparable)this.propertiesMap.remove(property));
        }
    }

    public static class UnmodifiablePropertiesMap {
        protected final Map<IProperty<?>, Comparable<?>> propertiesMap;

        protected UnmodifiablePropertiesMap(Map<IProperty<?>, Comparable<?>> propertiesMap) {
            this.propertiesMap = propertiesMap;
        }

        public <T extends Comparable<T>> T getValue(IProperty<T> property) {
            return (T)this.propertiesMap.get(property);
        }

        public Set<IProperty<?>> getProperties() {
            return this.propertiesMap.keySet();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private Function<PropertiesMap, String> nameMapper;
        private String suffix;
        private final List<IProperty<?>> ignored = Lists.newArrayList();
        private final Map<IProperty<?>, Function<?, String>> suffixProperties = new HashMap();
        private final List<Function<UnmodifiablePropertiesMap, List<IProperty<?>>>> suffixExclusions = new ArrayList();
        private final List<Function<UnmodifiablePropertiesMap, List<IProperty<?>>>> propertyExclusions = new ArrayList();

        public <T extends Comparable<T>> Builder withName(IProperty<T> property) {
            this.withName((PropertiesMap map) -> property.func_177702_a(map.remove(property)));
            return this;
        }

        public Builder withName(Function<PropertiesMap, String> mapper) {
            this.nameMapper = mapper;
            return this;
        }

        public Builder withSuffix(String builderSuffixIn) {
            this.suffix = builderSuffixIn;
            return this;
        }

        public <T extends Comparable<T>> Builder withPropertySuffix(IProperty<T> property, Function<T, String> nameMapper) {
            this.suffixProperties.put(property, nameMapper);
            return this;
        }

        public Builder withPropertySuffix(IProperty<Boolean> property, String nameFalse, String nameTrue) {
            return this.withPropertySuffix(property, bool -> bool != false ? nameTrue : nameFalse);
        }

        public Builder withPropertySuffixTrue(IProperty<Boolean> property, String nameTrue) {
            return this.withPropertySuffix(property, b -> b != false ? nameTrue : null);
        }

        public Builder withPropertySuffixFalse(IProperty<Boolean> property, String nameFalse) {
            return this.withPropertySuffix(property, b -> b == false ? nameFalse : null);
        }

        public Builder withPropertySuffixExclusions(Function<UnmodifiablePropertiesMap, List<IProperty<?>>> exclusions) {
            this.suffixExclusions.add(exclusions);
            return this;
        }

        public Builder withPropertyExclusions(Function<UnmodifiablePropertiesMap, List<IProperty<?>>> exclusions) {
            this.propertyExclusions.add(exclusions);
            return this;
        }

        public Builder ignore(IProperty<?> ... properties) {
            Collections.addAll(this.ignored, properties);
            return this;
        }

        public AdvancedStateMap build() {
            return new AdvancedStateMap(this.nameMapper, this.suffix, this.ignored, this.suffixProperties, this.suffixExclusions, this.propertyExclusions);
        }
    }
}

