/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.core.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class TransformerModule {
    private boolean successful = false;
    private final List<Pair<String, String>> acceptedClasses = new ArrayList<Pair<String, String>>();
    private boolean obfuscated = false;

    protected final void addAcceptedClass(String obfName, String deobfName) {
        this.acceptedClasses.add((Pair<String, String>)Pair.of((Object)obfName, (Object)deobfName));
    }

    public abstract String getName();

    public void reset() {
        this.successful = false;
    }

    public final boolean acceptsClass(String className) {
        for (Pair<String, String> acceptedClass : this.acceptedClasses) {
            if (((String)acceptedClass.getKey()).equals(className)) {
                this.obfuscated = true;
                return true;
            }
            if (!((String)acceptedClass.getValue()).equals(className)) continue;
            this.obfuscated = false;
            return true;
        }
        return false;
    }

    public boolean acceptsMethod(MethodNode method) {
        return false;
    }

    public void transformClass(ClassNode classNode) {
    }

    public void transformMethod(MethodNode method) {
    }

    public int transformMethodInstruction(MethodNode method, AbstractInsnNode node, int index) {
        return 0;
    }

    protected final void setSuccessful() {
        this.successful = true;
    }

    public final boolean wasSuccessful() {
        return this.successful;
    }

    public final boolean isObfuscated() {
        return this.obfuscated;
    }

    protected final String getMappedName(String obfName, String deofName) {
        return this.isObfuscated() ? obfName : deofName;
    }

    protected final void insertBefore(MethodNode method, AbstractInsnNode insn, Collection<? extends AbstractInsnNode> toInsert) {
        for (AbstractInsnNode abstractInsnNode : toInsert) {
            method.instructions.insertBefore(insn, abstractInsnNode);
        }
    }

    protected final void insertAfter(MethodNode method, AbstractInsnNode insn, Collection<? extends AbstractInsnNode> toInsert) {
        for (AbstractInsnNode abstractInsnNode : toInsert) {
            method.instructions.insert(insn, abstractInsnNode);
        }
    }
}

