/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.core;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import thebetweenlands.core.module.PreRenderShadersHookTransformer;
import thebetweenlands.core.module.TransformerModule;

public class TheBetweenlandsClassTransformer
implements IClassTransformer {
    public static boolean constructed;
    private static final List<TransformerModule> modules;

    public TheBetweenlandsClassTransformer() {
        constructed = true;
    }

    public static void registerModule(TransformerModule module) {
        modules.add(module);
    }

    public static List<TransformerModule> getModules() {
        return ImmutableList.copyOf(modules);
    }

    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        ArrayList<TransformerModule> currentClassModules = new ArrayList<TransformerModule>();
        for (TransformerModule transformerModule : modules) {
            if (!transformerModule.acceptsClass(name)) continue;
            transformerModule.reset();
            currentClassModules.add(transformerModule);
        }
        ClassNode classNode = null;
        if (!currentClassModules.isEmpty()) {
            classNode = this.readClass(classBytes);
            for (TransformerModule module : currentClassModules) {
                module.transformClass(classNode);
            }
            ArrayList<TransformerModule> arrayList = new ArrayList<TransformerModule>();
            for (MethodNode method : classNode.methods) {
                arrayList.clear();
                for (TransformerModule module : currentClassModules) {
                    if (module.wasSuccessful() || !module.acceptsMethod(method)) continue;
                    module.transformMethod(method);
                    arrayList.add(module);
                }
                for (int i = 0; i < method.instructions.size(); ++i) {
                    AbstractInsnNode insnNode = method.instructions.get(i);
                    for (TransformerModule module : arrayList) {
                        if (module.wasSuccessful()) continue;
                        i += module.transformMethodInstruction(method, insnNode, i);
                    }
                }
            }
            TheBetweenlandsClassTransformer.checkModules(currentClassModules);
        }
        return classNode == null ? classBytes : this.writeClass(classNode);
    }

    public static void checkModules() {
        TheBetweenlandsClassTransformer.checkModules(modules);
    }

    private static void checkModules(List<TransformerModule> modules) {
        for (TransformerModule module : modules) {
            if (module.wasSuccessful()) continue;
            throw new ClassTransformationException(String.format("Transformer module %s failed", module.getName()));
        }
    }

    private ClassNode readClass(byte[] classBytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] writeClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    static {
        modules = new ArrayList<TransformerModule>();
        TheBetweenlandsClassTransformer.registerModule(new PreRenderShadersHookTransformer());
    }

    private static class ClassTransformationException
    extends RuntimeException {
        private static final long serialVersionUID = -6506110261102379179L;

        public ClassTransformationException(String str) {
            super(str);
        }
    }
}

