/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.compost;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.CompostRecipe;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.TranslationHelper;

public class CompostRecipeJEI
extends BlankRecipeWrapper {
    private ItemStack input;
    private int compostAmount;
    private int compostTime;
    public static String processTimeString = "jei.thebetweenlands.time";
    public static String processTimeMinutesString = "jei.thebetweenlands.time.minutes";
    public static String processTimeSecondsString = "jei.thebetweenlands.time.seconds";

    public CompostRecipeJEI(CompostRecipe recipe) {
        this.input = recipe.getInput();
        this.compostAmount = recipe.getCompostAmount(this.input);
        this.compostTime = recipe.getCompostingTime(this.input);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.input);
        ingredients.setOutput(ItemStack.class, (Object)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.COMPOST.getID()));
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> processTooltip = new ArrayList<String>();
        if (mouseX >= 18 && mouseX <= 39 && mouseY >= 3 && mouseY <= 18) {
            int minutes = this.compostTime / 20 / 60;
            int seconds = this.compostTime / 20 % 60;
            processTooltip.add(seconds > 0 && minutes > 0 ? TranslationHelper.translateToLocal(processTimeString, minutes, seconds) : (minutes > 0 ? TranslationHelper.translateToLocal(processTimeMinutesString, minutes) : TranslationHelper.translateToLocal(processTimeSecondsString, seconds)));
            processTooltip.add(TranslationHelper.translateToLocal("jei.thebetweenlands.compost.amount", this.compostAmount));
        }
        return processTooltip;
    }
}

