/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.animator;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.TranslationHelper;

public class AnimatorRecipeJEI
extends BlankRecipeWrapper {
    private final ItemStack input;
    private int requiredFuel;
    private int requiredLife;
    private ItemStack result = null;
    private String entityName = null;
    private ResourceLocation lootTableName = null;
    private World world = null;

    public AnimatorRecipeJEI(AnimatorRecipe animatorRecipe) {
        this.input = animatorRecipe.getInput();
        this.requiredFuel = animatorRecipe.getRequiredFuel(this.input);
        this.requiredLife = animatorRecipe.getRequiredLife(this.input);
        this.result = animatorRecipe.getResult(this.input);
        this.lootTableName = animatorRecipe.getLootTable();
        if (animatorRecipe.getSpawnEntityClass(this.input) != null) {
            Entity entity = null;
            try {
                entity = animatorRecipe.getSpawnEntityClass(this.input).getConstructor(World.class).newInstance(Minecraft.func_71410_x().field_71441_e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (entity != null) {
                this.entityName = entity.func_70005_c_();
            }
        }
    }

    public AnimatorRecipeJEI(AnimatorRecipe animatorRecipe, World world) {
        this(animatorRecipe);
        this.world = world;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        l.add(this.input);
        l.add(new ItemStack(ItemRegistry.LIFE_CRYSTAL));
        l.add(ItemMisc.EnumItemMisc.SULFUR.create(1));
        ingredients.setInputs(ItemStack.class, l);
        if (this.result != null) {
            ingredients.setOutput(ItemStack.class, (Object)this.result);
        }
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> processTooltip = new ArrayList<String>();
        if (mouseX >= 18 && mouseX <= 51 && mouseY >= 42 && mouseY <= 66) {
            processTooltip.add(TranslationHelper.translateToLocal("jei.thebetweenlands.animator.life", this.requiredLife));
        }
        if (mouseX >= 57 && mouseX <= 90 && mouseY >= 42 && mouseY <= 66) {
            processTooltip.add(TranslationHelper.translateToLocal("jei.thebetweenlands.animator.fuel", this.requiredFuel));
        }
        if (this.entityName != null && mouseX >= 19 && mouseX <= 35 && mouseY >= 16 && mouseY <= 32) {
            processTooltip.add(TranslationHelper.translateToLocal("jei.thebetweenlands.animator.entity_spawn", this.entityName));
        }
        return processTooltip;
    }
}

