/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei;

import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import thebetweenlands.client.gui.inventory.GuiWeedwoodWorkbench;
import thebetweenlands.common.inventory.container.ContainerWeedwoodWorkbench;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.compat.jei.DynamicJEIRecipeHandler;
import thebetweenlands.compat.jei.recipes.animator.AnimatorRecipeCategory;
import thebetweenlands.compat.jei.recipes.animator.AnimatorRecipeHandler;
import thebetweenlands.compat.jei.recipes.animator.AnimatorRecipeMaker;
import thebetweenlands.compat.jei.recipes.compost.CompostRecipeCategory;
import thebetweenlands.compat.jei.recipes.compost.CompostRecipeHandler;
import thebetweenlands.compat.jei.recipes.compost.CompostRecipeMaker;
import thebetweenlands.compat.jei.recipes.druid_altar.DruidAltarHandler;
import thebetweenlands.compat.jei.recipes.druid_altar.DruidAltarRecipeCategory;
import thebetweenlands.compat.jei.recipes.druid_altar.DruidAltarRecipeMaker;
import thebetweenlands.compat.jei.recipes.pam.PestleAndMortarCategory;
import thebetweenlands.compat.jei.recipes.pam.PestleAndMortarHandler;
import thebetweenlands.compat.jei.recipes.pam.PestleAndMortarRecipeMaker;
import thebetweenlands.compat.jei.recipes.purifier.PurifierRecipeCategory;
import thebetweenlands.compat.jei.recipes.purifier.PurifierRecipeHandler;
import thebetweenlands.compat.jei.recipes.purifier.PurifierRecipeMaker;

@JEIPlugin
public class BetweenlandsJEIPlugin
extends BlankModPlugin {
    public static IJeiHelpers jeiHelper;
    public static IJeiRuntime jeiRuntime;

    public void register(IModRegistry registry) {
        MinecraftForge.EVENT_BUS.register(DynamicJEIRecipeHandler.class);
        jeiHelper = registry.getJeiHelpers();
        registry.addRecipeHandlers(new IRecipeHandler[]{new CompostRecipeHandler(), new AnimatorRecipeHandler(), new DruidAltarHandler(), new PestleAndMortarHandler(), new PurifierRecipeHandler()});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(), new AnimatorRecipeCategory(), new DruidAltarRecipeCategory(), new PestleAndMortarCategory(), new PurifierRecipeCategory()});
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.COMPOST_BIN), new String[]{"thebetweenlands:compost"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.ANIMATOR), new String[]{"thebetweenlands:animator"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.DRUID_ALTAR), new String[]{"thebetweenlands:druid_altar"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.MORTAR), new String[]{"thebetweenlands:pestle_and_mortar"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.PURIFIER), new String[]{"thebetweenlands:purifier"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.WEEDWOOD_WORKBENCH), new String[]{"minecraft.crafting"});
        registry.addRecipes(CompostRecipeMaker.getRecipes());
        registry.addRecipes(AnimatorRecipeMaker.getRecipes());
        registry.addRecipes(DruidAltarRecipeMaker.getRecipes());
        registry.addRecipes(PestleAndMortarRecipeMaker.getRecipes());
        registry.addRecipes(PurifierRecipeMaker.getRecipes());
        IRecipeTransferRegistry recipeTranferRegistry = registry.getRecipeTransferRegistry();
        registry.addRecipeClickArea(GuiWeedwoodWorkbench.class, 88, 32, 28, 23, new String[]{"minecraft.crafting"});
        recipeTranferRegistry.addRecipeTransferHandler(ContainerWeedwoodWorkbench.class, "minecraft.crafting", 1, 9, 10, 36);
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        jeiRuntime = runtime;
        System.out.println("runtime available, yay!");
    }
}

