/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.teleporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.block.structure.BlockTreePortal;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.structure.WorldGenWeedwoodPortalTree;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.location.LocationPortal;
import thebetweenlands.util.config.ConfigHandler;

public final class TeleporterBetweenlands
extends Teleporter {
    private final World targetWorld;

    public TeleporterBetweenlands(WorldServer worldServer) {
        super(worldServer);
        this.targetWorld = worldServer;
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        if (!this.func_180620_b(entity, rotationYaw) && !this.func_85188_a(entity)) {
            BlockPos pos = this.findSuitablePortalPos(entity.func_180425_c());
            Chunk chunk = this.targetWorld.func_175726_f(pos);
            pos = new BlockPos(pos.func_177958_n(), chunk.func_177433_f(pos), pos.func_177952_p());
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    for (int yo = 0; yo <= 2; ++yo) {
                        this.targetWorld.func_175698_g(pos.func_177982_a(xo, yo, zo));
                    }
                }
            }
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rotationYaw, 0.0f);
            this.setDefaultPlayerSpawnLocation(entity);
        }
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        BlockPos existingPortal = this.findExistingPortalPos(entity);
        if (existingPortal != null) {
            entity.func_70012_b((double)existingPortal.func_177958_n() + 0.5, (double)existingPortal.func_177956_o() + 3.0, (double)existingPortal.func_177952_p() + 0.5, rotationYaw, 0.0f);
            this.setDefaultPlayerSpawnLocation(entity);
            return true;
        }
        return false;
    }

    @Nullable
    protected BlockPos findExistingPortalPos(Entity entity) {
        LocationPortal otherPortal;
        LocationPortal portal = this.getPortalLocation(entity);
        if (portal != null && (otherPortal = this.getOtherPortalLocation(portal.getOtherPortalPosition())) != null) {
            return otherPortal.getPortalPosition();
        }
        return null;
    }

    @Nullable
    protected LocationPortal getPortalLocation(Entity entity) {
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(entity.field_70170_p);
        AxisAlignedBB aabb = entity.func_174813_aQ();
        List<LocationPortal> portals = worldStorage.getSharedStorageAt(LocationPortal.class, loc -> loc.intersects(aabb), aabb);
        this.validatePortals(portals);
        if (!portals.isEmpty()) {
            return portals.get(0);
        }
        return null;
    }

    @Nullable
    protected LocationPortal getOtherPortalLocation(@Nullable BlockPos pos) {
        if (pos != null) {
            BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(this.targetWorld);
            List<LocationPortal> otherPortals = worldStorage.getSharedStorageAt(LocationPortal.class, loc -> loc.getPortalPosition().equals((Object)pos), pos.func_177958_n(), pos.func_177952_p());
            this.validatePortals(otherPortals);
            if (!otherPortals.isEmpty()) {
                return otherPortals.get(0);
            }
        }
        return null;
    }

    protected void validatePortals(List<LocationPortal> portals) {
        Iterator<LocationPortal> it = portals.iterator();
        while (it.hasNext()) {
            LocationPortal portal = it.next();
            if (this.checkPortal(portal)) continue;
            portal.getWorldStorage().removeSharedStorage(portal);
            it.remove();
        }
    }

    protected boolean checkPortal(LocationPortal portal) {
        World world = portal.getWorldStorage().getWorld();
        AxisAlignedBB aabb = portal.getBounds().get(0);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = MathHelper.func_76128_c((double)aabb.field_72340_a); x <= MathHelper.func_76128_c((double)aabb.field_72336_d); ++x) {
            for (int y = MathHelper.func_76128_c((double)aabb.field_72338_b); y <= MathHelper.func_76128_c((double)aabb.field_72337_e); ++y) {
                for (int z = MathHelper.func_76128_c((double)aabb.field_72339_c); z <= MathHelper.func_76128_c((double)aabb.field_72334_f); ++z) {
                    pos.func_181079_c(x, y, z);
                    IBlockState blockState = world.func_180495_p((BlockPos)pos);
                    if (!(blockState.func_177230_c() instanceof BlockTreePortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected BlockPos findSuitablePortalPos(BlockPos start) {
        ArrayList<BiomeBetweenlands> validBiomes = new ArrayList<BiomeBetweenlands>();
        validBiomes.add(BiomeRegistry.SWAMPLANDS);
        validBiomes.add(BiomeRegistry.PATCHY_ISLANDS);
        BlockPos suitablePos = this.targetWorld.func_72959_q().func_180630_a(start.func_177958_n(), start.func_177952_p(), 256, validBiomes, this.targetWorld.field_73012_v);
        BlockPos selectedPos = suitablePos != null ? suitablePos : start;
        Chunk chunk = this.targetWorld.func_175726_f(selectedPos);
        int height = chunk.func_177433_f(selectedPos);
        return new BlockPos(selectedPos.func_177958_n(), height, selectedPos.func_177952_p());
    }

    public boolean func_85188_a(Entity entity) {
        BlockPos genPos = this.findSuitablePortalPos(entity.func_180425_c());
        int checkRadius = 64;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        WorldGenWeedwoodPortalTree genTree = new WorldGenWeedwoodPortalTree();
        int xo = 0;
        int zo = 0;
        int[] dir = new int[]{0, -1};
        for (int i = (int)Math.pow(checkRadius * 2, 2.0); i > 0; --i) {
            if (-checkRadius < xo && xo <= checkRadius && -checkRadius < zo && zo <= checkRadius) {
                checkPos.func_181079_c(genPos.func_177958_n() + xo, 64, genPos.func_177952_p() + zo);
                Chunk chunk = this.targetWorld.func_175726_f((BlockPos)checkPos);
                checkPos.func_185336_p(chunk.func_177433_f((BlockPos)checkPos) - 1);
                if (SurfaceType.MIXED_GROUND.matches(this.targetWorld.func_180495_p((BlockPos)checkPos)) && this.targetWorld.func_175623_d(checkPos.func_177984_a()) && this.canGenerate(this.targetWorld, (BlockPos)checkPos) && genTree.func_180709_b(this.targetWorld, this.targetWorld.field_73012_v, checkPos.func_185334_h())) {
                    BetweenlandsWorldData worldStorage;
                    List<LocationPortal> newPortals;
                    LocationPortal portal = this.getPortalLocation(entity);
                    if (portal != null && !(newPortals = (worldStorage = BetweenlandsWorldData.forWorld(this.targetWorld)).getSharedStorageAt(LocationPortal.class, loc -> loc.isInside((Vec3i)checkPos.func_177984_a()), checkPos.func_177984_a().func_177958_n(), checkPos.func_177984_a().func_177952_p())).isEmpty()) {
                        LocationPortal newPortal = newPortals.get(0);
                        newPortal.setOtherPortalPosition(portal.getPortalPosition());
                        portal.setOtherPortalPosition(newPortal.getPortalPosition());
                    }
                    entity.func_70012_b((double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o() + 4.0, (double)checkPos.func_177952_p() + 0.5, entity.field_70177_z, 0.0f);
                    this.setDefaultPlayerSpawnLocation(entity);
                    return true;
                }
            }
            if (xo == zo || xo < 0 && xo == -zo || xo > 0 && xo == 1 - zo) {
                int d0 = dir[0];
                dir[0] = -dir[1];
                dir[1] = d0;
            }
            xo += dir[0];
            zo += dir[1];
        }
        return false;
    }

    protected boolean canGenerate(World world, BlockPos pos) {
        int height = 16;
        int maxRadius = 8;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int xo = -maxRadius; xo <= maxRadius; ++xo) {
            for (int zo = -maxRadius; zo <= maxRadius; ++zo) {
                for (int yo = 2; yo < height; ++yo) {
                    checkPos.func_181079_c(pos.func_177958_n() + xo, pos.func_177956_o() + yo, pos.func_177952_p() + zo);
                    IBlockState blockState = world.func_180495_p((BlockPos)checkPos);
                    if (!blockState.func_185904_a().func_76224_d() && !blockState.func_185915_l() && !(blockState.func_177230_c() instanceof BlockLeaves)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setDefaultPlayerSpawnLocation(Entity entity) {
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        BlockPos coords = player.getBedLocation(ConfigHandler.dimensionId);
        if (coords == null) {
            coords = player.func_180425_c();
            int spawnFuzz = 64;
            int spawnFuzzHalf = spawnFuzz / 2;
            BlockPos spawnPlace = this.targetWorld.func_175672_r(coords.func_177982_a(this.targetWorld.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf, 0, this.targetWorld.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf));
            player.setSpawnChunk(spawnPlace, true, ConfigHandler.dimensionId);
        }
    }

    public void func_85189_a(long timer) {
    }
}

