/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared.location.guard;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import thebetweenlands.common.world.storage.world.shared.location.guard.ILocationGuard;

public class BlockLocationGuard
implements ILocationGuard {
    protected final Long2ObjectMap<GuardChunk> chunkMap = new Long2ObjectOpenHashMap(16);

    @Nullable
    public GuardChunk getChunk(BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        long id = ChunkPos.func_77272_a((int)(x / 16), (int)(z / 16));
        return (GuardChunk)this.chunkMap.get(id);
    }

    @Nullable
    public GuardChunkSection getSection(BlockPos pos) {
        GuardChunk chunk = this.getChunk(pos);
        if (chunk != null) {
            return chunk.getSection(pos.func_177956_o());
        }
        return null;
    }

    @Override
    public void setGuarded(World world, BlockPos pos, boolean guarded) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        long id = ChunkPos.func_77272_a((int)(x / 16), (int)(z / 16));
        GuardChunk chunk = (GuardChunk)this.chunkMap.get(id);
        if (guarded) {
            if (chunk == null) {
                chunk = new GuardChunk(x / 16, z / 16);
                this.chunkMap.put(id, (Object)chunk);
            }
            chunk.setGuarded(x & 0xF, y, z & 0xF, true);
        } else if (chunk != null) {
            chunk.setGuarded(x & 0xF, y, z & 0xF, false);
        }
    }

    @Override
    public boolean isGuarded(World world, @Nullable Entity entity, BlockPos pos) {
        if (pos.func_177956_o() >= 0) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            long id = ChunkPos.func_77272_a((int)(x / 16), (int)(z / 16));
            GuardChunk chunk = (GuardChunk)this.chunkMap.get(id);
            if (chunk != null && chunk.isGuarded(x & 0xF, y, z & 0xF)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear(World world) {
        this.chunkMap.clear();
    }

    @Override
    public void handleExplosion(World world, Explosion explosion) {
        explosion.func_180342_d();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList chunksList = new NBTTagList();
        for (GuardChunk chunk : this.chunkMap.values()) {
            NBTTagCompound chunkNbt = new NBTTagCompound();
            chunkNbt.func_74768_a("X", chunk.x);
            chunkNbt.func_74768_a("Z", chunk.z);
            chunk.writeToNBT(chunkNbt);
            chunksList.func_74742_a((NBTBase)chunkNbt);
        }
        nbt.func_74782_a("Chunks", (NBTBase)chunksList);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.chunkMap.clear();
        if (nbt.func_150297_b("Chunks", 9)) {
            NBTTagList chunksList = nbt.func_150295_c("Chunks", 10);
            for (int i = 0; i < chunksList.func_74745_c(); ++i) {
                NBTTagCompound chunkNbt = chunksList.func_150305_b(i);
                int x = chunkNbt.func_74762_e("X");
                int z = chunkNbt.func_74762_e("Z");
                GuardChunk chunk = new GuardChunk(x, z);
                chunk.readFromNBT(chunkNbt);
                this.chunkMap.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
            }
        }
    }

    public static class GuardChunk {
        private final GuardChunkSection[] sections = new GuardChunkSection[16];
        public final int x;
        public final int z;

        private GuardChunk(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public GuardChunkSection getSection(int y) {
            return this.sections[y >> 4];
        }

        public void setGuarded(int x, int y, int z, boolean guarded) {
            if (y >= 0 && y < 256) {
                GuardChunkSection section = this.sections[y >> 4];
                if (guarded) {
                    if (section == null) {
                        this.sections[y >> 4] = section = new GuardChunkSection();
                    }
                    section.setGuarded(x, y & 0xF, z, true);
                } else if (section != null) {
                    section.setGuarded(x, y & 0xF, z, false);
                    if (section.isEmpty()) {
                        this.sections[y >> 4] = null;
                    }
                }
            }
        }

        public boolean isGuarded(int x, int y, int z) {
            GuardChunkSection section;
            int sectionId = y >> 4;
            return sectionId >= 0 && (section = this.sections[sectionId]) != null && section.isGuarded(x, y & 0xF, z);
        }

        public void clear() {
            for (int i = 0; i < this.sections.length; ++i) {
                this.sections[i] = null;
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            NBTTagList sectionsNbt = new NBTTagList();
            for (int i = 0; i < this.sections.length; ++i) {
                GuardChunkSection section = this.sections[i];
                if (section == null) continue;
                byte[] data = new byte[512];
                section.writeData(data);
                NBTTagCompound sectionNbt = new NBTTagCompound();
                sectionNbt.func_74774_a("Y", (byte)i);
                sectionNbt.func_74773_a("Data", data);
                sectionsNbt.func_74742_a((NBTBase)sectionNbt);
            }
            nbt.func_74782_a("Sections", (NBTBase)sectionsNbt);
            return nbt;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.clear();
            if (nbt.func_150297_b("Sections", 9)) {
                NBTTagList sectionsNbt = nbt.func_150295_c("Sections", 10);
                for (int i = 0; i < sectionsNbt.func_74745_c(); ++i) {
                    NBTTagCompound sectionNbt = sectionsNbt.func_150305_b(i);
                    byte y = sectionNbt.func_74771_c("Y");
                    byte[] data = sectionNbt.func_74770_j("Data");
                    this.sections[y] = new GuardChunkSection(data);
                }
            }
        }
    }

    public static class GuardChunkSection {
        private final byte[] data;
        private int blockRefCount = 0;

        private GuardChunkSection() {
            this.data = new byte[512];
        }

        private GuardChunkSection(byte[] data) {
            this.data = data;
            this.updateBlockRefCount();
        }

        protected int getByteIndex(int x, int y, int z) {
            return (x >> 3) + (z << 1) + (y << 5);
        }

        public void updateBlockRefCount() {
            this.blockRefCount = 0;
            for (int i = 0; i < this.data.length; ++i) {
                this.blockRefCount += Integer.bitCount(this.data[i] & 0xFF);
            }
        }

        public int getBlockRefCount() {
            return this.blockRefCount;
        }

        public void setGuarded(int x, int y, int z, boolean guarded) {
            byte mask;
            int byteIndex = this.getByteIndex(x, y, z);
            byte data = this.data[byteIndex];
            if ((data & (mask = (byte)(1 << (x & 7)))) != 0 != guarded) {
                this.data[byteIndex] = (byte)(guarded ? data | mask : data & ~mask);
                this.blockRefCount = guarded ? ++this.blockRefCount : --this.blockRefCount;
            }
        }

        public boolean isGuarded(int x, int y, int z) {
            byte mask;
            int byteIndex = this.getByteIndex(x, y, z);
            return (this.data[byteIndex] & (mask = (byte)(1 << (x & 7)))) != 0;
        }

        public boolean isEmpty() {
            return this.blockRefCount == 0;
        }

        public void clear() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = 0;
            }
        }

        public void loadData(byte[] arr) {
            System.arraycopy(arr, 0, this.data, 0, 512);
            this.updateBlockRefCount();
        }

        public void writeData(byte[] arr) {
            System.arraycopy(this.data, 0, arr, 0, 512);
        }
    }
}

