/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;
import thebetweenlands.common.world.storage.world.shared.BetweenlandsSharedStorage;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationAmbience;
import thebetweenlands.common.world.storage.world.shared.location.guard.ILocationGuard;

public class LocationStorage
extends BetweenlandsSharedStorage {
    private List<AxisAlignedBB> boundingBoxes = new ArrayList<AxisAlignedBB>();
    private AxisAlignedBB enclosingBoundingBox;
    private String name;
    private EnumLocationType type;
    private int layer;
    private LocationAmbience ambience = null;
    private boolean visible = true;
    private boolean inheritAmbience = true;
    private long locationSeed = 0L;
    private static final Comparator<LocationStorage> LAYER_SORTER = new Comparator<LocationStorage>(){

        @Override
        public int compare(LocationStorage s1, LocationStorage s2) {
            return Integer.compare(s1.getLayer(), s2.getLayer());
        }
    };

    public LocationStorage(WorldDataBase<?> worldStorage, String id, @Nullable SharedRegion region) {
        super(worldStorage, id, region);
        this.name = "";
        this.type = EnumLocationType.NONE;
    }

    public LocationStorage(WorldDataBase<?> worldStorage, String id, @Nullable SharedRegion region, String name, EnumLocationType type) {
        super(worldStorage, id, region);
        this.name = name;
        if (type == null) {
            type = EnumLocationType.NONE;
        }
        this.type = type;
    }

    public LocationStorage addBounds(AxisAlignedBB ... boundingBoxes) {
        for (AxisAlignedBB boundingBox : boundingBoxes) {
            this.boundingBoxes.add(boundingBox);
        }
        this.updateEnclosingBounds();
        return this;
    }

    public List<AxisAlignedBB> getBounds() {
        return Collections.unmodifiableList(this.boundingBoxes);
    }

    public void removeBounds(AxisAlignedBB ... boundingBoxes) {
        for (AxisAlignedBB boundingBox : boundingBoxes) {
            this.boundingBoxes.remove(boundingBox);
        }
        this.updateEnclosingBounds();
    }

    protected void updateEnclosingBounds() {
        if (this.boundingBoxes.isEmpty()) {
            this.enclosingBoundingBox = null;
        } else if (this.boundingBoxes.size() == 1) {
            this.enclosingBoundingBox = this.boundingBoxes.get(0);
        } else {
            AxisAlignedBB union = this.boundingBoxes.get(0);
            for (AxisAlignedBB box : this.boundingBoxes) {
                union = union.func_111270_a(box);
            }
            this.enclosingBoundingBox = union;
        }
    }

    public AxisAlignedBB getEnclosingBounds() {
        return this.enclosingBoundingBox;
    }

    public LocationStorage linkChunks() {
        for (AxisAlignedBB boundingBox : this.boundingBoxes) {
            int sx = MathHelper.func_76128_c((double)boundingBox.field_72340_a) / 16;
            int sz = MathHelper.func_76128_c((double)boundingBox.field_72339_c) / 16;
            int ex = MathHelper.func_76128_c((double)boundingBox.field_72336_d) / 16;
            int ez = MathHelper.func_76128_c((double)boundingBox.field_72334_f) / 16;
            for (int cx = sx; cx <= ex; ++cx) {
                for (int cz = sz; cz <= ez; ++cz) {
                    Chunk chunk = this.getWorldStorage().getWorld().func_72964_e(cx, cz);
                    this.linkChunk(chunk);
                }
            }
        }
        return this;
    }

    @Nullable
    public ILocationGuard getGuard() {
        return null;
    }

    public LocationStorage setSeed(long seed) {
        this.locationSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.locationSeed;
    }

    public LocationStorage setInheritAmbience(boolean inherit) {
        this.inheritAmbience = inherit;
        this.ambience = null;
        return this;
    }

    public LocationStorage setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public LocationStorage setLayer(int layer) {
        this.layer = layer;
        return this;
    }

    public int getLayer() {
        return this.layer;
    }

    public LocationStorage setAmbience(LocationAmbience ambience) {
        this.inheritAmbience = false;
        this.ambience = ambience;
        ambience.setLocation(this);
        return this;
    }

    public boolean hasAmbience() {
        return this.ambience != null;
    }

    public String getLocalizedName() {
        String locationName = this.name;
        boolean translate = locationName.startsWith("translate:");
        if (translate) {
            locationName = I18n.func_135052_a((String)("location." + locationName.replaceFirst("translate:", "") + ".name"), (Object[])new Object[0]);
        }
        return locationName;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.name = nbt.func_74779_i("name");
        this.boundingBoxes.clear();
        NBTTagList boundingBoxes = nbt.func_150295_c("bounds", 10);
        for (int i = 0; i < boundingBoxes.func_74745_c(); ++i) {
            NBTTagCompound boxNbt = boundingBoxes.func_150305_b(i);
            double minX = boxNbt.func_74769_h("minX");
            double minY = boxNbt.func_74769_h("minY");
            double minZ = boxNbt.func_74769_h("minZ");
            double maxX = boxNbt.func_74769_h("maxX");
            double maxY = boxNbt.func_74769_h("maxY");
            double maxZ = boxNbt.func_74769_h("maxZ");
            this.boundingBoxes.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        this.updateEnclosingBounds();
        this.type = EnumLocationType.fromName(nbt.func_74779_i("type"));
        this.layer = nbt.func_74762_e("layer");
        if (nbt.func_74764_b("ambience")) {
            NBTTagCompound ambienceTag = nbt.func_74775_l("ambience");
            this.ambience = LocationAmbience.readFromNBT(this, ambienceTag);
        }
        this.visible = nbt.func_74767_n("visible");
        this.locationSeed = nbt.func_74763_f("seed");
    }

    public void readGuardNBT(NBTTagCompound nbt) {
        if (this.getGuard() != null) {
            this.getGuard().readFromNBT(nbt.func_74775_l("guard"));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("name", this.name);
        NBTTagList boundingBoxes = new NBTTagList();
        for (AxisAlignedBB boundingBox : this.boundingBoxes) {
            NBTTagCompound boxNbt = new NBTTagCompound();
            boxNbt.func_74780_a("minX", boundingBox.field_72340_a);
            boxNbt.func_74780_a("minY", boundingBox.field_72338_b);
            boxNbt.func_74780_a("minZ", boundingBox.field_72339_c);
            boxNbt.func_74780_a("maxX", boundingBox.field_72336_d);
            boxNbt.func_74780_a("maxY", boundingBox.field_72337_e);
            boxNbt.func_74780_a("maxZ", boundingBox.field_72334_f);
            boundingBoxes.func_74742_a((NBTBase)boxNbt);
        }
        nbt.func_74782_a("bounds", (NBTBase)boundingBoxes);
        nbt.func_74778_a("type", this.type.name);
        nbt.func_74768_a("layer", this.layer);
        if (this.hasAmbience()) {
            NBTTagCompound ambienceTag = new NBTTagCompound();
            this.ambience.writeToNBT(ambienceTag);
            nbt.func_74782_a("ambience", (NBTBase)ambienceTag);
        }
        nbt.func_74757_a("visible", this.visible);
        nbt.func_74772_a("seed", this.locationSeed);
        return nbt;
    }

    public NBTTagCompound writeGuardNBT(NBTTagCompound nbt) {
        if (this.getGuard() != null) {
            nbt.func_74782_a("guard", (NBTBase)this.getGuard().writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public boolean isInside(Entity entity) {
        return this.intersects(entity.func_174813_aQ());
    }

    public boolean isInside(Vec3i pos) {
        for (AxisAlignedBB boundingBox : this.boundingBoxes) {
            if (!this.isVecInsideOrEdge(boundingBox, new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean isInside(Vec3d pos) {
        for (AxisAlignedBB boundingBox : this.boundingBoxes) {
            if (!this.isVecInsideOrEdge(boundingBox, pos)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(AxisAlignedBB aabb) {
        for (AxisAlignedBB boundingBox : this.boundingBoxes) {
            if (!boundingBox.func_72326_a(aabb)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isVecInsideOrEdge(AxisAlignedBB aabb, Vec3d vec) {
        return vec.field_72450_a >= aabb.field_72340_a && vec.field_72450_a <= aabb.field_72336_d ? (vec.field_72448_b >= aabb.field_72338_b && vec.field_72448_b <= aabb.field_72337_e ? vec.field_72449_c >= aabb.field_72339_c && vec.field_72449_c <= aabb.field_72334_f : false) : false;
    }

    public String getName() {
        return this.name;
    }

    public EnumLocationType getType() {
        return this.type;
    }

    public boolean isVisible(Entity entity) {
        return this.visible;
    }

    public static List<LocationStorage> getLocations(Entity entity) {
        return LocationStorage.getLocations(entity.field_70170_p, entity.func_174813_aQ());
    }

    public static List<LocationStorage> getLocations(World world, Vec3d position) {
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        return worldStorage.getSharedStorageAt(LocationStorage.class, location -> location.isInside(position), position.field_72450_a, position.field_72449_c);
    }

    public static List<LocationStorage> getLocations(World world, AxisAlignedBB aabb) {
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        return worldStorage.getSharedStorageAt(LocationStorage.class, location -> location.intersects(aabb), aabb);
    }

    public static LocationAmbience getAmbience(World world, Vec3d position) {
        LocationStorage storage;
        int i;
        List<LocationStorage> locations = LocationStorage.getLocations(world, position);
        if (locations.isEmpty()) {
            return null;
        }
        Collections.sort(locations, LAYER_SORTER);
        LocationStorage highestLocation = null;
        for (i = 0; i < locations.size(); ++i) {
            storage = locations.get(i);
            if (!storage.hasAmbience() && !storage.inheritAmbience) continue;
            highestLocation = storage;
        }
        if (highestLocation != null) {
            if (highestLocation.ambience == null && highestLocation.inheritAmbience) {
                for (i = 0; i < locations.size(); ++i) {
                    storage = locations.get(i);
                    if (!storage.hasAmbience()) continue;
                    return storage.ambience;
                }
            }
            return highestLocation.ambience;
        }
        return null;
    }

    public static LocationAmbience getAmbience(Entity entity) {
        LocationStorage storage;
        int i;
        List<LocationStorage> locations = LocationStorage.getLocations(entity);
        if (locations.isEmpty()) {
            return null;
        }
        Collections.sort(locations, LAYER_SORTER);
        LocationStorage highestLocation = null;
        for (i = 0; i < locations.size(); ++i) {
            storage = locations.get(i);
            if (!storage.hasAmbience() && !storage.inheritAmbience) continue;
            highestLocation = storage;
        }
        if (highestLocation != null) {
            if (highestLocation.ambience == null && highestLocation.inheritAmbience) {
                for (i = 0; i < locations.size(); ++i) {
                    storage = locations.get(i);
                    if (!storage.hasAmbience()) continue;
                    return storage.ambience;
                }
            }
            return highestLocation.ambience;
        }
        return null;
    }

    public static boolean isInLocationType(Entity entity, EnumLocationType type) {
        List<LocationStorage> locations = LocationStorage.getLocations(entity);
        for (LocationStorage location : locations) {
            if (location.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocationGuarded(World world, @Nullable Entity entity, BlockPos pos) {
        List<LocationStorage> locations = LocationStorage.getLocations(world, new Vec3d((Vec3i)pos));
        for (LocationStorage location : locations) {
            if (location.getGuard() == null || !location.getGuard().isGuarded(world, entity, pos)) continue;
            return true;
        }
        return false;
    }
}

