/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared.location;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class LocationPortal
extends LocationStorage {
    private BlockPos portalPos;
    private BlockPos otherPortalPos;

    public LocationPortal(WorldDataBase<?> worldStorage, String id, @Nullable SharedRegion region) {
        super(worldStorage, id, region);
    }

    public LocationPortal(WorldDataBase<?> worldStorage, String id, @Nullable SharedRegion region, BlockPos pos) {
        super(worldStorage, id, region);
        this.portalPos = pos;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.portalPos = BlockPos.func_177969_a((long)nbt.func_74763_f("PortalPos"));
        this.otherPortalPos = nbt.func_150297_b("OtherPortalPos", 4) ? BlockPos.func_177969_a((long)nbt.func_74763_f("OtherPortalPos")) : null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74772_a("PortalPos", this.portalPos.func_177986_g());
        if (this.otherPortalPos != null) {
            nbt.func_74772_a("OtherPortalPos", this.otherPortalPos.func_177986_g());
        }
        return nbt;
    }

    public BlockPos getPortalPosition() {
        return this.portalPos;
    }

    @Nullable
    public BlockPos getOtherPortalPosition() {
        return this.otherPortalPos;
    }

    public void setOtherPortalPosition(@Nullable BlockPos pos) {
        this.otherPortalPos = pos;
        this.setDirty(true);
    }
}

