/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared.location;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.block.terrain.BlockWisp;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationGuarded;

public class LocationCragrockTower
extends LocationGuarded
implements ITickable {
    private List<BlockPos> glowingCragrockBlocks = new ArrayList<BlockPos>();
    private List<BlockPos> wisps = new ArrayList<BlockPos>();
    private List<BlockPos> inactiveWisps = new ArrayList<BlockPos>();
    private BlockPos[][] levelBlockadeBlocks = new BlockPos[5][0];
    private boolean[] spawners = new boolean[]{true, true, true, true, true};
    private boolean[] blockades = new boolean[]{true, true, true, true, true};
    private BlockPos structurePos;
    private boolean isTopReached = false;
    private boolean wasEntered = false;
    private int wispUpdateTicks = 0;
    private final int[][] levelYBounds = new int[][]{{-5, 9}, {10, 18}, {19, 27}, {28, 36}, {37, 45}};
    private boolean crumbling = false;
    private int crumblingTicks = 0;

    public LocationCragrockTower(WorldDataBase<?> worldStorage, String id, @Nullable SharedRegion region) {
        super(worldStorage, id, region, "translate:cragrock_tower", EnumLocationType.DUNGEON);
    }

    public void setStructurePos(BlockPos pos) {
        this.structurePos = pos;
        this.setDirty(true);
    }

    public BlockPos getStructurePos() {
        return this.structurePos;
    }

    public AxisAlignedBB getInnerBoundingBox() {
        return this.getBounds().size() > 1 ? this.getBounds().get(1) : new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public boolean isTopReached() {
        return this.isTopReached;
    }

    public void setTopReached(boolean reached) {
        this.isTopReached = reached;
        World world = this.getWorldStorage().getWorld();
        for (BlockPos pos : this.glowingCragrockBlocks) {
            if (reached) {
                world.func_175656_a(pos, BlockRegistry.GLOWING_SMOOTH_CRAGROCK.func_176223_P());
                continue;
            }
            world.func_175656_a(pos, BlockRegistry.INACTIVE_GLOWING_SMOOTH_CRAGROCK.func_176223_P());
        }
        this.setDirty(true);
    }

    public void addGlowingCragrock(BlockPos pos) {
        this.glowingCragrockBlocks.add(pos);
        this.setDirty(true);
    }

    public void addInactiveWisp(BlockPos pos) {
        this.wisps.add(pos);
        this.inactiveWisps.add(pos);
        this.setDirty(true);
    }

    public void setEntered(boolean entered) {
        this.wasEntered = entered;
        this.setDirty(true);
    }

    public boolean wasEntered() {
        return this.wasEntered;
    }

    public void setLevelBlockadeBlocks(int level, BlockPos[] blocks) {
        this.levelBlockadeBlocks[level] = blocks;
        this.setDirty(true);
    }

    public BlockPos[] getLevelBlockadeBlocks(int level) {
        return this.levelBlockadeBlocks[level];
    }

    public void destroyBlockade(int level) {
        BlockPos[] blocks = this.levelBlockadeBlocks[level];
        if (blocks != null && blocks.length != 0) {
            World world = this.getWorldStorage().getWorld();
            for (BlockPos pos : blocks) {
                world.func_184133_a(null, pos, (SoundEvent)SoundRegistry.CRUMBLE, SoundCategory.BLOCKS, 0.2f, 1.0f);
                world.func_180498_a(null, 2001, pos.func_177977_b(), Block.func_149682_b((Block)world.func_180495_p(pos).func_177230_c()));
                world.func_175698_g(pos);
                this.getGuard().setGuarded(world, pos, false);
            }
        }
        this.blockades[level] = false;
        this.setDirty(true);
    }

    public void restoreBlockade(int level) {
        BlockPos[] blocks = this.levelBlockadeBlocks[level];
        if (blocks != null && blocks.length != 0) {
            World world = this.getWorldStorage().getWorld();
            for (BlockPos pos : blocks) {
                world.func_175656_a(pos, BlockRegistry.SMOOTH_CRAGROCK_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)));
                this.getGuard().setGuarded(world, pos, true);
            }
        }
        this.blockades[level] = true;
        this.setDirty(true);
    }

    public boolean getSpawnerState(int level) {
        return this.spawners[level];
    }

    public void setSpawnerState(int level, boolean active) {
        this.spawners[level] = active;
        this.setDirty(true);
    }

    public boolean getBlockadeState(int level) {
        return this.blockades[level];
    }

    public AxisAlignedBB getLevelBounds(int level) {
        double minY = this.levelYBounds[level][0] + this.structurePos.func_177956_o();
        double maxY = this.levelYBounds[level][1] + this.structurePos.func_177956_o();
        AxisAlignedBB inside = this.getInnerBoundingBox();
        if (level == 0) {
            inside = inside.func_72314_b(1.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(inside.field_72340_a, minY, inside.field_72339_c, inside.field_72336_d, maxY, inside.field_72334_f);
    }

    public int getLevel(int y) {
        if ((y -= this.structurePos.func_177956_o()) >= this.levelYBounds[0][0] && y <= this.levelYBounds[0][1]) {
            return 0;
        }
        if (y >= this.levelYBounds[1][0] && y <= this.levelYBounds[1][1]) {
            return 1;
        }
        if (y >= this.levelYBounds[2][0] && y <= this.levelYBounds[2][1]) {
            return 2;
        }
        if (y >= this.levelYBounds[3][0] && y <= this.levelYBounds[3][1]) {
            return 3;
        }
        if (y >= this.levelYBounds[4][0] && y <= this.levelYBounds[4][1]) {
            return 4;
        }
        return -1;
    }

    public boolean isCrumbling() {
        return this.crumbling;
    }

    public void setCrumbling(boolean crumbling) {
        this.crumbling = crumbling;
        this.setDirty(true);
    }

    public int getCrumblingTicks() {
        return this.crumblingTicks;
    }

    public void setCrumblingTicks(int ticks) {
        this.crumblingTicks = ticks;
        this.setDirty(true);
    }

    public void updateWispBlocks(@Nullable EntityPlayer player) {
        World world = this.getWorldStorage().getWorld();
        if (this.wasEntered() && !this.inactiveWisps.isEmpty()) {
            if (player != null) {
                ++this.wispUpdateTicks;
                if (this.wispUpdateTicks >= 10) {
                    this.wispUpdateTicks = 0;
                    for (int i = 0; i < 4 && !this.inactiveWisps.isEmpty(); ++i) {
                        BlockPos src = player != null ? player.func_180425_c() : this.structurePos;
                        BlockPos closest = this.inactiveWisps.get(0);
                        for (BlockPos pos : this.inactiveWisps) {
                            if (!(pos.func_177951_i((Vec3i)src) < closest.func_177951_i((Vec3i)src))) continue;
                            closest = pos;
                        }
                        boolean canLightUp = false;
                        if (closest.func_177956_o() - this.structurePos.func_177956_o() < 16 && player.field_70163_u - (double)this.structurePos.func_177956_o() < 45.0 || closest.func_177956_o() - this.structurePos.func_177956_o() >= 16 && player.field_70163_u - (double)this.structurePos.func_177956_o() >= 45.0) {
                            canLightUp = true;
                        }
                        if (!canLightUp) continue;
                        world.func_175656_a(closest, BlockRegistry.WISP.func_176223_P().func_177226_a((IProperty)BlockWisp.COLOR, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(4))));
                        world.func_184148_a(null, (double)closest.func_177958_n(), (double)closest.func_177956_o(), (double)closest.func_177952_p(), (SoundEvent)SoundRegistry.IGNITE, SoundCategory.AMBIENT, 1.6f + world.field_73012_v.nextFloat() * 0.45f, 1.0f + world.field_73012_v.nextFloat() * 0.4f);
                        this.inactiveWisps.remove(closest);
                        this.setDirty(true);
                    }
                }
            }
        } else if (!this.wasEntered() && this.inactiveWisps.size() != this.wisps.size()) {
            this.inactiveWisps.clear();
            this.inactiveWisps.addAll(this.wisps);
            for (BlockPos pos : this.wisps) {
                world.func_175698_g(pos);
            }
            this.setDirty(true);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        super.readFromNBT(nbt);
        this.structurePos = BlockPos.func_177969_a((long)nbt.func_74763_f("structurePos"));
        this.isTopReached = nbt.func_74767_n("isTopReached");
        this.wasEntered = nbt.func_74767_n("wasEntered");
        this.readBlockList(nbt, "glowingBlocks", this.glowingCragrockBlocks);
        this.readBlockList(nbt, "wisps", this.wisps);
        this.readBlockList(nbt, "inactiveWisps", this.inactiveWisps);
        for (i = 0; i < 5; ++i) {
            NBTTagCompound blockadeNbt = nbt.func_74775_l("blockade." + i);
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            this.readBlockList(blockadeNbt, "blocks", blocks);
            this.levelBlockadeBlocks[i] = !blocks.isEmpty() ? blocks.toArray(new BlockPos[0]) : new BlockPos[0];
            this.blockades[i] = blockadeNbt.func_74767_n("broken");
        }
        for (i = 0; i < 5; ++i) {
            this.spawners[i] = nbt.func_74767_n("spawner." + i);
        }
        this.crumbling = nbt.func_74767_n("crumbling");
        this.crumblingTicks = nbt.func_74762_e("crumblingTicks");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        int i;
        super.writeToNBT(nbt);
        nbt.func_74772_a("structurePos", this.structurePos.func_177986_g());
        nbt.func_74757_a("isTopReached", this.isTopReached);
        nbt.func_74757_a("wasEntered", this.wasEntered);
        this.saveBlockList(nbt, "glowingBlocks", this.glowingCragrockBlocks);
        this.saveBlockList(nbt, "wisps", this.wisps);
        this.saveBlockList(nbt, "inactiveWisps", this.inactiveWisps);
        for (i = 0; i < 5; ++i) {
            NBTTagCompound blockadeNbt = new NBTTagCompound();
            BlockPos[] blocks = this.levelBlockadeBlocks[i];
            this.saveBlockList(blockadeNbt, "blocks", blocks != null && blocks.length != 0 ? Arrays.asList(blocks) : new ArrayList<BlockPos>());
            blockadeNbt.func_74757_a("broken", this.blockades[i]);
            nbt.func_74782_a("blockade." + i, (NBTBase)blockadeNbt);
        }
        for (i = 0; i < 5; ++i) {
            nbt.func_74757_a("spawner." + i, this.spawners[i]);
        }
        nbt.func_74757_a("crumbling", this.crumbling);
        nbt.func_74768_a("crumblingTicks", this.crumblingTicks);
        return nbt;
    }

    protected void saveBlockList(NBTTagCompound nbt, String name, List<BlockPos> blocks) {
        NBTTagList blockList = new NBTTagList();
        for (BlockPos pos : blocks) {
            blockList.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
        }
        nbt.func_74782_a(name, (NBTBase)blockList);
    }

    protected void readBlockList(NBTTagCompound nbt, String name, List<BlockPos> blocks) {
        blocks.clear();
        NBTTagList blockList = nbt.func_150295_c(name, 4);
        for (int i = 0; i < blockList.func_74745_c(); ++i) {
            NBTTagLong posNbt = (NBTTagLong)blockList.func_179238_g(i);
            blocks.add(BlockPos.func_177969_a((long)posNbt.func_150291_c()));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.getWorldStorage().getWorld();
        if (this.isCrumbling()) {
            ++this.crumblingTicks;
            if (!world.field_72995_K) {
                if (this.crumblingTicks > 1200) {
                    this.crumblingTicks = -1;
                    this.setCrumbling(false);
                    this.destroyBlockade(4);
                    this.getGuard().clear(world);
                } else {
                    this.setDirty(true, world.func_72820_D() % 20L == 0L);
                }
            }
        }
        if (!world.field_72995_K) {
            List players = world.func_175647_a(EntityPlayer.class, this.getEnclosingBounds(), player -> this.isInside((Entity)player) && !player.func_184812_l_());
            if (!players.isEmpty()) {
                EntityPlayer closest = (EntityPlayer)players.get(0);
                for (EntityPlayer player2 : players) {
                    if (!(player2.func_174818_b(this.structurePos) < closest.func_174818_b(this.structurePos))) continue;
                    closest = player2;
                }
                this.updateWispBlocks(closest);
            } else {
                this.updateWispBlocks(null);
            }
            if (!this.isTopReached()) {
                for (int i = 0; i < 5; ++i) {
                    List entities;
                    if (!this.getBlockadeState(i) || this.getSpawnerState(i) || !(entities = world.func_175647_a(EntityLivingBase.class, this.getLevelBounds(i), entity -> entity instanceof EntityMob || entity instanceof IMob)).isEmpty()) continue;
                    this.destroyBlockade(i);
                }
            }
            if (this.isCrumbling()) {
                int i = 0;
                while ((double)i < Math.min(Math.pow((float)this.crumblingTicks / 400.0f, 4.0) * 30.0, 30.0) + 1.0) {
                    BlockPos pos = this.getRandomPosInTower();
                    IBlockState blockState = world.func_180495_p(pos);
                    if (blockState.func_177230_c() != Blocks.field_150350_a && world.func_175623_d(pos.func_177977_b()) && world.func_175623_d(pos.func_177979_c(2))) {
                        EntityFallingBlock fallingBlock = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, BlockRegistry.WEAK_BETWEENSTONE_TILES.func_176223_P());
                        fallingBlock.field_145812_b = -60;
                        fallingBlock.field_145813_c = false;
                        fallingBlock.func_145806_a(true);
                        world.func_72838_d((Entity)fallingBlock);
                        world.func_184133_a(null, pos, (SoundEvent)SoundRegistry.CRUMBLE, SoundCategory.BLOCKS, 0.2f, 0.5f + world.field_73012_v.nextFloat() * 0.4f);
                    }
                    ++i;
                }
            }
        }
    }

    protected BlockPos getRandomPosInTower() {
        AxisAlignedBB innerBB = this.getInnerBoundingBox().func_72314_b(-1.0, -1.0, -1.0);
        int x = MathHelper.func_76143_f((double)innerBB.field_72340_a);
        int y = MathHelper.func_76143_f((double)innerBB.field_72338_b);
        int z = MathHelper.func_76143_f((double)innerBB.field_72339_c);
        int width = MathHelper.func_76128_c((double)innerBB.field_72336_d) - x;
        int height = MathHelper.func_76128_c((double)innerBB.field_72337_e) - y;
        int depth = MathHelper.func_76128_c((double)innerBB.field_72334_f) - z;
        World world = this.getWorldStorage().getWorld();
        return new BlockPos(x + world.field_73012_v.nextInt(width + 1), y + world.field_73012_v.nextInt(height + 1), z + world.field_73012_v.nextInt(depth + 1));
    }
}

