/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import thebetweenlands.api.event.AttachSharedStorageCapabilitiesEvent;
import thebetweenlands.common.world.storage.chunk.ChunkDataBase;
import thebetweenlands.common.world.storage.chunk.shared.SharedStorageReference;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;

public abstract class SharedStorage
implements ICapabilityProvider {
    private static final Map<ResourceLocation, Class<? extends SharedStorage>> STORAGE_MAP = new HashMap<ResourceLocation, Class<? extends SharedStorage>>();
    private final List<EntityPlayerMP> watchers = new ArrayList<EntityPlayerMP>();
    private final WorldDataBase<?> worldStorage;
    private final List<ChunkPos> linkedChunks = new ArrayList<ChunkPos>();
    private final List<SharedStorageReference> loadedReferences = new ArrayList<SharedStorageReference>();
    private final String id;
    private final SharedRegion region;
    private CapabilityDispatcher capabilities;
    private boolean dirty = false;
    private int version = 0;

    public static Class<? extends SharedStorage> getStorageType(ResourceLocation id) {
        return STORAGE_MAP.get(id);
    }

    public static ResourceLocation getStorageTypeID(Class<? extends SharedStorage> storageClass) {
        for (Map.Entry<ResourceLocation, Class<? extends SharedStorage>> entry : STORAGE_MAP.entrySet()) {
            if (!storageClass.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void registerStorageType(ResourceLocation id, Class<? extends SharedStorage> storageClass) {
        if (STORAGE_MAP.containsKey(id)) {
            throw new RuntimeException("Duplicate shared storage ID");
        }
        STORAGE_MAP.put(id, storageClass);
    }

    public static SharedStorage load(WorldDataBase<?> worldStorage, NBTTagCompound nbt, @Nullable SharedRegion region, boolean packet) {
        try {
            ResourceLocation type = new ResourceLocation(nbt.func_74779_i("type"));
            Class<? extends SharedStorage> storageClass = SharedStorage.getStorageType(type);
            if (storageClass == null) {
                throw new Exception("Shared storage type not mapped");
            }
            Constructor<? extends SharedStorage> ctor = storageClass.getConstructor(WorldDataBase.class, String.class, SharedRegion.class);
            SharedStorage storage = ctor.newInstance(new Object[]{worldStorage, nbt.func_74779_i("id"), region});
            if (packet) {
                storage.readFromPacketNBT(nbt.func_74775_l("data"));
            } else {
                storage.readFromNBT(nbt.func_74775_l("data"));
            }
            return storage;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static NBTTagCompound save(SharedStorage sharedStorage, NBTTagCompound nbt, boolean packet) {
        ResourceLocation type = SharedStorage.getStorageTypeID(sharedStorage.getClass());
        if (type == null) {
            throw new RuntimeException("Shared storage type not mapped");
        }
        nbt.func_74778_a("type", type.toString());
        nbt.func_74778_a("id", sharedStorage.getID());
        if (packet) {
            nbt.func_74782_a("data", (NBTBase)sharedStorage.writeToPacketNBT(new NBTTagCompound()));
        } else {
            nbt.func_74782_a("data", (NBTBase)sharedStorage.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public SharedStorage(WorldDataBase<?> worldStorage, String id, @Nullable SharedRegion region) {
        this.worldStorage = worldStorage;
        this.id = id;
        this.region = region;
        AttachSharedStorageCapabilitiesEvent event = new AttachSharedStorageCapabilitiesEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities == null ? false : this.capabilities.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    public final WorldDataBase<?> getWorldStorage() {
        return this.worldStorage;
    }

    public final boolean linkChunk(Chunk chunk) {
        Object chunkData;
        ChunkPos chunkPos = new ChunkPos(chunk.field_76635_g, chunk.field_76647_h);
        if (!this.linkedChunks.contains(chunkPos) && (chunkData = ChunkDataBase.forChunk(this.worldStorage, chunk)) != null && ((ChunkDataBase)chunkData).linkSharedStorage(this) && this.linkedChunks.add(chunkPos)) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public final boolean unlinkChunk(Chunk chunk) {
        Object chunkData;
        ChunkPos chunkPos = new ChunkPos(chunk.field_76635_g, chunk.field_76647_h);
        if (this.linkedChunks.contains(chunkPos) && (chunkData = ChunkDataBase.forChunk(this.worldStorage, chunk)) != null) {
            ((ChunkDataBase)chunkData).unlinkSharedStorage(this);
            if (this.linkedChunks.remove(chunkPos)) {
                this.setDirty(true);
                return true;
            }
        }
        return false;
    }

    public final boolean unlinkAllChunks() {
        boolean changed = false;
        boolean allUnlinked = true;
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>(this.linkedChunks.size());
        chunks.addAll(this.linkedChunks);
        Iterator it = chunks.iterator();
        ChunkPos pos = null;
        while (it.hasNext()) {
            pos = (ChunkPos)it.next();
            Chunk chunk = this.worldStorage.getWorld().func_72964_e(pos.field_77276_a, pos.field_77275_b);
            Object chunkData = ChunkDataBase.forChunk(this.worldStorage, chunk);
            if (chunkData == null || !((ChunkDataBase)chunkData).unlinkSharedStorage(this)) {
                allUnlinked = false;
                continue;
            }
            if (chunkData == null) continue;
            changed = true;
        }
        if (changed) {
            this.setDirty(true);
        }
        this.linkedChunks.clear();
        return allUnlinked;
    }

    public final boolean loadReference(SharedStorageReference reference) {
        if (!this.loadedReferences.contains(reference)) {
            return this.loadedReferences.add(reference);
        }
        return false;
    }

    public final boolean unloadReference(SharedStorageReference reference) {
        return this.loadedReferences.remove(reference);
    }

    public final List<SharedStorageReference> getReferences() {
        return Collections.unmodifiableList(this.loadedReferences);
    }

    public final List<ChunkPos> getLinkedChunks() {
        return Collections.unmodifiableList(this.linkedChunks);
    }

    public final String getID() {
        return this.id;
    }

    @Nullable
    public final SharedRegion getRegion() {
        return this.region;
    }

    public final boolean hasRegion() {
        return this.region != null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList referenceChunkList = new NBTTagList();
        for (ChunkPos referenceChunk : this.linkedChunks) {
            NBTTagCompound referenceChunkNbt = new NBTTagCompound();
            referenceChunkNbt.func_74768_a("x", referenceChunk.field_77276_a);
            referenceChunkNbt.func_74768_a("z", referenceChunk.field_77275_b);
            referenceChunkList.func_74742_a((NBTBase)referenceChunkNbt);
        }
        nbt.func_74782_a("ReferenceChunks", (NBTBase)referenceChunkList);
        nbt.func_74768_a("Version", this.version);
        if (this.capabilities != null) {
            nbt.func_74782_a("ForgeCaps", (NBTBase)this.capabilities.serializeNBT());
        }
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.linkedChunks.clear();
        NBTTagList referenceChunkList = nbt.func_150295_c("ReferenceChunks", 10);
        for (int i = 0; i < referenceChunkList.func_74745_c(); ++i) {
            NBTTagCompound referenceChunkNbt = referenceChunkList.func_150305_b(i);
            this.linkedChunks.add(new ChunkPos(referenceChunkNbt.func_74762_e("x"), referenceChunkNbt.func_74762_e("z")));
        }
        if (nbt.func_150297_b("Version", 3)) {
            this.version = nbt.func_74762_e("Version");
        }
        if (this.capabilities != null && nbt.func_74764_b("ForgeCaps")) {
            this.capabilities.deserializeNBT(nbt.func_74775_l("ForgeCaps"));
        }
    }

    public NBTTagCompound writeToPacketNBT(NBTTagCompound nbt) {
        return this.writeToNBT(nbt);
    }

    public void readFromPacketNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public void onWatched(ChunkDataBase chunkStorage, EntityPlayerMP player) {
        this.watchers.add(player);
    }

    public void onUnwatched(ChunkDataBase chunkStorage, EntityPlayerMP player) {
        this.watchers.remove(player);
    }

    public List<EntityPlayerMP> getWatchers() {
        return Collections.unmodifiableList(this.watchers);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void onLoaded() {
    }

    public void onUnloaded() {
    }

    public void onRemoved() {
    }
}

