/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared;

import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;

public class SharedRegionData {
    private String id;
    private NBTTagCompound nbt;
    private int refCounter;
    private boolean dirty;

    public SharedRegionData(String id, NBTTagCompound nbt) {
        this.id = id;
        this.nbt = nbt;
        this.refCounter = 0;
        this.dirty = false;
    }

    public String getID() {
        return this.id;
    }

    public void incrRefCounter() {
        ++this.refCounter;
    }

    public void decrRefCounter() {
        --this.refCounter;
    }

    public boolean hasReferences() {
        return this.refCounter > 0;
    }

    @Nullable
    public NBTTagCompound getSharedStorageNBT(String id) {
        if (this.nbt.func_74764_b(id)) {
            return this.nbt.func_74775_l(id);
        }
        return null;
    }

    public void setSharedStorageNBT(String id, NBTTagCompound nbt) {
        this.nbt.func_74782_a(id, (NBTBase)nbt);
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void deleteSharedStorage(File dir, String id) {
        if (this.nbt.func_74764_b(id)) {
            this.dirty = true;
            this.nbt.func_82580_o(id);
            if (this.nbt.func_186856_d() == 0) {
                this.deleteRegionFile(dir);
            }
        }
    }

    public static SharedRegionData getOrCreateRegion(File dir, SharedRegion region) {
        NBTTagCompound regionNbt = null;
        try {
            File file = new File(dir, region.getFileName() + ".dat");
            if (file.exists()) {
                regionNbt = CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (regionNbt == null) {
            regionNbt = new NBTTagCompound();
        }
        return new SharedRegionData(region.getFileName(), regionNbt);
    }

    public void saveRegion(File dir) {
        if (this.nbt.func_186856_d() > 0) {
            File file = new File(dir, this.getID() + ".dat");
            try {
                dir.mkdirs();
                CompressedStreamTools.func_74793_a((NBTTagCompound)this.nbt, (File)file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.deleteRegionFile(dir);
        }
        this.dirty = false;
    }

    public void deleteRegionFile(File dir) {
        File file = new File(dir, this.getID() + ".dat");
        if (file.exists()) {
            file.delete();
        }
    }
}

