/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.SharedRegionData;

public class SharedRegionCache {
    private final Map<SharedRegion, SharedRegionData> regionData = new HashMap<SharedRegion, SharedRegionData>();
    private final File dir;

    public SharedRegionCache(File dir) {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    public SharedRegionData getOrCreateRegion(SharedRegion region) {
        SharedRegionData data = this.regionData.get(region);
        if (data == null) {
            data = SharedRegionData.getOrCreateRegion(this.dir, region);
            this.regionData.put(region, data);
        }
        return data;
    }

    public void removeRegion(SharedRegion region) {
        this.regionData.remove(region);
    }

    public void saveAllRegions() {
        for (SharedRegionData data : this.regionData.values()) {
            if (!data.isDirty()) continue;
            data.saveRegion(this.dir);
        }
    }

    public void clearCache() {
        this.regionData.clear();
    }

    public Map<SharedRegion, SharedRegionData> getRegions() {
        return Collections.unmodifiableMap(this.regionData);
    }
}

