/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.shared;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageRemoveSharedStorage;
import thebetweenlands.common.network.clientbound.MessageSyncSharedStorage;
import thebetweenlands.common.world.storage.chunk.ChunkDataBase;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.SharedStorage;

public abstract class BetweenlandsSharedStorage
extends SharedStorage
implements ITickable {
    protected boolean requiresSync = false;

    public BetweenlandsSharedStorage(WorldDataBase<?> worldStorage, String id, @Nullable SharedRegion region) {
        super(worldStorage, id, region);
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty) {
            this.requiresSync = true;
        }
    }

    public void setDirty(boolean dirty, boolean sendUpdate) {
        if (sendUpdate) {
            this.setDirty(dirty);
        } else {
            super.setDirty(dirty);
        }
    }

    @Override
    public void onWatched(ChunkDataBase chunkStorage, EntityPlayerMP player) {
        super.onWatched(chunkStorage, player);
        this.sendDataToPlayer(new MessageSyncSharedStorage(SharedStorage.save(this, new NBTTagCompound(), true)), player);
    }

    public void func_73660_a() {
        this.updateTracker();
    }

    protected void updateTracker() {
        if (this.requiresSync) {
            if (!this.getWorldStorage().getWorld().field_72995_K && !this.getWatchers().isEmpty()) {
                NBTTagCompound nbt = SharedStorage.save(this, new NBTTagCompound(), true);
                this.sendDataToAllWatchers(new MessageSyncSharedStorage(nbt));
            }
            this.requiresSync = false;
        }
    }

    @Override
    public void onRemoved() {
        if (!this.getWorldStorage().getWorld().field_72995_K && !this.getWatchers().isEmpty()) {
            this.sendDataToAllWatchers(new MessageRemoveSharedStorage(this.getID()));
        }
    }

    protected void sendDataToAllWatchers(IMessage message) {
        for (EntityPlayerMP watcher : this.getWatchers()) {
            this.sendDataToPlayer(message, watcher);
        }
    }

    protected void sendDataToPlayer(IMessage message, EntityPlayerMP player) {
        TheBetweenlands.networkWrapper.sendTo(message, player);
    }
}

