/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.global;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.AttachWorldCapabilitiesEvent;
import thebetweenlands.common.world.storage.chunk.ChunkDataBase;
import thebetweenlands.common.world.storage.chunk.shared.SharedStorageReference;
import thebetweenlands.common.world.storage.world.shared.SharedRegionCache;
import thebetweenlands.common.world.storage.world.shared.SharedRegionData;
import thebetweenlands.common.world.storage.world.shared.SharedStorage;

public abstract class WorldDataBase<T extends ChunkDataBase>
extends WorldSavedData
implements ICapabilityProvider {
    public static final WorldEventHandler WORLD_EVENT_HANDLER = new WorldEventHandler();
    private static final Map<WorldDataTypePair, WorldDataBase<?>> CACHE = new HashMap();
    private World world;
    private NBTTagCompound data = new NBTTagCompound();
    private final Map<String, SharedStorage> sharedStorage = new HashMap<String, SharedStorage>();
    private final List<SharedStorage> tickableSharedStorage = new ArrayList<SharedStorage>();
    private File sharedStorageDir;
    private CapabilityDispatcher capabilities;
    private SharedRegionCache regionCache;

    public WorldDataBase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorldDataBase<?> getMatchingData(World world, Class<? extends WorldDataBase<?>> clazz) {
        Map<WorldDataTypePair, WorldDataBase<?>> map = CACHE;
        synchronized (map) {
            for (Map.Entry<WorldDataTypePair, WorldDataBase<?>> cacheEntry : CACHE.entrySet()) {
                WorldDataTypePair pair = cacheEntry.getKey();
                if (pair.world != world || !pair.data.equals(clazz)) continue;
                return cacheEntry.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends WorldDataBase<?>> T forWorld(World world, Class<T> clazz) {
        WorldDataBase<?> cached = WorldDataBase.getMatchingData(world, clazz);
        if (cached != null) {
            cached.world = world;
            return (T)((Object)cached);
        }
        MapStorage storage = world.getPerWorldStorage();
        WorldDataBase newInstance = null;
        try {
            newInstance = (WorldDataBase)((Object)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        WorldDataBase result = (WorldDataBase)storage.func_75742_a(clazz, newInstance.field_76190_i);
        String dimFolder = world.field_73011_w.getSaveFolder();
        File sharedStorageDir = new File(world.func_72860_G().func_75765_b(), (dimFolder != null && dimFolder.length() > 0 ? dimFolder + File.separator : "") + "data" + File.separator + "shared_storage" + File.separator);
        SharedRegionCache regionCache = new SharedRegionCache(new File(sharedStorageDir, "region"));
        if (result == null) {
            result = newInstance;
            result.world = world;
            result.sharedStorageDir = sharedStorageDir;
            result.regionCache = regionCache;
            result.init();
            result.setDefaults();
            result.save();
            result.func_76185_a();
            storage.func_75745_a(result.field_76190_i, (WorldSavedData)result);
        } else {
            result.world = world;
            result.sharedStorageDir = sharedStorageDir;
            result.regionCache = regionCache;
            result.init();
            result.load();
        }
        AttachWorldCapabilitiesEvent event = new AttachWorldCapabilitiesEvent(result);
        MinecraftForge.EVENT_BUS.post((Event)event);
        result.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
        Map<WorldDataTypePair, WorldDataBase<?>> map = CACHE;
        synchronized (map) {
            CACHE.put(new WorldDataTypePair(world, clazz), result);
        }
        return (T)((Object)result);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities == null ? false : this.capabilities.hasCapability(capability, facing);
    }

    public <F> F getCapability(Capability<F> capability, EnumFacing facing) {
        return (F)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    public World getWorld() {
        return this.world;
    }

    public final void func_76184_a(NBTTagCompound compound) {
        this.data = compound.func_74775_l("worldData");
    }

    public final NBTTagCompound func_189551_b(NBTTagCompound compound) {
        this.save();
        compound.func_74782_a("worldData", (NBTBase)this.data);
        return compound;
    }

    protected abstract void load();

    protected abstract void save();

    protected abstract void init();

    protected abstract void setDefaults();

    public abstract Class<T> getChunkStorage();

    public NBTTagCompound getData() {
        return this.data;
    }

    public File getSharedStorageDirectory() {
        return this.sharedStorageDir;
    }

    public boolean addSharedStorage(SharedStorage storage) {
        if (!this.sharedStorage.containsKey(storage.getID()) && !storage.getLinkedChunks().isEmpty()) {
            this.sharedStorage.put(storage.getID(), storage);
            if (storage instanceof ITickable) {
                this.tickableSharedStorage.add(storage);
            }
            for (ChunkPos referenceChunk : storage.getLinkedChunks()) {
                SharedStorageReference reference;
                Object chunkData;
                Chunk chunk = this.world.func_72863_F().func_186026_b(referenceChunk.field_77276_a, referenceChunk.field_77275_b);
                if (chunk == null || (chunkData = ChunkDataBase.forChunk(this, chunk)) == null || (reference = ((ChunkDataBase)chunkData).getReference(storage.getID())) == null || storage.getReferences().contains(reference)) continue;
                storage.loadReference(reference);
                for (EntityPlayerMP watcher : ((ChunkDataBase)chunkData).getWatchers()) {
                    if (storage.getWatchers().contains(watcher)) continue;
                    storage.onWatched((ChunkDataBase)chunkData, watcher);
                }
            }
            storage.onLoaded();
            return true;
        }
        return false;
    }

    public boolean removeSharedStorage(SharedStorage storage) {
        if (this.sharedStorage.containsKey(storage.getID())) {
            if (!this.world.field_72995_K) {
                storage.unlinkAllChunks();
            }
            this.sharedStorage.remove(storage.getID());
            Iterator<SharedStorage> it = this.tickableSharedStorage.iterator();
            SharedStorage tickableStorage = null;
            while (it.hasNext()) {
                tickableStorage = it.next();
                if (!storage.getID().equals(tickableStorage.getID())) continue;
                it.remove();
            }
            if (!this.world.field_72995_K) {
                this.deleteSharedStorageFile(storage);
            }
            storage.onUnloaded();
            storage.onRemoved();
            return true;
        }
        return false;
    }

    public SharedStorage getSharedStorage(String id) {
        return this.sharedStorage.get(id);
    }

    public Collection<SharedStorage> getSharedStorage() {
        return Collections.unmodifiableCollection(this.sharedStorage.values());
    }

    @Nullable
    public SharedStorage loadSharedStorage(SharedStorageReference reference) {
        SharedStorage storage = this.loadSharedStorageFile(reference);
        if (storage != null) {
            this.addSharedStorage(storage);
            storage.onLoaded();
            if (storage.hasRegion()) {
                SharedRegionData data = this.regionCache.getOrCreateRegion(reference.getRegion());
                data.incrRefCounter();
            }
            return storage;
        }
        return null;
    }

    public boolean unloadSharedStorage(SharedStorage storage) {
        if (this.sharedStorage.containsKey(storage.getID())) {
            if (!this.world.field_72995_K && storage.isDirty()) {
                this.saveSharedStorageFile(storage);
                storage.setDirty(false);
            }
            this.sharedStorage.remove(storage.getID());
            Iterator<SharedStorage> it = this.tickableSharedStorage.iterator();
            SharedStorage tickableStorage = null;
            while (it.hasNext()) {
                tickableStorage = it.next();
                if (!storage.getID().equals(tickableStorage.getID())) continue;
                it.remove();
            }
            storage.onUnloaded();
            if (!this.world.field_72995_K && storage.hasRegion()) {
                SharedRegionData data = this.regionCache.getOrCreateRegion(storage.getRegion());
                data.decrRefCounter();
                if (!data.hasReferences()) {
                    if (data.isDirty()) {
                        data.saveRegion(this.regionCache.getDir());
                    }
                    this.regionCache.removeRegion(storage.getRegion());
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public SharedStorage loadSharedStorageFile(SharedStorageReference reference) {
        if (!reference.hasRegion()) {
            File file = new File(this.getSharedStorageDirectory(), reference.getID() + ".dat");
            if (file.exists()) {
                try {
                    NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)file);
                    return SharedStorage.load(this, nbt, null, false);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        } else {
            SharedRegionData region = this.regionCache.getOrCreateRegion(reference.getRegion());
            NBTTagCompound nbt = region.getSharedStorageNBT(reference.getID());
            if (nbt != null) {
                return SharedStorage.load(this, nbt, reference.getRegion(), false);
            }
        }
        return null;
    }

    public void saveSharedStorageFile(SharedStorage storage) {
        NBTTagCompound nbt = SharedStorage.save(storage, new NBTTagCompound(), false);
        if (!storage.hasRegion()) {
            try {
                File savePath = this.getSharedStorageDirectory();
                savePath.mkdirs();
                File file = new File(savePath, storage.getID() + ".dat");
                CompressedStreamTools.func_74793_a((NBTTagCompound)nbt, (File)file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            SharedRegionData region = this.regionCache.getOrCreateRegion(storage.getRegion());
            region.setSharedStorageNBT(storage.getID(), nbt);
        }
    }

    public void deleteSharedStorageFile(SharedStorage storage) {
        if (!storage.hasRegion()) {
            File file = new File(this.getSharedStorageDirectory(), storage.getID() + ".dat");
            if (file.exists()) {
                file.delete();
            }
        } else {
            SharedRegionData regionData = this.regionCache.getOrCreateRegion(storage.getRegion());
            if (regionData != null) {
                regionData.deleteSharedStorage(this.regionCache.getDir(), storage.getID());
            }
        }
    }

    public <F extends SharedStorage> List<F> getSharedStorageAt(Class<F> storageClass, @Nullable Predicate<F> selector, double x, double z) {
        int cz;
        ArrayList<SharedStorage> storages = new ArrayList<SharedStorage>();
        int cx = MathHelper.func_76128_c((double)x) / 16;
        Chunk chunk = this.world.func_72964_e(cx, cz = MathHelper.func_76128_c((double)z) / 16);
        Object chunkStorage = ChunkDataBase.forChunk(this, chunk);
        if (chunkStorage != null) {
            for (SharedStorageReference ref : ((ChunkDataBase)chunkStorage).getSharedStorageReferences()) {
                SharedStorage storage = this.getSharedStorage(ref.getID());
                if (storage == null || !storageClass.isAssignableFrom(storage.getClass()) || selector != null && !selector.test(storage)) continue;
                storages.add(storage);
            }
        }
        return storages;
    }

    public <F extends SharedStorage> List<F> getSharedStorageAt(Class<F> storageClass, @Nullable Predicate<F> selector, AxisAlignedBB aabb) {
        ArrayList<SharedStorage> storages = new ArrayList<SharedStorage>();
        int sx = MathHelper.func_76128_c((double)aabb.field_72340_a) / 16;
        int sz = MathHelper.func_76128_c((double)aabb.field_72339_c) / 16;
        int ex = MathHelper.func_76128_c((double)aabb.field_72336_d) / 16;
        int ez = MathHelper.func_76128_c((double)aabb.field_72334_f) / 16;
        for (int cx = sx; cx <= ex; ++cx) {
            for (int cz = sz; cz <= ez; ++cz) {
                Chunk chunk = this.world.func_72964_e(cx, cz);
                Object chunkStorage = ChunkDataBase.forChunk(this, chunk);
                if (chunkStorage == null) continue;
                for (SharedStorageReference ref : ((ChunkDataBase)chunkStorage).getSharedStorageReferences()) {
                    SharedStorage storage = this.getSharedStorage(ref.getID());
                    if (storage == null || !storageClass.isAssignableFrom(storage.getClass()) || selector != null && !selector.test(storage)) continue;
                    storages.add(storage);
                }
            }
        }
        return storages;
    }

    public <F extends SharedStorage> List<F> getSharedStorageAt(Class<F> storageClass, double x, double z) {
        return this.getSharedStorageAt(storageClass, null, x, z);
    }

    public <F extends SharedStorage> List<F> getSharedStorageAt(Class<F> storageClass, AxisAlignedBB aabb) {
        return this.getSharedStorageAt(storageClass, null, aabb);
    }

    public static class WorldEventHandler {
        private WorldEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
            Map map = CACHE;
            synchronized (map) {
                Iterator cacheIT = CACHE.entrySet().iterator();
                while (cacheIT.hasNext()) {
                    Map.Entry entry = cacheIT.next();
                    World world = ((WorldDataTypePair)entry.getKey()).world;
                    if (!world.equals(event.getWorld())) continue;
                    WorldDataBase worldStorage = (WorldDataBase)((Object)entry.getValue());
                    ArrayList<SharedStorage> sharedStorages = new ArrayList<SharedStorage>();
                    sharedStorages.addAll(worldStorage.getSharedStorage());
                    for (SharedStorage sharedStorage : sharedStorages) {
                        worldStorage.unloadSharedStorage(sharedStorage);
                    }
                    cacheIT.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            Map map = CACHE;
            synchronized (map) {
                for (WorldDataBase worldStorage : CACHE.values()) {
                    ArrayList<SharedStorage> sharedStorages = new ArrayList<SharedStorage>();
                    sharedStorages.addAll(worldStorage.getSharedStorage());
                    for (SharedStorage sharedStorage : sharedStorages) {
                        if (!sharedStorage.isDirty()) continue;
                        worldStorage.saveSharedStorageFile(sharedStorage);
                        sharedStorage.setDirty(false);
                    }
                    worldStorage.regionCache.saveAllRegions();
                }
            }
        }

        @SubscribeEvent
        public void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
                this.tickWorld(event.world);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            WorldClient world;
            if (event.phase == TickEvent.Phase.END && (world = Minecraft.func_71410_x().field_71441_e) != null && !Minecraft.func_71410_x().func_147113_T()) {
                this.tickWorld((World)world);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tickWorld(World world) {
            Map map = CACHE;
            synchronized (map) {
                for (WorldDataBase worldStorage : CACHE.values()) {
                    if (worldStorage.getWorld() != world) continue;
                    for (int i = 0; i < worldStorage.tickableSharedStorage.size(); ++i) {
                        SharedStorage sharedStorage = (SharedStorage)worldStorage.tickableSharedStorage.get(i);
                        ((ITickable)sharedStorage).func_73660_a();
                    }
                }
            }
        }
    }

    private static class WorldDataTypePair {
        private World world;
        private Class<? extends WorldDataBase<?>> data;

        private WorldDataTypePair(World world, Class<? extends WorldDataBase<?>> data) {
            this.world = world;
            this.data = data;
        }
    }
}

