/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.world.global;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.world.event.EnvironmentEvent;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;
import thebetweenlands.common.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;

public class BetweenlandsWorldData
extends WorldDataBase<BetweenlandsChunkData> {
    private EnvironmentEventRegistry environmentEventRegistry;
    private AspectManager aspectManager = new AspectManager();

    public BetweenlandsWorldData() {
        super("thebetweenlands:worldData");
    }

    public BetweenlandsWorldData(String name) {
        super(name);
    }

    public EnvironmentEventRegistry getEnvironmentEventRegistry() {
        return this.environmentEventRegistry;
    }

    public AspectManager getAspectManager() {
        return this.aspectManager;
    }

    @Override
    protected void init() {
        this.environmentEventRegistry = new EnvironmentEventRegistry(this.getWorld());
        this.environmentEventRegistry.init();
    }

    @Override
    protected void setDefaults() {
        if (!this.getWorld().field_72995_K) {
            for (EnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.setDefaults();
                event.setLoaded();
            }
            this.aspectManager.loadAndPopulateStaticAspects(null, AspectManager.getAspectsSeed(this.getWorld().func_72912_H().func_76063_b()));
        }
    }

    @Override
    protected void load() {
        if (!this.getWorld().field_72995_K) {
            for (EnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.readFromNBT(this.getData());
            }
            this.environmentEventRegistry.setDisabled(this.getData().func_74767_n("eventsDisabled"));
            this.aspectManager.loadAndPopulateStaticAspects(this.getData().func_74775_l("itemAspects"), AspectManager.getAspectsSeed(this.getWorld().func_72912_H().func_76063_b()));
        }
    }

    @Override
    protected void save() {
        if (!this.getWorld().field_72995_K) {
            for (EnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.writeToNBT(this.getData());
            }
            this.getData().func_74757_a("eventsDisabled", this.environmentEventRegistry.isDisabled());
            NBTTagCompound aspectData = new NBTTagCompound();
            this.aspectManager.saveStaticAspects(aspectData);
            this.getData().func_74782_a("itemAspects", (NBTBase)aspectData);
        }
    }

    public static BetweenlandsWorldData forWorld(World world) {
        return WorldDataBase.forWorld(world, BetweenlandsWorldData.class);
    }

    @Override
    public Class<BetweenlandsChunkData> getChunkStorage() {
        return BetweenlandsChunkData.class;
    }
}

