/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.chunk.shared;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;

public class SharedStorageReference {
    private final ChunkPos chunkPos;
    private final String id;
    private final SharedRegion region;

    public SharedStorageReference(ChunkPos chunkPos, String id, @Nullable SharedRegion region) {
        this.id = id;
        this.chunkPos = chunkPos;
        this.region = region;
    }

    public static SharedStorageReference readFromNBT(NBTTagCompound nbt) {
        String id = nbt.func_74779_i("id");
        ChunkPos pos = new ChunkPos(nbt.func_74762_e("x"), nbt.func_74762_e("z"));
        SharedRegion region = null;
        if (nbt.func_74764_b("region")) {
            region = SharedRegion.readFromNBT(nbt.func_74775_l("region"));
        }
        return new SharedStorageReference(pos, id, region);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.id);
        nbt.func_74768_a("x", this.chunkPos.field_77276_a);
        nbt.func_74768_a("z", this.chunkPos.field_77275_b);
        if (this.region != null) {
            nbt.func_74782_a("region", (NBTBase)this.region.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public String getID() {
        return this.id;
    }

    @Nullable
    public SharedRegion getRegion() {
        return this.region;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public ChunkPos getChunk() {
        return this.chunkPos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chunkPos == null ? 0 : this.chunkPos.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SharedStorageReference other = (SharedStorageReference)obj;
        if (this.chunkPos == null ? other.chunkPos != null : !this.chunkPos.equals((Object)other.chunkPos)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }
}

