/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.chunk;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.world.storage.chunk.ChunkDataBase;

public final class ChunkDataContainer {
    private NBTTagCompound nbt;
    private List<ChunkDataBase> chunkDataHandlers;
    private Map<Class<? extends ChunkDataBase>, ChunkDataBase> classToHandler;

    ChunkDataContainer(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    final NBTTagCompound getNBT() {
        return this.nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setNBT(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public void saveHandlers() {
        if (this.chunkDataHandlers != null) {
            for (ChunkDataBase handler : this.chunkDataHandlers) {
                NBTTagCompound nbt = handler.writeToNBT(new NBTTagCompound());
                this.nbt.func_74782_a(handler.getName(), (NBTBase)nbt);
            }
        }
    }

    public void addHandler(ChunkDataBase handler) {
        if (this.chunkDataHandlers == null) {
            this.chunkDataHandlers = new ArrayList<ChunkDataBase>();
        }
        if (this.classToHandler == null) {
            this.classToHandler = new HashMap<Class<? extends ChunkDataBase>, ChunkDataBase>();
        }
        this.chunkDataHandlers.add(handler);
        this.classToHandler.put(handler.getClass(), handler);
    }

    @Nullable
    public <T extends ChunkDataBase> T getCachedHandler(Class<T> cls) {
        if (this.classToHandler == null) {
            return null;
        }
        return (T)this.classToHandler.get(cls);
    }

    public List<ChunkDataBase> getHandlers() {
        if (this.chunkDataHandlers != null) {
            return Collections.unmodifiableList(this.chunkDataHandlers);
        }
        return ImmutableList.of();
    }
}

