/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.chunk;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.event.AttachChunkCapabilitiesEvent;
import thebetweenlands.common.world.storage.chunk.ChunkDataContainer;
import thebetweenlands.common.world.storage.chunk.shared.SharedStorageReference;
import thebetweenlands.common.world.storage.world.global.WorldDataBase;
import thebetweenlands.common.world.storage.world.shared.SharedStorage;

public abstract class ChunkDataBase
implements ICapabilityProvider {
    public static final ChunkEventHandler CHUNK_EVENT_HANDLER = new ChunkEventHandler();
    private static final Map<ChunkIdentifier, ChunkDataContainer> CHUNK_CONTAINER_CACHE = new HashMap<ChunkIdentifier, ChunkDataContainer>();
    private static final Map<ChunkIdentifier, List<EntityPlayerMP>> CHUNK_WATCHERS = new HashMap<ChunkIdentifier, List<EntityPlayerMP>>();
    private static final Deque<ChunkIdentifier> UNLOAD_QUEUE = new ArrayDeque<ChunkIdentifier>();
    private Chunk chunk;
    private WorldDataBase<?> worldStorage;
    private final List<EntityPlayerMP> watchers = new ArrayList<EntityPlayerMP>();
    private CapabilityDispatcher capabilities;
    private final List<SharedStorageReference> sharedStorageReferences = new ArrayList<SharedStorageReference>();

    public ChunkDataBase() {
        AttachChunkCapabilitiesEvent event = new AttachChunkCapabilitiesEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
    }

    @Nullable
    public static <T extends ChunkDataBase> T forChunk(WorldDataBase<T> worldStorage, Chunk chunk) {
        ChunkDataContainer container = CHUNK_CONTAINER_CACHE.get(new ChunkIdentifier(worldStorage.getWorld(), chunk.func_76632_l()));
        if (container != null) {
            T cached = container.getCachedHandler(worldStorage.getChunkStorage());
            if (cached != null) {
                return cached;
            }
            NBTTagCompound nbt = container.getNBT();
            T newInstance = ChunkDataBase.getHandlerInstance(worldStorage, chunk, handlerName -> {
                if (!nbt.func_74764_b(handlerName)) {
                    return null;
                }
                NBTTagCompound handlerNBT = nbt.func_74775_l(handlerName);
                if (!(handlerNBT instanceof NBTTagCompound)) {
                    handlerNBT = new NBTTagCompound();
                }
                return handlerNBT;
            });
            container.addHandler((ChunkDataBase)newInstance);
            return newInstance;
        }
        return null;
    }

    private static <T extends ChunkDataBase> T getHandlerInstance(WorldDataBase<T> worldStorage, Chunk chunk, Function<String, NBTTagCompound> nbtProvider) {
        Class<T> handlerClass = worldStorage.getChunkStorage();
        ChunkDataBase newInstance = null;
        try {
            newInstance = (ChunkDataBase)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        newInstance.chunk = chunk;
        newInstance.worldStorage = worldStorage;
        newInstance.init();
        NBTTagCompound nbt = nbtProvider.apply(newInstance.getName());
        if (nbt != null) {
            newInstance.readFromNBT(nbt);
        } else {
            newInstance.setDefaults();
        }
        List<EntityPlayerMP> watchers = CHUNK_WATCHERS.get(new ChunkIdentifier(worldStorage.getWorld(), chunk.func_76632_l()));
        if (watchers != null) {
            for (EntityPlayerMP watcher : watchers) {
                newInstance.onWatched(watcher);
            }
        }
        newInstance.onLoaded();
        return (T)newInstance;
    }

    public static void updateContainerData(World world, Chunk chunk, NBTTagCompound nbt) {
        if (chunk.func_177410_o()) {
            CHUNK_CONTAINER_CACHE.put(new ChunkIdentifier(world, chunk.func_76632_l()), new ChunkDataContainer(nbt));
        }
    }

    public static <T extends ChunkDataBase> void updateHandlerData(WorldDataBase<T> world, Chunk chunk, NBTTagCompound nbt) {
        ChunkDataContainer container;
        if (chunk.func_177410_o() && (container = CHUNK_CONTAINER_CACHE.get(new ChunkIdentifier(world.getWorld(), chunk.func_76632_l()))) != null) {
            Class<T> handlerClass = world.getChunkStorage();
            T handler = container.getCachedHandler(handlerClass);
            if (handler == null) {
                T newInstance = ChunkDataBase.getHandlerInstance(world, chunk, handlerName -> nbt);
                container.addHandler((ChunkDataBase)newInstance);
            } else {
                ((ChunkDataBase)handler).readFromNBT(nbt);
            }
        }
    }

    public final boolean linkSharedStorage(SharedStorage storage) {
        String id = storage.getID();
        for (SharedStorageReference ref : this.sharedStorageReferences) {
            if (!id.equals(ref.getID())) continue;
            return false;
        }
        SharedStorageReference ref = new SharedStorageReference(this.chunk.func_76632_l(), id, storage.getRegion());
        if (this.sharedStorageReferences.add(ref)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public final boolean unlinkSharedStorage(SharedStorage storage) {
        String id = storage.getID();
        ArrayList<SharedStorageReference> unlinkedReferences = new ArrayList<SharedStorageReference>();
        Iterator<SharedStorageReference> referenceIT = this.sharedStorageReferences.iterator();
        while (referenceIT.hasNext()) {
            SharedStorageReference ref = referenceIT.next();
            if (!id.equals(ref.getID())) continue;
            unlinkedReferences.add(ref);
            referenceIT.remove();
        }
        if (!unlinkedReferences.isEmpty()) {
            for (SharedStorageReference ref : unlinkedReferences) {
                if (!storage.getReferences().contains(ref)) continue;
                storage.unlinkChunk(this.chunk);
            }
            this.markDirty();
            return true;
        }
        return false;
    }

    public final List<SharedStorageReference> getSharedStorageReferences() {
        return Collections.unmodifiableList(this.sharedStorageReferences);
    }

    @Nullable
    public final SharedStorageReference getReference(String id) {
        for (SharedStorageReference ref : this.sharedStorageReferences) {
            if (!id.equals(ref.getID())) continue;
            return ref;
        }
        return null;
    }

    public final Chunk getChunk() {
        return this.chunk;
    }

    public final WorldDataBase<?> getWorldStorage() {
        return this.worldStorage;
    }

    public abstract String getName();

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities == null ? false : this.capabilities.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    protected void init() {
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        if (this.capabilities != null && nbt.func_74764_b("ForgeCaps")) {
            this.capabilities.deserializeNBT(nbt.func_74775_l("ForgeCaps"));
        }
        this.sharedStorageReferences.clear();
        NBTTagList sharedReferenceList = nbt.func_150295_c("SharedStorageReferences", 10);
        for (int i = 0; i < sharedReferenceList.func_74745_c(); ++i) {
            this.sharedStorageReferences.add(SharedStorageReference.readFromNBT((NBTTagCompound)sharedReferenceList.func_179238_g(i)));
        }
        Iterator<SharedStorageReference> refIT = this.sharedStorageReferences.iterator();
        while (refIT.hasNext()) {
            SharedStorageReference ref = refIT.next();
            SharedStorage sharedStorage = this.getWorldStorage().getSharedStorage(ref.getID());
            if (!this.worldStorage.getWorld().field_72995_K && sharedStorage == null) {
                sharedStorage = this.getWorldStorage().loadSharedStorage(ref);
            }
            if (sharedStorage != null && sharedStorage.getLinkedChunks().contains(this.chunk.func_76632_l())) {
                sharedStorage.loadReference(ref);
                continue;
            }
            if (this.worldStorage.getWorld().field_72995_K) continue;
            refIT.remove();
        }
    }

    protected NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound caps;
        if (this.capabilities != null && (caps = this.capabilities.serializeNBT()).func_186856_d() > 0) {
            nbt.func_74782_a("ForgeCaps", (NBTBase)caps);
        }
        if (this.sharedStorageReferences.size() > 0) {
            NBTTagList sharedReferenceList = new NBTTagList();
            for (SharedStorageReference ref : this.sharedStorageReferences) {
                sharedReferenceList.func_74742_a((NBTBase)ref.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("SharedStorageReferences", (NBTBase)sharedReferenceList);
        }
        return nbt;
    }

    protected void setDefaults() {
    }

    protected void onLoaded() {
    }

    protected void onUnloaded() {
        for (SharedStorageReference ref : this.sharedStorageReferences) {
            SharedStorage sharedStorage = this.getWorldStorage().getSharedStorage(ref.getID());
            if (sharedStorage == null) continue;
            sharedStorage.unloadReference(ref);
            if (!sharedStorage.getReferences().isEmpty()) continue;
            this.getWorldStorage().unloadSharedStorage(sharedStorage);
        }
    }

    protected void onWatched(EntityPlayerMP player) {
        this.watchers.add(player);
        for (SharedStorageReference ref : this.sharedStorageReferences) {
            SharedStorage sharedStorage = this.getWorldStorage().getSharedStorage(ref.getID());
            if (sharedStorage == null || sharedStorage.getWatchers().contains(player)) continue;
            sharedStorage.onWatched(this, player);
        }
    }

    protected void onUnwatched(EntityPlayerMP player) {
        this.watchers.remove(player);
        for (SharedStorageReference ref : this.sharedStorageReferences) {
            SharedStorage sharedStorage = this.getWorldStorage().getSharedStorage(ref.getID());
            if (sharedStorage == null || !sharedStorage.getWatchers().contains(player)) continue;
            sharedStorage.onUnwatched(this, player);
        }
    }

    public List<EntityPlayerMP> getWatchers() {
        return this.watchers;
    }

    public void markDirty() {
        this.chunk.func_76630_e();
    }

    public static final class ChunkEventHandler {
        private ChunkEventHandler() {
        }

        @SubscribeEvent
        public void onChunkDataEvent(ChunkDataEvent event) {
            ChunkIdentifier id = new ChunkIdentifier(event.getWorld(), event.getChunk().func_76632_l());
            NBTTagCompound chunkNBT = event.getData();
            if (event instanceof ChunkDataEvent.Save) {
                ChunkDataContainer container = (ChunkDataContainer)CHUNK_CONTAINER_CACHE.get(id);
                if (container != null) {
                    container.saveHandlers();
                    chunkNBT.func_74782_a("thebetweenlands.ExtendedChunkData", (NBTBase)container.getNBT());
                }
            } else if (event instanceof ChunkDataEvent.Load) {
                NBTTagCompound extendedChunkData = chunkNBT.func_74775_l("thebetweenlands.ExtendedChunkData");
                if (!(extendedChunkData instanceof NBTTagCompound)) {
                    extendedChunkData = new NBTTagCompound();
                }
                CHUNK_CONTAINER_CACHE.put(id, new ChunkDataContainer(extendedChunkData));
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onChunkLoad(ChunkEvent.Load event) {
            ChunkIdentifier id = new ChunkIdentifier(event.getWorld(), event.getChunk().func_76632_l());
            if (!CHUNK_CONTAINER_CACHE.containsKey(id)) {
                CHUNK_CONTAINER_CACHE.put(id, new ChunkDataContainer(new NBTTagCompound()));
            }
        }

        @SubscribeEvent
        public void onChunkUnload(ChunkEvent.Unload event) {
            ChunkIdentifier id = new ChunkIdentifier(event.getWorld(), event.getChunk().func_76632_l());
            CHUNK_WATCHERS.remove(id);
            if (event.getWorld().field_72995_K && !event.getChunk().func_177410_o()) {
                ChunkDataContainer container = (ChunkDataContainer)CHUNK_CONTAINER_CACHE.remove(id);
                if (container != null) {
                    for (ChunkDataBase chunkStorage : container.getHandlers()) {
                        chunkStorage.onUnloaded();
                    }
                }
                return;
            }
            ChunkDataContainer container = (ChunkDataContainer)CHUNK_CONTAINER_CACHE.get(id);
            if (container != null) {
                UNLOAD_QUEUE.push(id);
            }
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ChunkIdentifier queuedChunk;
                while ((queuedChunk = (ChunkIdentifier)UNLOAD_QUEUE.poll()) != null) {
                    ChunkDataContainer container = (ChunkDataContainer)CHUNK_CONTAINER_CACHE.remove(queuedChunk);
                    if (container == null) continue;
                    List<ChunkDataBase> handlers = container.getHandlers();
                    for (ChunkDataBase handler : handlers) {
                        handler.onUnloaded();
                    }
                }
            }
        }

        @SubscribeEvent
        public void onChunkWatchEvent(ChunkWatchEvent event) {
            block4: {
                ArrayList<EntityPlayerMP> watchers;
                ChunkDataContainer container;
                block5: {
                    ChunkIdentifier id = new ChunkIdentifier(event.getPlayer().func_130014_f_(), event.getChunk());
                    container = (ChunkDataContainer)CHUNK_CONTAINER_CACHE.get(id);
                    if (container == null) break block4;
                    watchers = (ArrayList<EntityPlayerMP>)CHUNK_WATCHERS.get(id);
                    if (!(event instanceof ChunkWatchEvent.Watch)) break block5;
                    if (watchers == null) {
                        watchers = new ArrayList<EntityPlayerMP>();
                        CHUNK_WATCHERS.put(id, watchers);
                    }
                    watchers.add(event.getPlayer());
                    List<ChunkDataBase> handlers = container.getHandlers();
                    for (ChunkDataBase handler : handlers) {
                        handler.onWatched(event.getPlayer());
                    }
                    break block4;
                }
                if (!(event instanceof ChunkWatchEvent.UnWatch)) break block4;
                if (watchers != null) {
                    watchers.remove(event.getPlayer());
                }
                List<ChunkDataBase> handlers = container.getHandlers();
                for (ChunkDataBase handler : handlers) {
                    handler.onUnwatched(event.getPlayer());
                }
            }
        }
    }

    private static final class ChunkIdentifier {
        private final World world;
        private final ChunkPos chunk;
        private final int hash;

        private ChunkIdentifier(World world, ChunkPos chunk) {
            this.world = world;
            this.chunk = chunk;
            int worldHash = world.hashCode();
            int chunkHash = chunk.hashCode();
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + chunkHash;
            this.hash = hash = 31 * hash + worldHash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkIdentifier other = (ChunkIdentifier)obj;
            if (this.chunk == null ? other.chunk != null : !this.chunk.equals((Object)other.chunk)) {
                return false;
            }
            if (this.hash != other.hash) {
                return false;
            }
            return !(this.world == null ? other.world != null : !this.world.equals(other.world));
        }
    }
}

