/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.chunk;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageSyncChunkData;
import thebetweenlands.common.world.storage.chunk.ChunkDataBase;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;

public class BetweenlandsChunkData
extends ChunkDataBase {
    public static BetweenlandsChunkData forChunk(World world, Chunk chunk) {
        return ChunkDataBase.forChunk(BetweenlandsWorldData.forWorld(world), chunk);
    }

    @Override
    public void init() {
    }

    @Override
    protected void setDefaults() {
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.sendDataToAllWatchers(true);
    }

    protected void sendDataToAllWatchers(boolean sendEmpty) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !this.getWatchers().isEmpty()) {
            NBTTagCompound nbt = this.writeToNBT(new NBTTagCompound());
            if (sendEmpty || nbt.func_186856_d() > 0) {
                for (EntityPlayerMP watcher : this.getWatchers()) {
                    TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageSyncChunkData(this.getChunk(), nbt), watcher);
                }
            }
        }
    }

    protected void sendDataToPlayer(EntityPlayerMP player, boolean sendEmpty) {
        NBTTagCompound nbt = this.writeToNBT(new NBTTagCompound());
        if (sendEmpty || nbt.func_186856_d() > 0) {
            TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageSyncChunkData(this.getChunk(), nbt), player);
        }
    }

    @Override
    protected void onWatched(EntityPlayerMP player) {
        super.onWatched(player);
        this.sendDataToPlayer(player, false);
    }

    @Override
    public String getName() {
        return "ChunkData";
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        BetweenlandsChunkData.forChunk(event.getWorld(), event.getChunk());
    }
}

