/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.plant.BlockVineBL;
import thebetweenlands.common.registries.BlockRegistry;

public class WorldGenWeedwoodTree
extends WorldGenerator {
    private IBlockState logX;
    private IBlockState logY;
    private IBlockState logZ;
    private IBlockState bark;
    private IBlockState wood;
    private IBlockState leaves;
    private IBlockState ivy;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int radius = rand.nextInt(2) + 3;
        int height = rand.nextInt(5) + 15;
        int maxRadius = 9;
        this.logX = BlockRegistry.LOG_WEEDWOOD.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        this.logY = BlockRegistry.LOG_WEEDWOOD.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        this.logZ = BlockRegistry.LOG_WEEDWOOD.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        this.bark = BlockRegistry.LOG_WEEDWOOD.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.wood = BlockRegistry.WEEDWOOD.func_176223_P();
        this.leaves = BlockRegistry.LEAVES_WEEDWOOD_TREE.func_176223_P();
        this.ivy = BlockRegistry.POISON_IVY.func_176223_P();
        for (int xx = -maxRadius; xx <= maxRadius; ++xx) {
            for (int zz = -maxRadius; zz <= maxRadius; ++zz) {
                for (int yy = 2; yy < height; ++yy) {
                    if (world.func_175623_d(pos.func_177982_a(xx, yy, zz)) || !world.func_180495_p(pos.func_177982_a(xx, yy, zz)).func_185915_l()) continue;
                    return false;
                }
            }
        }
        this.createMainCanopy(world, rand, pos.func_177982_a(0, height / 2 + 4, 0), maxRadius);
        for (int yy = 0; yy < height; ++yy) {
            if (yy % 3 == 0 && radius > 1 && yy > 3) {
                --radius;
            }
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) < (long)radius && yy <= 1 + height - 2) {
                        world.func_180501_a(pos.func_177982_a(i, yy, j), this.wood, 2);
                    }
                    if ((Math.round(Math.sqrt(dSq)) != (long)radius || yy != 0) && (Math.round(Math.sqrt(dSq)) != (long)radius || yy > height - 1)) continue;
                    world.func_180501_a(pos.func_177982_a(i, yy, j), this.bark, 2);
                }
            }
            if (yy == height / 2 + 2) {
                this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), radius + 1), 3, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -radius - 1), 4, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, false, rand.nextInt(2) + 3);
            }
            if (yy == height / 2 + 4) {
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), radius + 1), 3, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -radius - 1), 4, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, 3);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, 3);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, 3);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, 3);
            }
            if (yy == height / 2 + 7) {
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(3), radius + 1), 3, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(3), -radius - 1), 4, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, 2);
            }
            if (yy != 0) continue;
            this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), radius + 1), 3, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -radius - 1), 4, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, true, rand.nextInt(2) + 3);
        }
        return true;
    }

    private void createSmallBranch(World world, Random rand, BlockPos pos, int dir, int branchLength) {
        int y = 0;
        boolean branchBend = false;
        block10: for (int i = 0; i <= branchLength; ++i) {
            if (i >= 2) {
                ++y;
                branchBend = true;
            }
            switch (dir) {
                case 1: {
                    world.func_180501_a(pos.func_177965_g(i).func_177981_b(y), branchBend ? this.logY : this.logX, 2);
                    continue block10;
                }
                case 2: {
                    world.func_180501_a(pos.func_177985_f(i).func_177981_b(y), branchBend ? this.logY : this.logX, 2);
                    continue block10;
                }
                case 3: {
                    world.func_180501_a(pos.func_177970_e(i).func_177981_b(y), branchBend ? this.logY : this.logZ, 2);
                    continue block10;
                }
                case 4: {
                    world.func_180501_a(pos.func_177964_d(i).func_177981_b(y), branchBend ? this.logY : this.logZ, 2);
                    continue block10;
                }
                case 5: {
                    world.func_180501_a(pos.func_177965_g(i).func_177981_b(y).func_177970_e(i), branchBend ? this.logY : this.logX, 2);
                    continue block10;
                }
                case 6: {
                    world.func_180501_a(pos.func_177985_f(i).func_177981_b(y).func_177964_d(i), branchBend ? this.logY : this.logX, 2);
                    continue block10;
                }
                case 7: {
                    world.func_180501_a(pos.func_177985_f(i).func_177981_b(y).func_177970_e(i), branchBend ? this.logY : this.logZ, 2);
                    continue block10;
                }
                case 8: {
                    world.func_180501_a(pos.func_177965_g(i).func_177981_b(y).func_177964_d(i), branchBend ? this.logY : this.logZ, 2);
                }
            }
        }
    }

    private void createMainCanopy(World world, Random rand, BlockPos pos, int maxRadius) {
        for (int x1 = -maxRadius; x1 <= maxRadius; ++x1) {
            for (int z1 = -maxRadius; z1 <= maxRadius; ++z1) {
                for (int y1 = 0; y1 < maxRadius; ++y1) {
                    double dSq = Math.pow(x1, 2.0) + Math.pow(z1, 2.0) + Math.pow(y1, 2.5);
                    if (Math.round(Math.sqrt(dSq)) <= (long)maxRadius && !this.isALog(world.func_180495_p(pos.func_177982_a(x1, y1, z1))) && rand.nextInt(5) != 0) {
                        world.func_180501_a(pos.func_177982_a(x1, y1, z1), this.leaves, 2);
                    }
                    if (Math.round(Math.sqrt(dSq)) < (long)(maxRadius - 1) && y1 > 0 && !this.isALog(world.func_180495_p(pos.func_177982_a(x1, y1, z1)))) {
                        world.func_175656_a(pos.func_177982_a(x1, y1, z1), this.logY);
                    }
                    if (Math.round(Math.sqrt(dSq)) > (long)maxRadius || rand.nextInt(3) != 0 || y1 != 0 || world.func_180495_p(pos.func_177982_a(x1, y1, z1)) != this.leaves) continue;
                    for (int i = 1; i < 1 + rand.nextInt(3); ++i) {
                        world.func_180501_a(pos.func_177982_a(x1, y1 - i, z1), this.leaves, 2);
                    }
                }
            }
        }
    }

    private boolean isALog(IBlockState state) {
        return state == this.logX ? true : (state == this.logY ? true : state == this.logZ);
    }

    private void createBranch(World world, Random rand, BlockPos pos, int dir, boolean root, int branchLength) {
        int y = 0;
        boolean branchBend = false;
        block10: for (int i = 0; i <= branchLength; ++i) {
            if (i >= 3) {
                ++y;
                branchBend = true;
            }
            switch (dir) {
                case 1: {
                    if (!root) {
                        world.func_180501_a(pos.func_177965_g(i).func_177981_b(y), branchBend ? this.logY : this.logX, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177965_g(i).func_177981_b(y - 1), EnumFacing.EAST);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177965_g(i).func_177979_c(y), this.bark, 2);
                    world.func_180501_a(pos.func_177965_g(i).func_177979_c(y - 1), this.bark, 2);
                    continue block10;
                }
                case 2: {
                    if (!root) {
                        world.func_180501_a(pos.func_177985_f(i).func_177981_b(y), branchBend ? this.logY : this.logX, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177985_f(i).func_177981_b(y - 1), EnumFacing.WEST);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177985_f(i).func_177979_c(y), this.bark, 2);
                    world.func_180501_a(pos.func_177985_f(i).func_177979_c(y - 1), this.bark, 2);
                    continue block10;
                }
                case 3: {
                    if (!root) {
                        world.func_180501_a(pos.func_177970_e(i).func_177981_b(y), branchBend ? this.logY : this.logZ, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177970_e(i).func_177981_b(y - 1), EnumFacing.SOUTH);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177970_e(i).func_177979_c(y), this.bark, 2);
                    world.func_180501_a(pos.func_177970_e(i).func_177979_c(y - 1), this.bark, 2);
                    continue block10;
                }
                case 4: {
                    if (!root) {
                        world.func_180501_a(pos.func_177964_d(i).func_177981_b(y), branchBend ? this.logY : this.logZ, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177964_d(i).func_177981_b(y - 1), EnumFacing.NORTH);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177964_d(i).func_177979_c(y), this.bark, 2);
                    world.func_180501_a(pos.func_177964_d(i).func_177979_c(y - 1), this.bark, 2);
                    continue block10;
                }
                case 5: {
                    if (!root) {
                        world.func_180501_a(pos.func_177965_g(i - 1).func_177981_b(y).func_177970_e(i - 1), branchBend ? this.logY : this.logX, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177965_g(i - 1).func_177981_b(y - 1).func_177970_e(i - 1), EnumFacing.EAST);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177965_g(i - 1).func_177979_c(y).func_177970_e(i - 1), this.bark, 2);
                    world.func_180501_a(pos.func_177965_g(i - 1).func_177979_c(y - 1).func_177970_e(i - 1), this.bark, 2);
                    continue block10;
                }
                case 6: {
                    if (!root) {
                        world.func_180501_a(pos.func_177985_f(i - 1).func_177981_b(y).func_177964_d(i - 1), branchBend ? this.logY : this.logX, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177985_f(i - 1).func_177981_b(y - 1).func_177964_d(i - 1), EnumFacing.WEST);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177985_f(i - 1).func_177979_c(y).func_177964_d(i - 1), this.bark, 2);
                    world.func_180501_a(pos.func_177985_f(i - 1).func_177979_c(y - 1).func_177964_d(i - 1), this.bark, 2);
                    continue block10;
                }
                case 7: {
                    if (!root) {
                        world.func_180501_a(pos.func_177985_f(i - 1).func_177981_b(y).func_177970_e(i - 1), branchBend ? this.logY : this.logZ, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177985_f(i - 1).func_177981_b(y - 1).func_177970_e(i - 1), EnumFacing.SOUTH);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177985_f(i - 1).func_177979_c(y).func_177970_e(i - 1), this.bark, 2);
                    world.func_180501_a(pos.func_177985_f(i - 1).func_177979_c(y - 1).func_177970_e(i - 1), this.bark, 2);
                    continue block10;
                }
                case 8: {
                    if (!root) {
                        world.func_180501_a(pos.func_177965_g(i - 1).func_177981_b(y).func_177964_d(i - 1), branchBend ? this.logY : this.logZ, 2);
                        if (i > branchLength) continue block10;
                        this.addVines(world, rand, pos.func_177965_g(i - 1).func_177981_b(y - 1).func_177964_d(i - 1), EnumFacing.NORTH);
                        continue block10;
                    }
                    world.func_180501_a(pos.func_177965_g(i - 1).func_177979_c(y).func_177964_d(i - 1), this.bark, 2);
                    world.func_180501_a(pos.func_177965_g(i - 1).func_177979_c(y - 1).func_177964_d(i - 1), this.bark, 2);
                }
            }
        }
    }

    private void addVines(World world, Random rand, BlockPos pos, EnumFacing facing) {
        if (rand.nextInt(4) != 0) {
            int length = rand.nextInt(4) + 4;
            for (int yy = 0; yy < length && world.func_175623_d(pos.func_177979_c(yy)); ++yy) {
                world.func_180501_a(pos.func_177979_c(yy), this.ivy.func_177226_a((IProperty)BlockVineBL.func_176267_a((EnumFacing)facing.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }
}

