/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.tree.Fungus;

public abstract class WorldGenGiantTreeTrunk
extends WorldGenerator {
    private static final int MIN_TRUNK_RADIUS = 2;
    private static final int MAX_TRUNK_RADIUS = 18;
    private static final int STEEPNESS = 160;
    public static final EnumFacing[] DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
    private static final byte[][] TRUNK_LAYERS = new byte[17][];
    public static IBlockState BARK = BlockRegistry.LOG_WEEDWOOD.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
    public static IBlockState WOOD = BlockRegistry.WEEDWOOD.func_176223_P();
    public static IBlockState LEAVES = BlockRegistry.LEAVES_WEEDWOOD_TREE.func_176223_P();
    public static IBlockState IVY = BlockRegistry.POISON_IVY.func_176223_P();
    public static IBlockState HANGER = BlockRegistry.HANGER.func_176223_P();

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        return this.generateTree(world, rand, pos);
    }

    protected boolean generateTree(World world, Random rand, BlockPos pos) {
        int blockZ;
        int blockY;
        int baseRadius = rand.nextInt(6) + 13;
        int height = rand.nextInt(this.getRadiusHeightRatio() * 4 + 1) + baseRadius * this.getRadiusHeightRatio() + 6;
        int blockX = pos.func_177958_n();
        if (this.isSpaceOccupied(world, blockX, blockY = pos.func_177956_o(), blockZ = pos.func_177952_p(), baseRadius, height)) {
            return false;
        }
        int mirrorX = rand.nextBoolean() ? -1 : 1;
        int mirrorZ = rand.nextBoolean() ? -1 : 1;
        this.initAttributes(rand);
        ArrayList<Fungus> fungi = new ArrayList<Fungus>();
        for (int dy = 0; dy < height; ++dy) {
            int y = blockY + dy;
            int radius = this.getRadius(baseRadius, dy);
            byte[] layer = TRUNK_LAYERS[radius - 2];
            int size = radius * 2 + 1;
            for (int dx = -radius; dx <= radius; ++dx) {
                block7: for (int dz = -radius; dz <= radius; ++dz) {
                    byte state = layer[dx * mirrorX + radius + (dz * mirrorZ + radius) * size];
                    switch (state) {
                        case 0: {
                            if (world.func_180495_p(new BlockPos(blockX + dx, y - 1, blockZ + dz)).func_177230_c() != BlockRegistry.LOG_WEEDWOOD) continue block7;
                            this.func_175903_a(world, new BlockPos(blockX + dx, y - 1, blockZ + dz), BARK);
                            continue block7;
                        }
                        case 1: {
                            this.placeWood(world, rand, radius, height, blockX, blockY, blockZ, dx, dy, dz);
                            continue block7;
                        }
                        case 2: {
                            this.placeBark(world, rand, radius, height, blockX, blockY, blockZ, dx, dy, dz);
                            if (!this.canFungusGenerateAtY(dy, height) || rand.nextInt(8) != 0) continue block7;
                            float distance = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
                            int fungusX = (int)((float)(-dx) / distance * 2.0f);
                            int fungusZ = (int)((float)(-dz) / distance * 2.0f);
                            int fungusRadius = rand.nextInt(3) + radius / 4 + 3;
                            fungi.add(new Fungus(new BlockPos(blockX + dx + fungusX, y, blockZ + dz + fungusZ), fungusRadius));
                        }
                    }
                }
            }
        }
        this.generateShoots(world, rand, baseRadius, height, blockX, blockY, blockZ);
        for (Fungus fungus : fungi) {
            fungus.generate(world, rand);
        }
        return true;
    }

    protected void generateShoots(World world, Random rand, int baseRadius, int height, int blockX, int blockY, int blockZ) {
        this.generateRoots(world, rand, baseRadius, height, blockY, blockX, blockY + 2, blockZ, rand.nextInt(3) + 4, false);
        this.generateRoots(world, rand, baseRadius, height, blockY, blockX, blockY + 10, blockZ, rand.nextInt(3) + 3, true);
    }

    private void generateRoots(World world, Random rand, int baseRadius, int height, int baseY, int blockX, int blockY, int blockZ, int rootCount, boolean high) {
        float angle = (float)Math.PI * 2 / (float)rootCount;
        float angleOffset = rand.nextFloat() * 2.0f * (float)Math.PI;
        for (int root = 0; root < rootCount; ++root) {
            float yaw = angle * (float)root + angleOffset;
            float pitch = high ? 0.0f : -0.3926991f + rand.nextFloat() * (float)Math.PI / 16.0f;
            int length = rand.nextInt(7) + (high ? 25 : 18);
            float posX = MathHelper.func_76134_b((float)yaw) * (float)baseRadius * 0.2f + (float)blockX;
            float posY = blockY;
            float posZ = MathHelper.func_76126_a((float)yaw) * (float)baseRadius * 0.2f + (float)blockZ;
            this.generateRoot(world, rand, posX, posY, posZ, yaw, pitch, length, 2.0f, 1.0f);
        }
    }

    private void generateRoot(World world, Random rand, float posX, float posY, float posZ, float yaw, float pitch, int length, float startSize, float endSize) {
        float yawDelta = 0.0f;
        float pitchDelta = 0.0f;
        int branchPoint = rand.nextBoolean() ? length / 2 + rand.nextInt(length / 4) : -1;
        int minX = 30000000;
        int minY = 255;
        int minZ = 30000000;
        int maxX = -30000000;
        int maxY = 0;
        int maxZ = -30000000;
        for (int step = 0; step < length; ++step) {
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            posX += MathHelper.func_76134_b((float)yaw) * cosPitch;
            posY += MathHelper.func_76126_a((float)pitch);
            posZ += MathHelper.func_76126_a((float)yaw) * cosPitch;
            pitch += pitchDelta * 0.1f;
            yaw += yawDelta * 0.1f;
            pitchDelta *= 0.8f;
            yawDelta *= 0.8f;
            float along = (float)step / (float)length;
            yawDelta += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f * (along + 0.1f);
            if (rand.nextFloat() < 0.75f && pitch > -0.7853982f && along > 0.15f) {
                pitchDelta -= 0.4f;
            }
            float size = along * endSize + (1.0f - along) * startSize;
            int sizeRange = (int)Math.ceil(size);
            if (step == branchPoint && startSize > 1.75f) {
                float branchYaw = rand.nextFloat() * (float)Math.PI / 8.0f;
                float branchAngle = rand.nextFloat() * (float)Math.PI / 4.0f + 0.7853982f;
                this.generateRoot(world, rand, posX, posY, posZ, yaw + branchYaw + branchAngle, pitch, length - step, size, 1.0f);
                this.generateRoot(world, rand, posX, posY, posZ, yaw + branchYaw - branchAngle, pitch, length - step, size, 1.0f);
                break;
            }
            if (world.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)) == WOOD) continue;
            float sizeSq = size * size;
            for (int x = -sizeRange; x <= sizeRange; ++x) {
                for (int z = -sizeRange; z <= sizeRange; ++z) {
                    for (int y = -sizeRange; y <= sizeRange; ++y) {
                        float dist = x * x + y * y + z * z;
                        if (!(dist <= sizeSq)) continue;
                        int bx = (int)posX + x;
                        int by = (int)posY + y;
                        int bz = (int)posZ + z;
                        this.func_175903_a(world, new BlockPos(bx, by, bz), BARK);
                        if (bx < minX) {
                            minX = bx;
                        }
                        if (by < minY) {
                            minY = by;
                        }
                        if (bz < minZ) {
                            minZ = bz;
                        }
                        if (bx > maxX) {
                            maxX = bx;
                        }
                        if (by > maxY) {
                            maxY = by;
                        }
                        if (bz <= maxZ) continue;
                        maxZ = bz;
                    }
                }
            }
        }
        this.makeBarkInsideNotBark(world, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void makeBarkInsideNotBark(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    IBlockState t;
                    if (world.func_180495_p(new BlockPos(x, y, z)) != BARK || (t = world.func_180495_p(new BlockPos(x + 1, y, z))) != BARK && t != WOOD || (t = world.func_180495_p(new BlockPos(x - 1, y, z))) != BARK && t != WOOD || (t = world.func_180495_p(new BlockPos(x, y + 1, z))) != BARK && t != WOOD || (t = world.func_180495_p(new BlockPos(x, y - 1, z))) != BARK && t != WOOD || (t = world.func_180495_p(new BlockPos(x, y, z + 1))) != BARK && t != WOOD || (t = world.func_180495_p(new BlockPos(x, y, z - 1))) != BARK && t != WOOD) continue;
                    this.func_175903_a(world, new BlockPos(x, y, z), WOOD);
                }
            }
        }
    }

    private boolean isSpaceOccupied(World world, int blockX, int blockY, int blockZ, int maxRadius, int height) {
        for (int x = blockX - maxRadius; x <= blockX + maxRadius; x += 2) {
            for (int z = blockZ - maxRadius; z <= blockZ + maxRadius; z += 2) {
                for (int y = blockY; y < blockY + 10 + height; y += 2) {
                    if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() != Material.field_151575_d) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected int getRadiusHeightRatio() {
        return 1;
    }

    protected boolean canFungusGenerateAtY(int dy, int height) {
        return dy % 5 == 0;
    }

    protected void initAttributes(Random rand) {
    }

    protected void placeWood(World world, Random rand, int radius, int height, int blockX, int blockY, int blockZ, int dx, int dy, int dz) {
        boolean isDentrothyst;
        boolean bl = dy < 40 ? rand.nextInt(dy * 2 + 60) == 0 : (isDentrothyst = false);
        if (isDentrothyst) {
            this.func_175903_a(world, new BlockPos(blockX + dx, blockY + dy, blockZ + dz), rand.nextInt(20) == 0 ? BlockRegistry.DENTROTHYST.func_176223_P().func_177226_a(BlockDentrothyst.TYPE, (Comparable)((Object)BlockDentrothyst.EnumDentrothyst.ORANGE)) : BlockRegistry.DENTROTHYST.func_176223_P());
        } else {
            this.func_175903_a(world, new BlockPos(blockX + dx, blockY + dy, blockZ + dz), WOOD);
        }
    }

    protected void placeBark(World world, Random rand, int radius, int height, int blockX, int blockY, int blockZ, int dx, int dy, int dz) {
        this.func_175903_a(world, new BlockPos(blockX + dx, blockY + dy, blockZ + dz), BARK);
    }

    protected int getRadius(int baseRadius, int dy) {
        return (320 - baseRadius * 160) / (-baseRadius * dy - 160 + 2 * dy) + 2;
    }

    public static void initTrunkLayers() {
        float slope = 0.09375f;
        for (int i = 0; i < TRUNK_LAYERS.length; ++i) {
            int z;
            int x;
            int radius = i + 2;
            int size = radius * 2 + 1;
            WorldGenGiantTreeTrunk.TRUNK_LAYERS[i] = new byte[size * size];
            for (x = -radius; x <= radius; ++x) {
                for (z = -radius; z <= radius; ++z) {
                    float fold;
                    float angle = (float)Math.atan2(z, x);
                    float dist = MathHelper.func_76129_c((float)(x * x + z * z)) + (float)(i < 3 ? false : false);
                    if (!(dist <= (float)radius - (fold = (MathHelper.func_76126_a((float)(angle * 2.0f * (float)Math.PI * 2.0f)) + 1.0f) * (slope * (float)(radius - 2))))) continue;
                    WorldGenGiantTreeTrunk.TRUNK_LAYERS[i][x + radius + (z + radius) * size] = 1;
                }
            }
            for (x = 0; x < size; ++x) {
                for (z = 0; z < size; ++z) {
                    int index = x + z * size;
                    byte state = TRUNK_LAYERS[i][index];
                    if (state != 1) continue;
                    if (x > 0 && TRUNK_LAYERS[i][x - 1 + z * size] == 0) {
                        WorldGenGiantTreeTrunk.TRUNK_LAYERS[i][index] = 2;
                        continue;
                    }
                    if (z > 0 && TRUNK_LAYERS[i][x + (z - 1) * size] == 0) {
                        WorldGenGiantTreeTrunk.TRUNK_LAYERS[i][index] = 2;
                        continue;
                    }
                    if (x < size - 1 && TRUNK_LAYERS[i][x + 1 + z * size] == 0) {
                        WorldGenGiantTreeTrunk.TRUNK_LAYERS[i][index] = 2;
                        continue;
                    }
                    if (z >= size - 1 || TRUNK_LAYERS[i][x + (z + 1) * size] != 0) continue;
                    WorldGenGiantTreeTrunk.TRUNK_LAYERS[i][index] = 2;
                }
            }
        }
    }

    static {
        WorldGenGiantTreeTrunk.initTrunkLayers();
    }
}

