/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.tree.WorldGenGiantTreeTrunk;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class WorldGenGiantTree
extends WorldGenGiantTreeTrunk {
    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        boolean gen = super.func_180709_b(world, rand, pos);
        if (gen) {
            this.generateWorldLocation(world, rand, pos);
        }
        return gen;
    }

    @Override
    protected int getRadiusHeightRatio() {
        return 3;
    }

    @Override
    protected boolean canFungusGenerateAtY(int dy, int height) {
        return super.canFungusGenerateAtY(dy, height) && dy >= height / 4 && dy <= height / 4 * 3 - 3;
    }

    @Override
    protected void generateShoots(World world, Random rand, int baseRadius, int height, int blockX, int blockY, int blockZ) {
        super.generateShoots(world, rand, baseRadius, height, blockX, blockY, blockZ);
        int endRadius = this.getRadius(baseRadius, height);
        this.generateBranches(world, rand, baseRadius, height, endRadius, blockY, blockX, blockY + height / 3 * 2, blockZ, true);
        this.generateBranches(world, rand, baseRadius, height, endRadius, blockY, blockX, blockY + height / 3, blockZ, false);
        this.generateBranch(world, rand, blockX, blockY + height, blockZ, rand.nextFloat() * 2.0f * (float)Math.PI, 1.5707964f, 6, endRadius, -2.0f);
    }

    protected void generateBranches(World world, Random rand, int baseRadius, int height, int endRadius, int baseY, int blockX, int blockY, int blockZ, boolean top) {
        int branchCount = rand.nextInt(3) + (top ? 2 : 1);
        float angle = (float)Math.PI * 2 / (float)branchCount;
        float angleOffset = rand.nextFloat() * 2.0f * (float)Math.PI;
        for (int branch = 0; branch < branchCount; ++branch) {
            float yaw = angle * (float)branch + angleOffset;
            float pitch = 0.7853982f + rand.nextFloat() * (float)Math.PI / 6.0f;
            int length = rand.nextInt(8) + 25;
            this.generateBranch(world, rand, blockX, Math.min(blockY + rand.nextInt(10), baseY + height - rand.nextInt(10)), blockZ, yaw, pitch, length, (int)((float)endRadius * 0.85f), (int)((float)endRadius * 0.4f));
        }
    }

    protected void generateBranch(World world, Random rand, float posX, float posY, float posZ, float yaw, float pitch, int length, float startSize, float endSize) {
        int branchPoint;
        float yawDelta = 0.0f;
        boolean largeCanopy = endSize == -2.0f;
        int n = branchPoint = largeCanopy ? -1 : length / 4 + rand.nextInt(length / 4);
        if (endSize == -1.0f) {
            endSize = 1.0f;
        } else if (largeCanopy) {
            endSize = startSize * 0.75f;
        }
        int minX = 30000000;
        int minY = 255;
        int minZ = 30000000;
        int maxX = -30000000;
        int maxY = 0;
        int maxZ = -30000000;
        for (int step = 0; step < length; ++step) {
            float along = (float)step / (float)length;
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            posX += MathHelper.func_76134_b((float)yaw) * cosPitch;
            posY += MathHelper.func_76126_a((float)pitch);
            posZ += MathHelper.func_76126_a((float)yaw) * cosPitch;
            if (!largeCanopy) {
                pitch *= 1.0f - along + along * 0.1f;
                if (along > 0.5f && pitch < 1.5707964f) {
                    pitch += along - 0.45f;
                }
            }
            yaw += yawDelta * 0.1f;
            yawDelta *= 0.8f;
            yawDelta += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f * (along + 0.1f);
            float size = along * endSize + (1.0f - along) * startSize;
            int sizeRange = (int)Math.ceil(size);
            if (step == branchPoint && startSize > 1.0f && length > 5) {
                float branchYaw = rand.nextFloat() * (float)Math.PI / 16.0f;
                float branchAngle = rand.nextFloat() * (float)Math.PI / 4.0f + 0.7853982f;
                this.generateBranch(world, rand, posX, posY, posZ, yaw + branchYaw + branchAngle, pitch + 0.5235988f, length - step, size * 0.8f, -1.0f);
                this.generateBranch(world, rand, posX, posY, posZ, yaw + branchYaw - branchAngle, pitch + 0.5235988f, length - step, size * 0.8f, -1.0f);
            }
            for (int x = -sizeRange; x <= sizeRange; ++x) {
                for (int z = -sizeRange; z <= sizeRange; ++z) {
                    for (int y = -sizeRange; y <= sizeRange; ++y) {
                        float dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                        if (!(dist <= size)) continue;
                        IBlockState block = world.func_180495_p(new BlockPos((int)posX + x, (int)posY + y, (int)posZ + z));
                        IBlockState above = world.func_180495_p(new BlockPos((int)posX + x, (int)posY + y + 1, (int)posZ + z));
                        if (block == WOOD && above.func_185904_a().func_76222_j()) continue;
                        int bx = (int)posX + x;
                        int by = (int)posY + y;
                        int bz = (int)posZ + z;
                        this.func_175903_a(world, new BlockPos(bx, by, bz), BARK);
                        if (bx < minX) {
                            minX = bx;
                        }
                        if (by < minY) {
                            minY = by;
                        }
                        if (bz < minZ) {
                            minZ = bz;
                        }
                        if (bx > maxX) {
                            maxX = bx;
                        }
                        if (by > maxY) {
                            maxY = by;
                        }
                        if (bz <= maxZ) continue;
                        maxZ = bz;
                    }
                }
            }
        }
        this.makeBarkInsideNotBark(world, minX, minY, minZ, maxX, maxY, maxZ);
        int maxRadius = largeCanopy ? 16 : (length < 2 ? 1 : length * 3 / 8 + rand.nextInt(length / 4));
        this.generateCanopy(world, rand, (int)posX, (int)posY, (int)posZ, maxRadius);
    }

    protected void generateCanopy(World world, Random rand, int blockX, int blockY, int blockZ, int maxRadius) {
        if (maxRadius > 4) {
            int branchCount = rand.nextInt(3) + 3;
            float angleOffset = rand.nextFloat() * 2.0f * (float)Math.PI;
            float angle = (float)Math.PI * 2 / (float)branchCount;
            float pitch = 0.3926991f;
            float deltaY = MathHelper.func_76126_a((float)pitch);
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            int size = 1;
            for (int branch = 0; branch < branchCount; ++branch) {
                double posX = blockX;
                double posY = blockY - 2;
                double posZ = blockZ;
                float yaw = angle * (float)branch + angleOffset;
                float deltaX = MathHelper.func_76134_b((float)yaw) * cosPitch;
                float deltaZ = MathHelper.func_76126_a((float)yaw) * cosPitch;
                int length = (int)((float)maxRadius * (rand.nextFloat() * 0.39999998f + 0.5f));
                for (int step = 0; step < length; ++step) {
                    posX += (double)deltaX;
                    posY += (double)deltaY;
                    posZ += (double)deltaZ;
                    for (int x = -size; x <= size; ++x) {
                        for (int z = -size; z <= size; ++z) {
                            for (int y = -size; y <= size; ++y) {
                                if (!(MathHelper.func_76129_c((float)(x * x + y * y + z * z)) <= (float)size)) continue;
                                this.func_175903_a(world, new BlockPos((int)posX + x, (int)posY + y, (int)posZ + z), BARK);
                            }
                        }
                    }
                }
            }
        }
        for (int x = blockX - maxRadius; x <= blockX + maxRadius; ++x) {
            for (int z = blockZ - maxRadius; z <= blockZ + maxRadius; ++z) {
                for (int y = blockY; y < blockY + maxRadius; ++y) {
                    int dist = (int)Math.round(Math.sqrt(Math.pow(x - blockX, 2.0) + Math.pow(z - blockZ, 2.0) + Math.pow(y - blockY, 2.5)));
                    if (dist < maxRadius - 1 && rand.nextInt(4) == 0 && y > blockY && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != BlockRegistry.LOG_WEEDWOOD) {
                        this.func_175903_a(world, new BlockPos(x, y, z), BlockRegistry.LOG_WEEDWOOD.func_176223_P());
                    }
                    if (dist <= maxRadius && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != BlockRegistry.LOG_WEEDWOOD && world.func_180495_p(new BlockPos(x, y, z)) != BARK) {
                        this.func_175903_a(world, new BlockPos(x, y, z), LEAVES);
                    }
                    if (dist > maxRadius || rand.nextInt(2) != 0 || y != blockY || world.func_180495_p(new BlockPos(x, y, z)) != LEAVES) continue;
                    int length = rand.nextInt(3) + 1;
                    for (int i = 1; i < length; ++i) {
                        this.func_175903_a(world, new BlockPos(x, y - i, z), LEAVES);
                        if (i != 2) continue;
                        this.addHangers(world, rand, x, y - i - 1, z);
                    }
                }
            }
        }
    }

    protected void addHangers(World world, Random rand, int x, int startY, int z) {
        if (rand.nextInt(4) == 0) {
            int length = rand.nextInt(10) + 10;
            for (int y = startY; y > startY - length && world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76222_j(); --y) {
                this.func_175903_a(world, new BlockPos(x, y, z), HANGER);
            }
        }
    }

    protected void generateWorldLocation(World world, Random rand, BlockPos pos) {
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        LocationStorage treeLocation = new LocationStorage(worldStorage, UUID.randomUUID().toString(), SharedRegion.getFromBlockPos(pos), "giant_tree", EnumLocationType.GIANT_TREE);
        treeLocation.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 32), (double)(pos.func_177956_o() - 10), (double)(pos.func_177952_p() - 32), (double)(pos.func_177958_n() + 32), (double)(pos.func_177956_o() + 80), (double)(pos.func_177952_p() + 32)));
        treeLocation.linkChunks();
        treeLocation.setDirty(true);
        treeLocation.setSeed(rand.nextLong());
        treeLocation.setVisible(false);
        worldStorage.addSharedStorage(treeLocation);
    }
}

