/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.structure.BlockTreePortal;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.LocationPortal;

public class WorldGenWeedwoodPortalTree
extends WorldGenerator {
    private IBlockState bark;
    private IBlockState wood;
    private IBlockState leaves;

    public WorldGenWeedwoodPortalTree() {
        super(true);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int radius = 4;
        int height = 16;
        int maxRadius = 9;
        int checkRadius = 4;
        int checkHeight = 6;
        this.bark = BlockRegistry.LOG_PORTAL.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.wood = BlockRegistry.WEEDWOOD.func_176223_P();
        this.leaves = BlockRegistry.LEAVES_WEEDWOOD_TREE.func_176223_P();
        for (int xx = -checkRadius; xx <= checkRadius; ++xx) {
            for (int zz = -checkRadius; zz <= checkRadius; ++zz) {
                if (xx * xx + zz * zz > checkRadius * checkRadius) continue;
                for (int yy = 2; yy < 2 + checkHeight; ++yy) {
                    IBlockState blockState = world.func_180495_p(pos.func_177982_a(xx, yy, zz));
                    if (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_185915_l() || blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        this.createMainCanopy(world, rand, pos.func_177982_a(0, height / 2 + 4, 0), maxRadius);
        for (int yy = 0; yy < height; ++yy) {
            if (yy % 3 == 0 && radius > 1 && yy > 5) {
                --radius;
            }
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) < (long)radius && yy <= 1) {
                        this.func_175903_a(world, pos.func_177982_a(i, yy, j), this.wood);
                    }
                    if ((Math.round(Math.sqrt(dSq)) != (long)radius || yy != 0) && (Math.round(Math.sqrt(dSq)) != (long)radius || yy > height - 1)) continue;
                    this.func_175903_a(world, pos.func_177982_a(i, yy, j), this.bark);
                }
            }
            if (yy == 4) {
                BlockTreePortal.makePortalX(world, pos.func_177982_a(radius, yy - 2, 0));
                BlockTreePortal.makePortalX(world, pos.func_177982_a(-radius, yy - 2, 0));
                BlockTreePortal.makePortalZ(world, pos.func_177982_a(0, yy - 2, radius));
                BlockTreePortal.makePortalZ(world, pos.func_177982_a(0, yy - 2, -radius));
            }
            if (yy == height / 2 + 2) {
                this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), radius + 1), 3, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -radius - 1), 4, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, false, rand.nextInt(2) + 3);
            }
            if (yy == height / 2 + 4) {
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), radius + 1), 3, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -radius - 1), 4, 4);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, 3);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, 3);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, 3);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, 3);
            }
            if (yy == height / 2 + 7) {
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(3), radius + 1), 3, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(3), -radius - 1), 4, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, 2);
                this.createSmallBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, 2);
            }
            if (yy != 0) continue;
            this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), 0), 1, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), 0), 2, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), radius + 1), 3, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -radius - 1), 4, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), radius + 1), 5, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), -radius - 1), 6, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(-radius - 1, yy - rand.nextInt(2), radius + 1), 7, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, pos.func_177982_a(radius + 1, yy - rand.nextInt(2), -radius - 1), 8, true, rand.nextInt(2) + 3);
        }
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        LocationPortal location = new LocationPortal(worldStorage, UUID.randomUUID().toString(), SharedRegion.getFromBlockPos(pos), pos);
        location.addBounds(new AxisAlignedBB(pos).func_72314_b(8.0, 10.0, 8.0).func_72317_d(0.0, 8.0, 0.0));
        location.setSeed(rand.nextLong());
        location.setDirty(true);
        location.setVisible(false);
        location.linkChunks();
        worldStorage.addSharedStorage(location);
        return true;
    }

    private void createSmallBranch(World world, Random rand, BlockPos pos, int dir, int branchLength) {
        int y = 0;
        block10: for (int i = 0; i <= branchLength; ++i) {
            if (i >= 2) {
                ++y;
            }
            switch (dir) {
                case 1: {
                    this.func_175903_a(world, pos.func_177965_g(i).func_177981_b(y), this.bark);
                    continue block10;
                }
                case 2: {
                    this.func_175903_a(world, pos.func_177985_f(i).func_177981_b(y), this.bark);
                    continue block10;
                }
                case 3: {
                    this.func_175903_a(world, pos.func_177970_e(i).func_177981_b(y), this.bark);
                    continue block10;
                }
                case 4: {
                    this.func_175903_a(world, pos.func_177964_d(i).func_177981_b(y), this.bark);
                    continue block10;
                }
                case 5: {
                    this.func_175903_a(world, pos.func_177965_g(i).func_177981_b(y).func_177970_e(i), this.bark);
                    continue block10;
                }
                case 6: {
                    this.func_175903_a(world, pos.func_177985_f(i).func_177981_b(y).func_177964_d(i), this.bark);
                    continue block10;
                }
                case 7: {
                    this.func_175903_a(world, pos.func_177985_f(i).func_177981_b(y).func_177970_e(i), this.bark);
                    continue block10;
                }
                case 8: {
                    this.func_175903_a(world, pos.func_177965_g(i).func_177981_b(y).func_177964_d(i), this.bark);
                }
            }
        }
    }

    private void createMainCanopy(World world, Random rand, BlockPos pos, int maxRadius) {
        for (int x1 = -maxRadius; x1 <= maxRadius; ++x1) {
            for (int z1 = -maxRadius; z1 <= maxRadius; ++z1) {
                for (int y1 = 0; y1 < maxRadius; ++y1) {
                    double dSq = Math.pow(x1, 2.0) + Math.pow(z1, 2.0) + Math.pow(y1, 2.5);
                    if (Math.round(Math.sqrt(dSq)) <= (long)maxRadius && world.func_180495_p(pos.func_177982_a(x1, y1, z1)) != this.bark && rand.nextInt(5) != 0) {
                        this.func_175903_a(world, pos.func_177982_a(x1, y1, z1), this.leaves);
                    }
                    if (Math.round(Math.sqrt(dSq)) < (long)(maxRadius - 1) && rand.nextInt(5) == 0 && y1 > 0 && world.func_180495_p(pos.func_177982_a(x1, y1, z1)) != this.bark) {
                        this.func_175903_a(world, pos.func_177982_a(x1, y1, z1), this.bark);
                    }
                    if (Math.round(Math.sqrt(dSq)) > (long)maxRadius || rand.nextInt(3) != 0 || y1 != 0 || world.func_180495_p(pos.func_177982_a(x1, y1, z1)) == this.bark) continue;
                    for (int i = 1; i < 1 + rand.nextInt(3); ++i) {
                        this.func_175903_a(world, pos.func_177982_a(x1, y1 - i, z1), this.leaves);
                    }
                }
            }
        }
    }

    private void createBranch(World world, Random rand, BlockPos pos, int dir, boolean root, int branchLength) {
        int y = 0;
        block10: for (int i = 0; i <= branchLength; ++i) {
            if (i >= 3) {
                ++y;
            }
            switch (dir) {
                case 1: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177965_g(i).func_177981_b(y), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177965_g(i).func_177979_c(y), this.bark);
                    this.func_175903_a(world, pos.func_177965_g(i).func_177979_c(y - 1), this.bark);
                    continue block10;
                }
                case 2: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177985_f(i).func_177981_b(y), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177985_f(i).func_177979_c(y), this.bark);
                    this.func_175903_a(world, pos.func_177985_f(i).func_177979_c(y - 1), this.bark);
                    continue block10;
                }
                case 3: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177970_e(i).func_177981_b(y), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177970_e(i).func_177979_c(y), this.bark);
                    this.func_175903_a(world, pos.func_177970_e(i).func_177979_c(y - 1), this.bark);
                    continue block10;
                }
                case 4: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177964_d(i).func_177981_b(y), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177964_d(i).func_177979_c(y), this.bark);
                    this.func_175903_a(world, pos.func_177964_d(i).func_177979_c(y - 1), this.bark);
                    continue block10;
                }
                case 5: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177965_g(i - 1).func_177981_b(y).func_177970_e(i - 1), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177965_g(i - 1).func_177979_c(y).func_177970_e(i - 1), this.bark);
                    this.func_175903_a(world, pos.func_177965_g(i - 1).func_177979_c(y - 1).func_177970_e(i - 1), this.bark);
                    continue block10;
                }
                case 6: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177985_f(i - 1).func_177981_b(y).func_177964_d(i - 1), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177985_f(i - 1).func_177979_c(y).func_177964_d(i - 1), this.bark);
                    this.func_175903_a(world, pos.func_177985_f(i - 1).func_177979_c(y - 1).func_177964_d(i - 1), this.bark);
                    continue block10;
                }
                case 7: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177985_f(i - 1).func_177981_b(y).func_177970_e(i - 1), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177985_f(i - 1).func_177979_c(y).func_177970_e(i - 1), this.bark);
                    this.func_175903_a(world, pos.func_177985_f(i - 1).func_177979_c(y - 1).func_177970_e(i - 1), this.bark);
                    continue block10;
                }
                case 8: {
                    if (!root) {
                        this.func_175903_a(world, pos.func_177965_g(i - 1).func_177981_b(y).func_177964_d(i - 1), this.bark);
                        continue block10;
                    }
                    this.func_175903_a(world, pos.func_177965_g(i - 1).func_177979_c(y).func_177964_d(i - 1), this.bark);
                    this.func_175903_a(world, pos.func_177965_g(i - 1).func_177979_c(y - 1).func_177964_d(i - 1), this.bark);
                }
            }
        }
    }
}

