/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.WorldGenHelper;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class WorldGenSmallRuins
extends WorldGenHelper {
    private static final IBlockState ANGRY_BETWEENSTONE = BlockRegistry.ANGRY_BETWEENSTONE.func_176223_P();
    private static final IBlockState BETWEENSTONE_TILES = BlockRegistry.BETWEENSTONE_TILES.func_176223_P();
    private static final IBlockState BETWEENSTONE_BRICKS = BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P();
    private static final IBlockState BETWEENSTONE_BRICK_STAIRS = BlockRegistry.BETWEENSTONE_BRICK_STAIRS.func_176223_P();
    private static final IBlockState BETWEENSTONE_BRICK_SLAB = BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P();
    private static final IBlockState BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN = BETWEENSTONE_BRICK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    private static final IBlockState CHISELED_BETWEENSTONE = BlockRegistry.BETWEENSTONE_CHISELED.func_176223_P();
    private static final IBlockState BETWEENSTONE_PILLAR = BlockRegistry.BETWEENSTONE_PILLAR.func_176223_P();
    private static final IBlockState SMOOTH_BETWEENSTONE_WALL = BlockRegistry.SMOOTH_BETWEENSTONE_WALL.func_176223_P();
    private static final IBlockState WEEDWOOD_LOG = BlockRegistry.LOG_WEEDWOOD.func_176223_P();
    private static final IBlockState WEEDWOOD_PLANK_STAIRS = BlockRegistry.WEEDWOOD_PLANK_STAIRS.func_176223_P();
    private static final IBlockState WEEDWOOD_PLANK_SLAB = BlockRegistry.WEEDWOOD_PLANK_SLAB.func_176223_P();
    private static final IBlockState WEEDWOOD_PLANK_SLAB_UPSIDE_DOWN = WEEDWOOD_PLANK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    private static final IBlockState BETWEENSTONE_BRICK_WALL = BlockRegistry.BETWEENSTONE_BRICK_WALL.func_176223_P();
    private static final IBlockState WEEDWOOD_FENCE = BlockRegistry.WEEDWOOD_PLANK_FENCE.func_176223_P();
    private static final IBlockState ROPE = BlockRegistry.ROPE.func_176223_P();

    public WorldGenSmallRuins() {
        super(BlockRegistry.MUD.func_176223_P(), BlockRegistry.SWAMP_GRASS.func_176223_P());
    }

    public boolean func_180709_b(World world, Random random, BlockPos position) {
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        LocationStorage locationStorage = new LocationStorage(worldStorage, UUID.randomUUID().toString(), SharedRegion.getFromBlockPos(position), "translate:ruins", EnumLocationType.RUINS);
        ArrayList<RuinLocation> ruinLocations = new ArrayList<RuinLocation>();
        block18: for (int attempts = 40; attempts >= 0; --attempts) {
            int x = position.func_177958_n() + random.nextInt(16) - 8;
            int z = position.func_177952_p() + random.nextInt(16) - 8;
            int y = position.func_177956_o() + random.nextInt(8) - 3;
            int randomInt = random.nextInt(7);
            switch (randomInt) {
                case 0: {
                    if (!this.structure1(world, random, x, y, z, false, locationStorage)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 1: {
                    if (!this.structure2(world, random, x, y, z, false, locationStorage)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 2: {
                    if (!this.structure3(world, random, x, y, z, false, locationStorage)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 3: {
                    if (!this.structure4(world, random, x, y, z, false, locationStorage)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 4: {
                    if (!this.structure5(world, random, x, y, z, false, locationStorage)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 5: {
                    if (!this.structure6(world, random, x, y, z, false, locationStorage)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                    continue block18;
                }
                case 6: {
                    if (!this.structure7(world, random, x, y, z, false, locationStorage)) continue block18;
                    ruinLocations.add(new RuinLocation(world, random, x, y, z, randomInt));
                }
            }
        }
        if (ruinLocations.size() >= 3) {
            for (RuinLocation location : ruinLocations) {
                switch (location.structureID) {
                    case 0: {
                        this.structure1(location.world, location.random, location.x, location.y, location.z, true, locationStorage);
                        break;
                    }
                    case 1: {
                        this.structure2(location.world, location.random, location.x, location.y, location.z, true, locationStorage);
                        break;
                    }
                    case 2: {
                        this.structure3(location.world, location.random, location.x, location.y, location.z, true, locationStorage);
                        break;
                    }
                    case 3: {
                        this.structure4(location.world, location.random, location.x, location.y, location.z, true, locationStorage);
                        break;
                    }
                    case 4: {
                        this.structure5(location.world, location.random, location.x, location.y, location.z, true, locationStorage);
                        break;
                    }
                    case 5: {
                        this.structure6(location.world, location.random, location.x, location.y, location.z, true, locationStorage);
                        break;
                    }
                    case 6: {
                        this.structure7(location.world, location.random, location.x, location.y, location.z, true, locationStorage);
                    }
                }
            }
            locationStorage.setSeed(random.nextLong());
            locationStorage.linkChunks();
            locationStorage.setDirty(true);
            worldStorage.addSharedStorage(locationStorage);
            return true;
        }
        return false;
    }

    private boolean structure1(World world, Random random, int x, int y, int z, boolean doGen, LocationStorage location) {
        int height = 9 + random.nextInt(2);
        this.width = 8;
        this.depth = 1;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 2, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND) || !this.rotatedCubeMatches(world, x, y, z, 6, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction, location);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 0, BETWEENSTONE_TILES, 1, height - 5, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, BETWEENSTONE_TILES, 1, height - 5, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 5, 0, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 5, 0, BETWEENSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 1, height - 5, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, height - 4, 0, BETWEENSTONE_BRICK_SLAB, 2, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 3, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 3, 0, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 4, height - 3, 0, BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, height - 3, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 2, 0, BETWEENSTONE_BRICK_SLAB, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 1, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, height - 1, 0, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedLootPot(world, random, x, y, z, 4, height - 2, 0, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
        }
        return true;
    }

    private boolean structure2(World world, Random random, int x, int y, int z, boolean doGen, LocationStorage location) {
        int height = 13 + random.nextInt(2);
        this.width = 7;
        this.depth = 1;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 2, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND) || !this.rotatedCubeMatches(world, x, y, z, 6, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction, location);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 0, BETWEENSTONE_TILES, 1, height - 9, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, BETWEENSTONE_TILES, 1, height - 9, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 9, 0, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 9, 0, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 8, 0, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 8, 0, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 7, 0, BETWEENSTONE_BRICKS, 1, 5, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 7, 0, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 6, 0, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 4, height - 6, 0, BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, height - 6, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, height - 6, 0, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, height - 5, 0, BETWEENSTONE_BRICK_SLAB, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, height - 2, 0, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 1, height - 2, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, height - 1, 0, BETWEENSTONE_BRICK_SLAB, 2, 1, 1, direction, new Consumer[0]);
            if (random.nextInt(5) == 0) {
                this.rotatedCubeVolume(world, x, y, z, 0, height - 1, 0, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedLootPot(world, random, x, y, z, 0, height, 0, direction, 1, 2, 1, LootTableRegistry.COMMON_POT_LOOT);
            }
        }
        return true;
    }

    private boolean structure3(World world, Random random, int x, int y, int z, boolean doGen, LocationStorage location) {
        this.width = 7;
        this.depth = 5;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 7, this.depth, direction)) {
            return false;
        }
        if (!(this.rotatedCubeMatches(world, x, y, z, 2, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND) && this.rotatedCubeMatches(world, x, y, z, 6, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND) && this.rotatedCubeMatches(world, x, y, z, 2, -1, 4, 1, 1, 1, direction, SurfaceType.MIXED_GROUND) && this.rotatedCubeMatches(world, x, y, z, 6, -1, 4, 1, 1, 1, direction, SurfaceType.MIXED_GROUND))) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, 7, this.depth, direction, location);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 0, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 4, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 4, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 1, 4, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 1, 4, 4, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 0, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 0, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 4, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 4, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 5, 0, BETWEENSTONE_BRICK_SLAB, 2, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 5, 0, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 5, 4, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 5, 0, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 5, 4, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 5, 1, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 1, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 5, 3, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 3, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 6, 0, BETWEENSTONE_BRICK_SLAB, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 6, 4, BETWEENSTONE_BRICK_SLAB, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 6, 1, BETWEENSTONE_BRICK_SLAB, 1, 1, 3, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 6, 1, BETWEENSTONE_BRICK_SLAB, 1, 1, 3, direction, new Consumer[0]);
            this.rotatedLootPot(world, random, x, y, z, 2, 6, 0, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
            this.rotatedLootPot(world, random, x, y, z, 6, 6, 0, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
            this.rotatedLootPot(world, random, x, y, z, 2, 6, 4, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
            this.rotatedLootPot(world, random, x, y, z, 6, 6, 4, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
        }
        return true;
    }

    private boolean structure4(World world, Random random, int x, int y, int z, boolean doGen, LocationStorage location) {
        int height = 9 + random.nextInt(2);
        int width = 6;
        for (int zz = z; zz < z + width; ++zz) {
            for (int yy = y; yy < y + height; ++yy) {
                for (int xx = x; xx > x - width; --xx) {
                    if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && (world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() == BlockRegistry.SWAMP_WATER && yy < y + height - 2)) continue;
                    return false;
                }
            }
        }
        if (!(SurfaceType.MIXED_GROUND.matches(world.func_180495_p(new BlockPos(x - width, y - 1, z + 1))) && SurfaceType.MIXED_GROUND.matches(world.func_180495_p(new BlockPos(x - width, y - 1, z + width - 1))) && SurfaceType.MIXED_GROUND.matches(world.func_180495_p(new BlockPos(x - 1, y - 1, z + width))) && SurfaceType.MIXED_GROUND.matches(world.func_180495_p(new BlockPos(x - 1, y - 1, z + width))))) {
            return false;
        }
        if (doGen) {
            int yy;
            location.addBounds(new AxisAlignedBB((double)(x - width), (double)y, (double)z, (double)x, (double)(y + height), (double)(z + width)).func_72314_b(6.0, 6.0, 6.0));
            for (yy = y; yy < y + height; ++yy) {
                int zz;
                if (yy <= y + height - 5) {
                    if (yy == y) {
                        world.func_175656_a(new BlockPos(x - width, yy, z + 1), BETWEENSTONE_TILES);
                    } else {
                        world.func_175656_a(new BlockPos(x - width, yy, z + 1), BETWEENSTONE_BRICK_WALL);
                    }
                    world.func_175656_a(new BlockPos(x - width + 1, yy, z + 1), BETWEENSTONE_TILES);
                    continue;
                }
                if (yy == y + height - 4) {
                    world.func_175656_a(new BlockPos(x - width, yy, z + 1), BETWEENSTONE_BRICK_WALL);
                    world.func_175656_a(new BlockPos(x - width + 1, yy, z + 1), BETWEENSTONE_BRICKS);
                    continue;
                }
                if (yy != y + height - 3) continue;
                world.func_180501_a(new BlockPos(x - width + 1, yy, z + 1), this.getStateFromRotation(3, 0, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 3);
                world.func_180501_a(new BlockPos(x - width + 1, yy, z + 2), this.getStateFromRotation(1, 0, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 3);
                world.func_175656_a(new BlockPos(x - width + 1, yy + 1, z + 2), BETWEENSTONE_BRICK_SLAB);
                for (zz = z + 3; zz <= z + width - 3; ++zz) {
                    world.func_175656_a(new BlockPos(x - width + 1, yy + 1, zz), BETWEENSTONE_BRICK_SLAB);
                    world.func_180501_a(new BlockPos(x - width + 1, yy, zz), BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 3);
                }
                world.func_180501_a(new BlockPos(x - width + 1, yy, zz), this.getStateFromRotation(3, 0, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 3);
                world.func_175656_a(new BlockPos(x - width + 1, yy + 1, zz), BETWEENSTONE_BRICK_SLAB);
            }
            for (yy = y; yy < y + height; ++yy) {
                int xx;
                if (yy <= y + height - 5) {
                    if (yy == y) {
                        world.func_175656_a(new BlockPos(x - width, yy, z + width - 1), BETWEENSTONE_TILES);
                        world.func_175656_a(new BlockPos(x - width + 1, yy, z + width), BETWEENSTONE_TILES);
                    } else {
                        world.func_175656_a(new BlockPos(x - width, yy, z + width - 1), BETWEENSTONE_BRICK_WALL);
                        world.func_175656_a(new BlockPos(x - width + 1, yy, z + width), BETWEENSTONE_BRICK_WALL);
                    }
                    world.func_175656_a(new BlockPos(x - width + 1, yy, z + width - 1), BETWEENSTONE_TILES);
                    continue;
                }
                if (yy <= y + height - 2) {
                    if (yy == y + height - 4) {
                        world.func_175656_a(new BlockPos(x - width, yy, z + width - 1), BETWEENSTONE_BRICK_WALL);
                        world.func_175656_a(new BlockPos(x - width + 1, yy, z + width), BETWEENSTONE_BRICK_WALL);
                    }
                    world.func_175656_a(new BlockPos(x - width + 1, yy, z + width - 1), BETWEENSTONE_BRICKS);
                    continue;
                }
                if (yy > y + height - 1) continue;
                world.func_175656_a(new BlockPos(x - width + 1, yy, z + width - 1), BETWEENSTONE_BRICK_STAIRS);
                world.func_180501_a(new BlockPos(x - width + 2, yy, z + width - 1), this.getStateFromRotation(2, 0, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 3);
                world.func_175656_a(new BlockPos(x - width + 2, yy + 1, z + width - 1), BETWEENSTONE_BRICK_SLAB);
                for (xx = x - width + 3; xx <= x - 3; ++xx) {
                    world.func_180501_a(new BlockPos(xx, yy, z + width - 1), BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 3);
                    if (random.nextInt(8) == 0) {
                        this.generateLoot(world, random, xx, yy + 1, z + width - 1);
                        continue;
                    }
                    world.func_175656_a(new BlockPos(xx, yy + 1, z + width - 1), BETWEENSTONE_BRICK_SLAB);
                }
                world.func_180501_a(new BlockPos(xx, yy, z + width - 1), this.getStateFromRotation(0, 0, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 3);
                world.func_175656_a(new BlockPos(xx, yy + 1, z + width - 1), BETWEENSTONE_BRICK_SLAB);
            }
            for (yy = y; yy < y + height; ++yy) {
                if (yy <= y + height - 5) {
                    if (yy == y) {
                        world.func_175656_a(new BlockPos(x - 1, yy, z + width), BETWEENSTONE_TILES);
                    } else {
                        world.func_175656_a(new BlockPos(x - 1, yy, z + width), BETWEENSTONE_BRICK_WALL);
                    }
                    world.func_175656_a(new BlockPos(x - 1, yy, z + width - 1), BETWEENSTONE_TILES);
                    continue;
                }
                if (yy <= y + height - 2) {
                    if (yy == y + height - 4) {
                        world.func_175656_a(new BlockPos(x - 1, yy, z + width), BETWEENSTONE_BRICK_WALL);
                    }
                    if (yy == y + height - 3) {
                        world.func_180501_a(new BlockPos(x, yy, z + width - 1), this.getStateFromRotation(2, 0, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 3);
                    }
                    world.func_175656_a(new BlockPos(x - 1, yy, z + width - 1), BETWEENSTONE_BRICKS);
                    continue;
                }
                if (yy != y + height - 1) continue;
                world.func_180501_a(new BlockPos(x - 1, yy, z + width - 1), this.getStateFromRotation(2, 0, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 3);
            }
        }
        return true;
    }

    private boolean structure5(World world, Random random, int x, int y, int z, boolean doGen, LocationStorage location) {
        int height = 5 + random.nextInt(2);
        this.width = 1;
        this.depth = 1;
        int direction = 0;
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, height, this.depth, direction, location);
            this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, BETWEENSTONE_PILLAR, 1, height - 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, height - 1, 0, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedLootPot(world, random, x, y, z, 0, height, 0, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
        }
        return true;
    }

    private boolean structure6(World world, Random random, int x, int y, int z, boolean doGen, LocationStorage location) {
        this.width = 5 + random.nextInt(2);
        this.depth = 1;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 1, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND) || !this.rotatedCubeMatches(world, x, y, z, this.width - 1, -1, 0, 1, 1, 1, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, 1, this.depth, direction, location);
            this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, this.getStateFromRotation(7, direction, BETWEENSTONE_PILLAR, WorldGenHelper.EnumRotationSequence.PILLAR_SIDEWAYS), this.width - 2, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, this.width - 1, 0, 0, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedLootPot(world, random, x, y, z, 0, 1, 0, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
            this.rotatedLootPot(world, random, x, y, z, this.width - 1, 1, 0, direction, 1, 2, 5, LootTableRegistry.COMMON_POT_LOOT);
        }
        return true;
    }

    private boolean structure7(World world, Random random, int x, int y, int z, boolean doGen, LocationStorage location) {
        this.width = 12;
        this.depth = 12;
        int direction = random.nextInt(4);
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED_GROUND) && !this.rotatedCubeMatches(world, x, --y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 13, this.depth, direction)) {
            return false;
        }
        if (doGen) {
            this.addLocationArea(world, x, y, z, 0, 0, 0, this.width, 13, this.depth, direction, location);
            this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, BETWEENSTONE_BRICKS, 1, 1, 4, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, BETWEENSTONE_BRICKS, 1, 1, 3, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 1, 3, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 2, 0, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 2, 1, BETWEENSTONE_BRICKS, 1, 1, 2, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, BETWEENSTONE_TILES, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 1, 1, SMOOTH_BETWEENSTONE_WALL, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 1, BETWEENSTONE_TILES, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 1, 1, SMOOTH_BETWEENSTONE_WALL, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 2, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 2, BETWEENSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 2, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 0, 2, BETWEENSTONE_BRICKS, 1, 7, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 7, 2, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 0, 2, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 2, 2, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 3, 2, BETWEENSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 0, 2, BETWEENSTONE_BRICKS, 1, 5, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 5, 2, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 2, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 4, 2, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 11, 0, 2, BETWEENSTONE_TILES, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 11, 1, 2, SMOOTH_BETWEENSTONE_WALL, 1, 3, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 3, this.getStateFromRotation(1, direction, WEEDWOOD_PLANK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 3, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 3, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 3, WEEDWOOD_PLANK_SLAB_UPSIDE_DOWN, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 3, BETWEENSTONE_BRICKS, 1, 6, 3, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 3, 3, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 3, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 4, WEEDWOOD_PLANK_SLAB_UPSIDE_DOWN, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 4, BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 4, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 3, 4, ROPE, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 4, this.getStateFromRotation(0, direction, WEEDWOOD_LOG, WorldGenHelper.EnumRotationSequence.LOG_SIDEWAYS), 5, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 4, 4, WEEDWOOD_FENCE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 2, 4, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 4, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 5, this.getStateFromRotation(3, direction, WEEDWOOD_PLANK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 5, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 5, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 5, WEEDWOOD_PLANK_SLAB_UPSIDE_DOWN, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 5, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 6, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 6, BETWEENSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 8, 6, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 8, 6, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 9, 6, BETWEENSTONE_BRICK_SLAB, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 4, 8, 6, BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 8, 6, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 6, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 6, BETWEENSTONE_BRICKS, 1, 6, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 10, 6, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 5, 6, WEEDWOOD_PLANK_SLAB_UPSIDE_DOWN, 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 0, 6, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedLootPot(world, random, x, y, z, 9, 1, 6, direction, 1, 2, 1, LootTableRegistry.COMMON_POT_LOOT);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 6, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 4, 6, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 5, 6, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 11, 0, 6, BETWEENSTONE_TILES, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 11, 1, 6, SMOOTH_BETWEENSTONE_WALL, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 7, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 7, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 0, 7, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 5, 7, WEEDWOOD_PLANK_SLAB_UPSIDE_DOWN, 2, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 7, BETWEENSTONE_BRICKS, 1, 6, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 7, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 0, 8, BETWEENSTONE_BRICKS, 4, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 8, BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 8, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 4, 8, WEEDWOOD_FENCE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 5, 8, this.getStateFromRotation(0, direction, WEEDWOOD_LOG, WorldGenHelper.EnumRotationSequence.LOG_SIDEWAYS), 3, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 8, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 2, 8, CHISELED_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 3, 8, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 8, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 0, 9, BETWEENSTONE_BRICKS, 4, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 8, 9, this.getStateFromRotation(1, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 9, 9, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 0, 9, ANGRY_BETWEENSTONE, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 0, 9, BETWEENSTONE_BRICKS, 2, 1, 1, direction, new Consumer[0]);
            this.rotatedLootPot(world, random, x, y, z, 9, 1, 9, direction, 1, 2, 1, LootTableRegistry.COMMON_POT_LOOT);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 9, BETWEENSTONE_BRICKS, 1, 5, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 5, 9, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 9, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 0, 10, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 2, 4, 10, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 0, 10, BETWEENSTONE_BRICKS, 7, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 3, 2, 10, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 4, 2, 10, BETWEENSTONE_BRICKS, 2, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 3, 10, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 8, 10, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 9, 10, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 5, 11, 10, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 4, 12, 10, BETWEENSTONE_BRICK_SLAB, 2, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 0, 10, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 4, 10, this.getStateFromRotation(3, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 5, 10, BETWEENSTONE_BRICKS, 1, 6, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 6, 11, 10, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 2, 10, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 6, 10, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 7, 7, 10, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 2, 10, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 6, 10, BETWEENSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 8, 7, 10, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 2, 10, BETWEENSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 6, 10, this.getStateFromRotation(0, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 9, 7, 10, BETWEENSTONE_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 10, BETWEENSTONE_TILES, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 4, 10, BETWEENSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 6, 10, this.getStateFromRotation(2, direction, BETWEENSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 11, 0, 10, BETWEENSTONE_TILES, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 11, 1, 10, SMOOTH_BETWEENSTONE_WALL, 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 0, 11, BETWEENSTONE_TILES, 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 10, 1, 11, SMOOTH_BETWEENSTONE_WALL, 1, 4, 1, direction, new Consumer[0]);
        }
        return true;
    }

    private boolean addLocationArea(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction, LocationStorage location) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                location.addBounds(new AxisAlignedBB((double)(x + offsetA), (double)(y + offsetB), (double)(z + offsetC), (double)(x + offsetA + sizeWidth), (double)(y + offsetB + sizeHeight), (double)(z + offsetC + sizeDepth)).func_72314_b(6.0, 6.0, 6.0));
                break;
            }
            case 1: {
                location.addBounds(new AxisAlignedBB((double)(x + offsetC), (double)(y + offsetB), (double)(z + this.depth - offsetA - sizeWidth - 1), (double)(x + offsetC + sizeDepth), (double)(y + offsetB + sizeHeight), (double)(z + this.depth - offsetA - 1)).func_72314_b(6.0, 6.0, 6.0));
                break;
            }
            case 2: {
                location.addBounds(new AxisAlignedBB((double)(x + this.width - offsetA - sizeWidth - 1), (double)(y + offsetB), (double)(z + this.depth - offsetC - sizeDepth - 1), (double)(x + this.width - offsetA - 1), (double)(y + offsetB + sizeHeight), (double)(z + this.depth - offsetC - 1)).func_72314_b(6.0, 6.0, 6.0));
                break;
            }
            case 3: {
                location.addBounds(new AxisAlignedBB((double)(x + this.width - offsetC - sizeDepth - 1), (double)(y + offsetB), (double)(z + offsetA), (double)(x + this.width - offsetC - 1), (double)(y + offsetB + sizeHeight), (double)(z + offsetA + sizeWidth)).func_72314_b(6.0, 6.0, 6.0));
            }
        }
        return true;
    }

    private void generateLoot(World world, Random random, int x, int y, int z) {
        world.func_180501_a(new BlockPos(x, y, z), this.getRandomBlock(random, EnumFacing.func_176731_b((int)random.nextInt(4))), 2);
        TileEntityLootPot lootPot = BlockLootPot.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (lootPot != null) {
            lootPot.setLootTable(LootTableRegistry.COMMON_POT_LOOT, random.nextLong());
        }
    }

    private IBlockState getRandomBlock(Random rand, EnumFacing dir) {
        switch (rand.nextInt(3)) {
            case 0: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1)).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)dir);
            }
            case 1: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_2)).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)dir);
            }
            case 2: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_3)).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)dir);
            }
        }
        return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1)).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)dir);
    }

    private static class RuinLocation {
        World world;
        Random random;
        int x;
        int y;
        int z;
        int structureID;

        RuinLocation(World world, Random random, int x, int y, int z, int structureID) {
            this.world = world;
            this.random = random;
            this.x = x;
            this.y = y;
            this.z = z;
            this.structureID = structureID;
        }
    }
}

