/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.WorldGenHelper;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationStorage;

public class WorldGenMudStructures
extends WorldGenHelper {
    private static final IBlockState MUD_BRICKS = BlockRegistry.MUD_BRICKS.func_176223_P();
    private static final IBlockState MUD_BRICK_SLAB = BlockRegistry.MUD_BRICK_SLAB.func_176223_P();
    private static final IBlockState MUD_BRICK_SLAB_UPSIDE_DOWN = MUD_BRICK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    private static final IBlockState MUD_BRICK_STAIRS = BlockRegistry.MUD_BRICK_STAIRS.func_176223_P();
    private static final IBlockState MUD_FLOWER_POT = BlockRegistry.MUD_FLOWER_POT.func_176223_P();
    private static final IBlockState ROTTEN_BARK = BlockRegistry.LOG_ROTTEN_BARK.func_176223_P();
    private static final IBlockState GECKO_CAGE = BlockRegistry.GECKO_CAGE.func_176223_P();
    private List<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();

    public WorldGenMudStructures() {
        super(new IBlockState[0]);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int randomInt = rand.nextInt(3);
        int x = position.func_177958_n();
        int y = position.func_177956_o();
        int z = position.func_177952_p();
        boolean generated = false;
        this.bounds.clear();
        switch (randomInt) {
            case 0: {
                generated = this.structure1(worldIn, rand, x, y, z);
                break;
            }
            case 1: {
                generated = this.structure2(worldIn, rand, x, y, z);
                break;
            }
            case 2: {
                generated = this.structure3(worldIn, rand, x, y, z);
                break;
            }
            default: {
                generated = false;
            }
        }
        if (generated) {
            BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(worldIn);
            LocationStorage locationStorage = new LocationStorage(worldStorage, UUID.randomUUID().toString(), SharedRegion.getFromBlockPos(position), "translate:abandoned_shack", EnumLocationType.RUINS);
            locationStorage.setSeed(rand.nextLong());
            for (AxisAlignedBB aabb : this.bounds) {
                locationStorage.addBounds(aabb.func_72314_b(2.0, 1.0, 2.0));
            }
            locationStorage.linkChunks();
            locationStorage.setDirty(true);
            worldStorage.addSharedStorage(locationStorage);
        }
        return generated;
    }

    private boolean structure1(World world, Random random, int x, int y, int z) {
        this.width = 7;
        this.depth = 5;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 2, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        this.bounds.add(this.rotatedAABB(world, x, y, z, 0.0, -2.0, 0.0, this.width, 8.0, this.depth, direction));
        this.rotatedCubeVolumeExtendedDown(world, x, y, z, 0, -1, 0, MUD_BRICKS, this.width, 1, this.depth, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, MUD_BRICKS, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, this.getStateFromRotation(3, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 3, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 1, 0, MUD_FLOWER_POT, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 1, this.getStateFromRotation(0, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 1, MUD_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, MUD_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 3, MUD_BRICKS, 1, 1, 2, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 3, this.getStateFromRotation(0, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 2, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 4, MUD_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 4, this.getStateFromRotation(1, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 4, MUD_BRICKS, 3, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 4, MUD_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 1, 4, this.getStateFromRotation(1, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 4, this.getStateFromRotation(2, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 3, MUD_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedLootPot(world, random, x, y, z, 5, 0, 3, direction, 1, 3, 2, LootTableRegistry.COMMON_POT_LOOT);
        return true;
    }

    private boolean structure2(World world, Random random, int x, int y, int z) {
        this.width = 6;
        this.depth = 6;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 2, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        this.bounds.add(this.rotatedAABB(world, x, y, z, 0.0, -2.0, 0.0, this.width, 8.0, this.depth, direction));
        this.rotatedCubeVolumeExtendedDown(world, x, y, z, 0, -1, 1, MUD_BRICKS, this.width, 1, this.depth - 1, direction, new Consumer[0]);
        this.rotatedCubeVolumeExtendedDown(world, x, y, z, 1, -1, 0, MUD_BRICKS, this.width - 2, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, MUD_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, this.getStateFromRotation(3, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 1, MUD_BRICKS, 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 1, this.getStateFromRotation(0, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 1, MUD_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 1, MUD_BRICK_SLAB, 4, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 5, MUD_BRICKS, 5, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, this.getStateFromRotation(1, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 5, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 1, MUD_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 1, MUD_BRICKS, 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 1, 1, this.getStateFromRotation(2, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 0, MUD_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 0, this.getStateFromRotation(3, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 2, this.getStateFromRotation(2, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 3, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 2, this.getStateFromRotation(0, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 3, direction, new Consumer[0]);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 2, direction, 1, 2, 3, LootTableRegistry.COMMON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 3, direction, 1, 2, 3, LootTableRegistry.COMMON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 4, direction, 1, 2, 3, LootTableRegistry.COMMON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 4, 0, 2, direction, 1, 2, 3, LootTableRegistry.COMMON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 4, 0, 3, direction, 1, 2, 3, LootTableRegistry.COMMON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 4, 0, 4, direction, 1, 2, 3, LootTableRegistry.COMMON_POT_LOOT);
        return true;
    }

    private boolean structure3(World world, Random random, int x, int y, int z) {
        this.width = 8;
        this.depth = 8;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 2, this.depth, direction)) {
            return false;
        }
        if (!this.rotatedCubeMatches(world, x, y, z, 0, -1, 0, this.width, 1, this.depth, direction, SurfaceType.MIXED_GROUND)) {
            return false;
        }
        this.bounds.add(this.rotatedAABB(world, x, y, z, 0.0, -2.0, 0.0, this.width, 8.0, this.depth, direction));
        this.rotatedCubeVolumeExtendedDown(world, x, y, z, 0, -1, 1, MUD_BRICKS, this.width, 1, this.depth - 2, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 1, MUD_BRICKS, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 1, this.getStateFromRotation(3, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 2, 1, ROTTEN_BARK, 1, 1, 7, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 1, MUD_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 2, 1, this.getStateFromRotation(0, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, MUD_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 1, MUD_BRICKS, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 0, this.getStateFromRotation(3, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 2, MUD_BRICKS, 3, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 2, this.getStateFromRotation(0, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 2, MUD_BRICKS, 2, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 2, this.getStateFromRotation(3, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 2, 2, MUD_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 3, MUD_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 3, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 3, MUD_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 3, this.getStateFromRotation(3, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 2, 4, MUD_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 2, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 4, MUD_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 5, MUD_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 5, ROTTEN_BARK, 1, 1, 3, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 5, GECKO_CAGE, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 6, MUD_BRICKS, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 6, this.getStateFromRotation(0, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 6, MUD_BRICKS, 3, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 6, MUD_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 2, 6, MUD_BRICKS, 2, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 6, MUD_BRICKS, 2, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 2, 6, this.getStateFromRotation(2, direction, MUD_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 6, MUD_BRICK_SLAB, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 3, direction, 1, 4, 2, LootTableRegistry.COMMON_POT_LOOT);
        return true;
    }
}

