/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import thebetweenlands.common.block.structure.BlockDruidStone;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.tile.spawner.TileEntityMobSpawnerBetweenlands;
import thebetweenlands.common.world.storage.world.global.BetweenlandsWorldData;
import thebetweenlands.common.world.storage.world.shared.SharedRegion;
import thebetweenlands.common.world.storage.world.shared.location.EnumLocationType;
import thebetweenlands.common.world.storage.world.shared.location.LocationGuarded;
import thebetweenlands.common.world.storage.world.shared.location.guard.ILocationGuard;
import thebetweenlands.util.config.ConfigHandler;

public class WorldGenDruidCircle
implements IWorldGenerator {
    private static final IBlockState[] RUNE_STONES = new IBlockState[]{BlockRegistry.DRUID_STONE_1.func_176223_P(), BlockRegistry.DRUID_STONE_2.func_176223_P(), BlockRegistry.DRUID_STONE_3.func_176223_P(), BlockRegistry.DRUID_STONE_4.func_176223_P(), BlockRegistry.DRUID_STONE_5.func_176223_P()};
    private final int height = 4;
    private final int baseRadius = 6;
    private final int checkRadius = 32;
    private ILocationGuard guard;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generate(World world, Random random, int startX, int startZ) {
        BlockPos genPos = null;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos center = new BlockPos(startX, 64, startZ);
        if (world.func_175707_a(center.func_177982_a(-7, 0, -7), center.func_177982_a(7, 0, 7))) {
            block0: for (int xo = this.baseRadius + 1; xo <= this.checkRadius - this.baseRadius - 1; ++xo) {
                for (int zo = this.baseRadius + 1; zo <= this.checkRadius - this.baseRadius - 1; ++zo) {
                    int x = startX + xo;
                    int z = startZ + zo;
                    pos.func_181079_c(x, 0, z);
                    Biome biome = world.func_180494_b((BlockPos)pos);
                    if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) continue;
                    int newY = world.func_175645_m((BlockPos)pos).func_177956_o() - 1;
                    pos.func_185336_p(newY);
                    IBlockState block = world.func_180495_p((BlockPos)pos);
                    if (block != biome.field_76752_A || !this.canGenerateAt(world, pos.func_177984_a())) continue;
                    genPos = pos.func_177984_a();
                    break block0;
                }
            }
        }
        if (genPos != null && random.nextInt(ConfigHandler.druidCircleFrequency) == 0) {
            this.generateStructure(world, random, genPos);
        }
    }

    public boolean canGenerateAt(World world, BlockPos altar) {
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)altar.func_177982_a(-this.baseRadius, 1, -this.baseRadius), (BlockPos)altar.func_177982_a(this.baseRadius, this.height, this.baseRadius))) {
            if (world.func_175623_d(p) || world.func_180495_p(p).func_177230_c().func_176200_f((IBlockAccess)world, p)) continue;
            return false;
        }
        return true;
    }

    public void generateStructure(World world, Random rand, BlockPos altar) {
        BetweenlandsWorldData worldStorage = BetweenlandsWorldData.forWorld(world);
        LocationGuarded location = new LocationGuarded(worldStorage, UUID.randomUUID().toString(), SharedRegion.getFromBlockPos(altar), "druidAltar", EnumLocationType.NONE);
        this.guard = location.getGuard();
        location.addBounds(new AxisAlignedBB(new BlockPos((Vec3i)altar)).func_72314_b(8.0, 10.0, 8.0));
        location.linkChunks();
        location.setLayer(0);
        location.setSeed(rand.nextLong());
        location.setVisible(false);
        location.setDirty(true);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        IBlockState ground = world.func_180494_b((BlockPos)altar).field_76752_A;
        IBlockState filler = world.func_180494_b((BlockPos)altar).field_76753_B;
        int altarX = altar.func_177958_n();
        int altarY = altar.func_177956_o();
        int altarZ = altar.func_177952_p();
        for (int x = -this.baseRadius; x <= this.baseRadius; ++x) {
            for (int z = -this.baseRadius; z <= this.baseRadius; ++z) {
                pos.func_181079_c(altarX + x, altarY, altarZ + z);
                int dSq = (int)Math.round(Math.sqrt(x * x + z * z));
                if (dSq == this.baseRadius) {
                    if (x % 2 == 0 && z % 2 == 0) {
                        this.placePillar(world, pos, rand);
                    } else {
                        this.placeAir(world, pos);
                    }
                }
                if (dSq > this.baseRadius) continue;
                for (int yo = 0; yo < 16; ++yo) {
                    Biome biome = world.getBiomeForCoordsBody((BlockPos)pos);
                    IBlockState blockState = world.func_180495_p((BlockPos)pos);
                    if (blockState == biome.field_76753_B || blockState == biome.field_76752_A || blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151578_c) {
                        world.func_175698_g(pos.func_185334_h());
                    }
                    pos.func_185336_p(pos.func_177956_o() + 1);
                }
                pos.func_185336_p(altarY - 1);
                world.func_175656_a(pos.func_185334_h(), ground);
                this.guard.setGuarded(world, (BlockPos)pos, true);
                int offset = world.field_73012_v.nextInt(2);
                if (world.func_175623_d(pos.func_177979_c(2)) || world.func_180495_p(pos.func_177979_c(2)).func_185904_a().func_76224_d()) {
                    --offset;
                }
                for (int yo = 0; yo < 10; ++yo) {
                    float f = dSq;
                    this.getClass();
                    if (!(f <= 6.0f / 10.0f * (float)(10 - yo) + (float)offset)) continue;
                    pos.func_185336_p(altarY - 2 - yo);
                    world.func_175656_a(pos.func_185334_h(), filler);
                    this.guard.setGuarded(world, (BlockPos)pos, true);
                }
            }
        }
        world.func_175656_a(altar, BlockRegistry.DRUID_ALTAR.func_176223_P());
        world.func_175656_a(altar.func_177977_b(), BlockRegistry.MOB_SPAWNER.func_176223_P());
        TileEntity te = world.func_175625_s(altar.func_177977_b());
        if (te instanceof TileEntityMobSpawnerBetweenlands) {
            MobSpawnerLogicBetweenlands logic = ((TileEntityMobSpawnerBetweenlands)te).getSpawnerLogic();
            logic.setNextEntityName("thebetweenlands.dark_druid").setCheckRange(32.0).setSpawnRange(6).setSpawnInAir(false).setMaxEntities(1 + world.field_73012_v.nextInt(3));
        }
        this.guard.setGuarded(world, altar, true);
        this.guard.setGuarded(world, altar.func_177977_b(), true);
        worldStorage.addSharedStorage(location);
    }

    private void placeAir(World world, BlockPos.MutableBlockPos pos) {
        Biome biome = world.func_180494_b((BlockPos)pos);
        int k = 0;
        int y = pos.func_177956_o();
        while (k <= this.height) {
            IBlockState blockState = world.func_180495_p((BlockPos)pos);
            if (blockState == biome.field_76753_B || blockState == biome.field_76752_A || blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151578_c) {
                world.func_175698_g(pos.func_185334_h());
            }
            pos.func_185336_p(y + ++k);
        }
    }

    private void placePillar(World world, BlockPos.MutableBlockPos pos, Random rand) {
        int height = rand.nextInt(3) + 3;
        int k = 0;
        int y = pos.func_177956_o();
        while (k <= height) {
            this.guard.setGuarded(world, (BlockPos)pos, true);
            EnumFacing facing = EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length)];
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_185334_h(), this.getRandomRuneBlock(rand).func_177226_a((IProperty)BlockDruidStone.FACING, (Comparable)facing), 3);
            } else {
                world.func_175656_a(pos.func_185334_h(), BlockRegistry.DRUID_STONE_6.func_176223_P().func_177226_a((IProperty)BlockDruidStone.FACING, (Comparable)facing));
                for (int vineCount = 0; vineCount < 4; ++vineCount) {
                    this.setRandomFoliage(world, (BlockPos)pos, rand);
                }
            }
            pos.func_185336_p(y + ++k);
        }
    }

    private void setRandomFoliage(World world, BlockPos pos, Random rand) {
        EnumFacing facing = EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length)];
        BlockPos side = pos.func_185334_h().func_177972_a(facing);
        if (world.func_175623_d(side)) {
            world.func_175656_a(side, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)facing.func_176734_d()), (Comparable)Boolean.valueOf(true)));
        }
    }

    private IBlockState getRandomRuneBlock(Random rand) {
        return RUNE_STONES[rand.nextInt(RUNE_STONES.length)];
    }
}

