/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.loot;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thebetweenlands.util.IWeightProvider;

public class LootItemStack
implements IWeightProvider {
    private final Item item;
    private short minDamage = 0;
    private short maxDamage = 0;
    private byte minAmount = 1;
    private byte maxAmount = 1;
    private short weight = 1;

    public LootItemStack(Block block) {
        this.item = Item.func_150898_a((Block)block);
    }

    public LootItemStack(Item item) {
        this.item = item;
    }

    public LootItemStack setDamage(int min, int max) {
        this.minDamage = (short)Math.max(1, min);
        this.maxDamage = (short)Math.max(1, max);
        return this;
    }

    public LootItemStack setDamage(int damage) {
        this.minDamage = this.maxDamage = (short)damage;
        return this;
    }

    public LootItemStack setAmount(int min, int max) {
        this.minAmount = (byte)Math.max(1, min);
        this.maxAmount = (byte)Math.max(1, max);
        return this;
    }

    public LootItemStack setAmount(int amount) {
        this.minAmount = this.maxAmount = (byte)Math.max(1, amount);
        return this;
    }

    public LootItemStack setWeight(int weight) {
        this.weight = (short)Math.max(1, weight);
        return this;
    }

    @Override
    public short getWeight() {
        return this.weight;
    }

    public ItemStack getIS(Random rand) {
        return new ItemStack(this.item, rand.nextInt(this.maxAmount - this.minAmount + 1) + this.minAmount, rand.nextInt(this.maxDamage - this.minDamage + 1) + this.minDamage);
    }
}

