/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class WorldGenSwampReedCluster
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        boolean generated = false;
        IBlockState iblockstate = world.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)world, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)world, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = world.func_180495_p(position);
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos pos = position.func_177982_a(rand.nextInt(10) - rand.nextInt(10), rand.nextInt(8) - rand.nextInt(8), rand.nextInt(10) - rand.nextInt(10));
            if (SurfaceType.WATER.matches(world, pos.func_177984_a()) && world.func_180495_p(pos).func_177230_c() == BlockRegistry.MUD && world.func_175623_d(pos.func_177981_b(2))) {
                this.generateReedStack(world, rand, pos.func_177984_a());
                generated = true;
                continue;
            }
            if (!SurfaceType.MIXED_GROUND.matches(world, pos) || !BlockRegistry.SWAMP_REED.func_176196_c(world, pos.func_177984_a())) continue;
            this.generateReedStack(world, rand, pos.func_177984_a());
            generated = true;
        }
        return generated;
    }

    private void generateReedStack(World world, Random rand, BlockPos pos) {
        BlockPos offsetPos;
        IBlockState state;
        int height = world.field_73012_v.nextInt(4) + 2;
        for (int yo = 0; yo < height && ((state = world.func_180495_p(offsetPos = pos.func_177982_a(0, yo, 0))).func_177230_c() == Blocks.field_150350_a || SurfaceType.WATER.matches(state)); ++yo) {
            if (SurfaceType.WATER.matches(state)) {
                this.func_175903_a(world, offsetPos, BlockRegistry.SWAMP_REED_UNDERWATER.func_176223_P());
                continue;
            }
            this.func_175903_a(world, offsetPos, BlockRegistry.SWAMP_REED.func_176223_P());
        }
    }
}

