/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.terrain.BlockLogBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;

public class WorldGenRottenLogs
extends WorldGenerator {
    private int length = -1;
    private int baseRadius = -1;
    private byte direction;
    private IBlockState log;

    public WorldGenRottenLogs(int length, int baseRadius, byte direction) {
        this.length = length;
        this.baseRadius = baseRadius;
        this.direction = direction;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.log = BlockRegistry.LOG_ROTTEN_BARK.func_176223_P().func_177226_a((IProperty)BlockLogBetweenlands.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.direction == 1) {
            for (int xx = x - this.baseRadius; this.baseRadius + x >= xx; ++xx) {
                for (int zz = z - this.length; this.length + z - 1 >= zz; ++zz) {
                    for (int yy = y + 1; yy <= y + this.baseRadius * 2; ++yy) {
                        BlockPos offsetPos = new BlockPos(xx, yy, zz);
                        if (world.func_180495_p(offsetPos).func_177230_c().func_176200_f((IBlockAccess)world, offsetPos)) continue;
                        return false;
                    }
                }
            }
            for (int zz = z - this.length; this.length + z - 1 >= zz; ++zz) {
                for (int i = this.baseRadius * -1; i <= this.baseRadius; ++i) {
                    for (int j = this.baseRadius * -1; j <= this.baseRadius; ++j) {
                        double dSq = i * i + j * j;
                        BlockPos offsetPos = new BlockPos(x + i, y + j + this.baseRadius, zz);
                        if (Math.round(Math.sqrt(dSq)) == (long)this.baseRadius) {
                            world.func_175656_a(offsetPos, this.log);
                            if (rand.nextInt(12) == 0) {
                                world.func_175698_g(offsetPos);
                            }
                            if ((zz != z - this.length || rand.nextInt(2) != 0) && (zz != z + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(offsetPos);
                            continue;
                        }
                        world.func_175698_g(offsetPos);
                    }
                }
            }
        } else {
            int xx;
            for (xx = x - this.length; this.length + x - 1 >= xx; ++xx) {
                for (int zz = z - this.baseRadius; this.baseRadius + z >= zz; ++zz) {
                    for (int yy = y + 1; yy <= y + this.baseRadius * 2; ++yy) {
                        BlockPos offsetPos = new BlockPos(xx, yy, zz);
                        if (world.func_180495_p(offsetPos).func_177230_c().func_176200_f((IBlockAccess)world, offsetPos)) continue;
                        return false;
                    }
                }
            }
            for (xx = x - this.length; this.length + x - 1 >= xx; ++xx) {
                for (int i = this.baseRadius * -1; i <= this.baseRadius; ++i) {
                    for (int j = this.baseRadius * -1; j <= this.baseRadius; ++j) {
                        double dSq = i * i + j * j;
                        BlockPos offsetPos = new BlockPos(xx, y + j + this.baseRadius, z + i);
                        if (Math.round(Math.sqrt(dSq)) == (long)this.baseRadius) {
                            world.func_175656_a(offsetPos, this.log);
                            if (rand.nextInt(12) == 0) {
                                world.func_175698_g(offsetPos);
                            }
                            if ((xx != x - this.length || rand.nextInt(2) != 0) && (xx != x + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(offsetPos);
                            continue;
                        }
                        world.func_175698_g(offsetPos);
                    }
                }
            }
        }
        return true;
    }
}

