/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class WorldGenRootsCluster
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        boolean generated = false;
        IBlockState iblockstate = world.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)world, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)world, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = world.func_180495_p(position);
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos pos = position.func_177982_a(rand.nextInt(10) - rand.nextInt(10), rand.nextInt(8) - rand.nextInt(8), rand.nextInt(10) - rand.nextInt(10));
            if (!SurfaceType.MIXED_GROUND.matches(world, pos) || !this.generateRootsStack(world, rand, pos.func_177984_a())) continue;
            generated = true;
        }
        return generated;
    }

    private boolean generateRootsStack(World world, Random rand, BlockPos pos) {
        int yo;
        int height = 6;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (yo = 0; yo < 6; ++yo) {
            checkPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + yo, pos.func_177952_p());
            if (world.func_175623_d((BlockPos)checkPos)) continue;
            height = yo;
            break;
        }
        if (height < 2) {
            return false;
        }
        height = rand.nextInt(height) + 1 + rand.nextInt(4);
        for (yo = 0; yo < height; ++yo) {
            BlockPos offsetPos = pos.func_177982_a(0, yo, 0);
            this.func_175903_a(world, offsetPos, BlockRegistry.ROOT.func_176223_P());
        }
        return true;
    }
}

