/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.plant.BlockPoisonIvy;
import thebetweenlands.common.registries.BlockRegistry;

public class WorldGenDeadWeedwoodTree
extends WorldGenerator {
    private IBlockState log;
    private IBlockState bark;
    private IBlockState wood;
    private IBlockState ivy;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int radius = rand.nextInt(2) + 3;
        int height = rand.nextInt(2) + 15;
        int maxRadius = 9;
        this.log = BlockRegistry.LOG_ROTTEN_BARK.func_176223_P();
        this.bark = BlockRegistry.LOG_ROTTEN_BARK.func_176223_P();
        this.wood = BlockRegistry.WEEDWOOD.func_176223_P();
        this.ivy = BlockRegistry.POISON_IVY.func_176223_P();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_175623_d(new BlockPos(xx, yy, zz)) || world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (yy % 5 == 0 && radius > 1) {
                --radius;
            }
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) < (long)radius && yy <= y + height - 2) {
                        this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.wood);
                    }
                    if ((Math.round(Math.sqrt(dSq)) != (long)radius || yy != y) && (Math.round(Math.sqrt(dSq)) != (long)radius || yy > y + height - 1)) continue;
                    this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.bark);
                }
            }
            if (yy == y + height / 2 + 2) {
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z, 1, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z, 2, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x, yy - rand.nextInt(1), z + radius + 1, 3, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x, yy - rand.nextInt(1), z - radius - 1, 4, false, rand.nextInt(2) + 4);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z + radius + 1, 5, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z - radius - 1, 6, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z + radius + 1, 7, false, rand.nextInt(2) + 3);
                this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z - radius - 1, 8, false, rand.nextInt(2) + 3);
            }
            if (yy == y + height / 2 + 4) {
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z, 1, 4);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z, 2, 4);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(1), z + radius + 1, 3, 4);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(1), z - radius - 1, 4, 4);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z + radius + 1, 5, 3);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z - radius - 1, 6, 3);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z + radius + 1, 7, 3);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z - radius - 1, 8, 3);
            }
            if (yy == y + height / 2 + 7) {
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z, 1, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z, 2, 2);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3, 2);
                this.createSmallBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4, 2);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z + radius + 1, 5, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z - radius - 1, 6, 2);
                this.createSmallBranch(world, rand, x - radius - 1, yy - rand.nextInt(1), z + radius + 1, 7, 2);
                this.createSmallBranch(world, rand, x + radius + 1, yy - rand.nextInt(1), z - radius - 1, 8, 2);
            }
            if (yy != y + 1) continue;
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(3), z, 1, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(3), z, 2, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z + radius + 1, 3, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x, yy - rand.nextInt(3), z - radius - 1, 4, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z + radius + 1, 5, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z - radius - 1, 6, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x - radius - 1, yy - rand.nextInt(2), z + radius + 1, 7, true, rand.nextInt(2) + 3);
            this.createBranch(world, rand, x + radius + 1, yy - rand.nextInt(2), z - radius - 1, 8, true, rand.nextInt(2) + 3);
        }
        return true;
    }

    private void createSmallBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        for (int i = 0; i <= branchLength; ++i) {
            if (dir == 1) {
                this.func_175903_a(world, new BlockPos(x + i, y, z), this.log);
            }
            if (dir == 2) {
                this.func_175903_a(world, new BlockPos(x - i, y, z), this.log);
            }
            if (dir == 3) {
                this.func_175903_a(world, new BlockPos(x, y, z + i), this.log);
            }
            if (dir == 4) {
                this.func_175903_a(world, new BlockPos(x, y, z - i), this.log);
            }
            if (dir == 5) {
                this.func_175903_a(world, new BlockPos(x + i - 1, y, z + i - 1), this.log);
            }
            if (dir == 6) {
                this.func_175903_a(world, new BlockPos(x - i + 1, y, z - i + 1), this.log);
            }
            if (dir == 7) {
                this.func_175903_a(world, new BlockPos(x - i + 1, y, z + i - 1), this.log);
            }
            if (dir != 8) continue;
            this.func_175903_a(world, new BlockPos(x + i - 1, y, z - i + 1), this.log);
        }
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, boolean root, int branchLength) {
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 3) {
                y = !root ? ++y : --y;
            }
            if (dir == 1) {
                if (!root) {
                    this.func_175903_a(world, new BlockPos(x + i, y, z), this.log);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x + i, y - 1, z, EnumFacing.WEST);
                    }
                } else {
                    this.func_175903_a(world, new BlockPos(x + i, y, z), this.log);
                    this.func_175903_a(world, new BlockPos(x + i, y - 1, z), this.log);
                }
            }
            if (dir == 2) {
                if (!root) {
                    this.func_175903_a(world, new BlockPos(x - i, y, z), this.log);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x - i, y - 1, z, EnumFacing.EAST);
                    }
                } else {
                    this.func_175903_a(world, new BlockPos(x - i, y, z), this.log);
                    this.func_175903_a(world, new BlockPos(x - i, y - 1, z), this.log);
                }
            }
            if (dir == 3) {
                if (!root) {
                    this.func_175903_a(world, new BlockPos(x, y, z + i), this.log);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x, y - 1, z + i, EnumFacing.NORTH);
                    }
                } else {
                    this.func_175903_a(world, new BlockPos(x, y, z + i), this.log);
                    this.func_175903_a(world, new BlockPos(x, y - 1, z + i), this.log);
                }
            }
            if (dir == 4) {
                if (!root) {
                    this.func_175903_a(world, new BlockPos(x, y, z - i), this.log);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x, y - 1, z - i, EnumFacing.SOUTH);
                    }
                } else {
                    this.func_175903_a(world, new BlockPos(x, y, z - i), this.log);
                    this.func_175903_a(world, new BlockPos(x, y - 1, z - i), this.log);
                }
            }
            if (dir == 5) {
                if (!root) {
                    this.func_175903_a(world, new BlockPos(x + i - 1, y, z + i - 1), this.log);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x + i - 1, y - 1, z + i - 1, EnumFacing.WEST);
                    }
                } else {
                    this.func_175903_a(world, new BlockPos(x + i - 1, y, z + i - 1), this.log);
                    this.func_175903_a(world, new BlockPos(x + i - 1, y - 1, z + i - 1), this.log);
                }
            }
            if (dir == 6) {
                if (!root) {
                    this.func_175903_a(world, new BlockPos(x - i + 1, y, z - i + 1), this.log);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x - i + 1, y - 1, z - i + 1, EnumFacing.SOUTH);
                    }
                } else {
                    this.func_175903_a(world, new BlockPos(x - i + 1, y, z - i + 1), this.log);
                    this.func_175903_a(world, new BlockPos(x - i + 1, y - 1, z - i + 1), this.log);
                }
            }
            if (dir == 7) {
                if (!root) {
                    this.func_175903_a(world, new BlockPos(x - i + 1, y, z + i - 1), this.log);
                    if (i <= branchLength) {
                        this.addVines(world, rand, x - i + 1, y - 1, z + i - 1, EnumFacing.EAST);
                    }
                } else {
                    this.func_175903_a(world, new BlockPos(x - i + 1, y, z + i - 1), this.log);
                    this.func_175903_a(world, new BlockPos(x - i + 1, y - 1, z + i - 1), this.log);
                }
            }
            if (dir != 8) continue;
            if (!root) {
                this.func_175903_a(world, new BlockPos(x + i - 1, y, z - i + 1), this.log);
                if (i > branchLength) continue;
                this.addVines(world, rand, x + i - 1, y - 1, z - i + 1, EnumFacing.NORTH);
                continue;
            }
            this.func_175903_a(world, new BlockPos(x + i - 1, y, z - i + 1), this.log);
            this.func_175903_a(world, new BlockPos(x + i - 1, y - 1, z - i + 1), this.log);
        }
    }

    private void addVines(World world, Random rand, int x, int y, int z, EnumFacing ... dirs) {
        IBlockState state = this.ivy;
        block6: for (EnumFacing dir : dirs) {
            switch (dir) {
                default: {
                    state = state.func_177226_a((IProperty)BlockPoisonIvy.field_176273_b, (Comparable)Boolean.valueOf(true));
                    continue block6;
                }
                case SOUTH: {
                    state = state.func_177226_a((IProperty)BlockPoisonIvy.field_176279_N, (Comparable)Boolean.valueOf(true));
                    continue block6;
                }
                case EAST: {
                    state = state.func_177226_a((IProperty)BlockPoisonIvy.field_176278_M, (Comparable)Boolean.valueOf(true));
                    continue block6;
                }
                case WEST: {
                    state = state.func_177226_a((IProperty)BlockPoisonIvy.field_176280_O, (Comparable)Boolean.valueOf(true));
                    continue block6;
                }
                case UP: {
                    state = state.func_177226_a((IProperty)BlockPoisonIvy.field_176277_a, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        if (BlockRegistry.POISON_IVY.func_176198_a(world, new BlockPos(x, y, z), dirs[0].func_176734_d()) && rand.nextInt(4) != 0) {
            int length = rand.nextInt(4) + 4;
            for (int yy = y; yy > y - length && world.func_175623_d(new BlockPos(x, yy, z)); --yy) {
                this.func_175903_a(world, new BlockPos(x, yy, z), state);
            }
        }
    }
}

