/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public abstract class WorldGenCave
extends WorldGenerator {
    protected final EnumFacing[] directions = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST};

    public WorldGenCave(boolean doBlockNotify) {
        super(doBlockNotify);
    }

    protected boolean isGoodStart(World world, BlockPos pos) {
        if (this.supports(world, pos)) {
            int sides = 0;
            for (EnumFacing dir : this.directions) {
                if (!this.isValidBlock(world, pos.func_177972_a(dir))) {
                    return false;
                }
                if (!this.isValidBlock(world, pos.func_177972_a(dir).func_177977_b()) || !world.isSideSolid(pos.func_177972_a(dir).func_177977_b(), dir)) continue;
                ++sides;
            }
            return sides > 0;
        }
        return false;
    }

    protected boolean supports(World world, BlockPos pos) {
        return this.isValidBlock(world, pos) && world.func_175623_d(pos.func_177977_b());
    }

    protected boolean isValidBlock(World world, BlockPos pos) {
        return SurfaceType.UNDERGROUND.matches(world.func_180495_p(pos));
    }

    protected class PlantLocation {
        private BlockPos pos;
        private int height;

        public PlantLocation(World world, BlockPos pos) {
            this.setPos(pos);
            this.setHeight(1);
            while (world.func_175623_d(pos.func_177982_a(0, -this.getHeight(), 0)) && pos.func_177956_o() - this.getHeight() > 0) {
                this.setHeight(this.getHeight() + 1);
            }
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void setPos(BlockPos pos) {
            this.pos = pos;
        }
    }
}

