/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import thebetweenlands.util.OpenSimplexNoise;

public class FractalOpenSimplexNoise {
    private OpenSimplexNoise[] octaves;
    private double scale;

    public FractalOpenSimplexNoise(int octaves, double scale) {
        this(Double.doubleToRawLongBits(Math.random()), octaves, scale);
    }

    public FractalOpenSimplexNoise(long seed, int octaves, double scale) {
        this.octaves = new OpenSimplexNoise[octaves];
        this.scale = scale;
        for (int i = 0; i < octaves; ++i) {
            seed = (seed * 25214903917L + 11L) % 0x1000000000000L;
            this.octaves[i] = new OpenSimplexNoise(seed);
        }
    }

    public double eval(double x, double y) {
        double eval = 0.0;
        for (int o = 0; o < this.octaves.length; ++o) {
            eval += this.octaves[o].eval(x * (double)(1 << o) * this.scale, y * (double)(1 << o) * this.scale) * Math.pow(0.5, o);
        }
        return Math.max(-1.0, Math.min(eval, 1.0));
    }

    public double eval(double x, double y, double z) {
        double eval = 0.0;
        try {
            for (int o = 0; o < this.octaves.length; ++o) {
                eval += this.octaves[o].eval(x * (double)(1 << o) * this.scale, y * (double)(1 << o) * this.scale, z * (double)(1 << o) * this.scale) * Math.pow(0.5, o);
            }
        }
        catch (Error ex) {
            System.out.println("Position: " + x + " " + y + " " + z);
            ex.printStackTrace();
        }
        return Math.max(-1.0, Math.min(eval, 1.0));
    }

    public double eval(double x, double y, double z, double w) {
        double eval = 0.0;
        for (int o = 0; o < this.octaves.length; ++o) {
            eval += this.octaves[o].eval(x * (double)(1 << o) * this.scale, y * (double)(1 << o) * this.scale, z * (double)(1 << o) * this.scale, w * (double)(1 << o) * this.scale) * Math.pow(0.5, o);
        }
        return Math.max(-1.0, Math.min(eval, 1.0));
    }
}

