/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class MiddleGemFeature
extends BiomeFeature {
    private Random rand = new Random();
    private long seed;

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        this.seed = seed;
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.rand.setSeed(this.seed);
        long seedX = this.rand.nextLong() / 2L * 2L + 1L;
        long seedZ = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * seedX + (long)chunkZ * seedZ ^ this.seed);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        float biomeWeight;
        if (pass == BiomeGenerator.EnumGeneratorPass.POST_GEN_CAVES && (biomeWeight = biomeWeights.get(x, z)) >= 1.0f && this.rand.nextInt(60) == 0) {
            IBlockState state;
            int y;
            for (y = 255; y > 1 && ((state = chunkPrimer.func_177856_a(x, y, z)).func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == BlockRegistry.SWAMP_WATER); --y) {
            }
            if (y <= 1 && y >= 255) {
                return;
            }
            IBlockState blockState = chunkPrimer.func_177856_a(x, y, z);
            IBlockState blockStateAbove = chunkPrimer.func_177856_a(x, y + 1, z);
            if (blockState.func_177230_c() == BlockRegistry.MUD && blockStateAbove.func_177230_c() == BlockRegistry.SWAMP_WATER) {
                IBlockState gem;
                switch (this.rand.nextInt(3)) {
                    default: {
                        gem = BlockRegistry.AQUA_MIDDLE_GEM_ORE.func_176223_P();
                        break;
                    }
                    case 1: {
                        gem = BlockRegistry.CRIMSON_MIDDLE_GEM_ORE.func_176223_P();
                        break;
                    }
                    case 2: {
                        gem = BlockRegistry.GREEN_MIDDLE_GEM_ORE.func_176223_P();
                    }
                }
                chunkPrimer.func_177855_a(x, y, z, gem);
            }
        }
    }
}

