/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.decorator;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;

public class DecoratorPositionProvider {
    private Biome biome;
    private World world;
    private int x;
    private int y;
    private int z;
    private int seaGroundY;
    private Random rand;
    private IChunkGenerator generator;
    private int minOffsetXZ = 8;
    private int maxOffsetXZ = 24;
    private int minOffsetY = -8;
    private int maxOffsetY = 8;

    @Nullable
    public IChunkGenerator getChunkGenerator() {
        return this.generator;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public int offsetXZ() {
        return this.rand.nextInt(this.maxOffsetXZ - this.minOffsetXZ) + this.minOffsetXZ;
    }

    public int offsetXZ(int padding) {
        return this.rand.nextInt(32 - padding * 2) + padding;
    }

    public int offsetY() {
        return this.rand.nextInt(this.maxOffsetY - this.minOffsetY) + this.minOffsetY;
    }

    public BlockPos getRandomPos() {
        return new BlockPos(this.x + this.offsetXZ(), this.y + this.offsetY(), this.z + this.offsetXZ());
    }

    public BlockPos getRandomPos(int padding) {
        return new BlockPos(this.x + this.offsetXZ(padding), this.y + this.offsetY(), this.z + this.offsetXZ(padding));
    }

    public BlockPos getRandomPosSeaGround() {
        return new BlockPos(this.x + this.offsetXZ(), this.seaGroundY + this.offsetY(), this.z + this.offsetXZ());
    }

    public BlockPos getRandomPosSeaGround(int padding) {
        return new BlockPos(this.x + this.offsetXZ(padding), this.seaGroundY + this.offsetY(), this.z + this.offsetXZ(padding));
    }

    public int getRandomPosX() {
        return this.x + this.offsetXZ();
    }

    public int getRandomPosX(int padding) {
        return this.x + this.offsetXZ(padding);
    }

    public int getRandomPosZ() {
        return this.z + this.offsetXZ();
    }

    public int getRandomPosZ(int padding) {
        return this.z + this.offsetXZ(padding);
    }

    public int getRandomPosY() {
        return this.y + this.offsetY();
    }

    public int getRandomPosYSeaGround() {
        return this.seaGroundY + this.offsetY();
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getSeaGroundY() {
        return this.seaGroundY;
    }

    public int getZ() {
        return this.z;
    }

    public Random getRand() {
        return this.rand;
    }

    public DecoratorPositionProvider setOffsetXZ(int min, int max) {
        this.minOffsetXZ = min;
        this.maxOffsetXZ = max;
        return this;
    }

    public DecoratorPositionProvider setOffsetY(int min, int max) {
        this.minOffsetY = min;
        this.maxOffsetY = max;
        return this;
    }

    public void init(World world, Biome biome, @Nullable IChunkGenerator generator, Random rand, int x, int y, int z) {
        this.generator = generator;
        this.biome = biome;
        this.x = x;
        this.z = z;
        this.y = y == -1 ? world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o() : y;
        this.seaGroundY = this.y;
        if (this.y <= 120 && world.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_185904_a().func_76224_d()) {
            BlockPos.MutableBlockPos offsetPos = new BlockPos.MutableBlockPos();
            for (int oy = this.y; oy > 0; --oy) {
                offsetPos.func_181079_c(this.x, oy, this.z);
                if (world.func_180495_p((BlockPos)offsetPos).func_185904_a().func_76224_d()) continue;
                this.seaGroundY = oy;
                break;
            }
        }
        this.rand = rand;
        this.world = world;
    }

    public void init(World world, Biome biome, @Nullable IChunkGenerator generator, Random rand, int x, int z) {
        this.init(world, biome, generator, rand, x, -1, z);
    }
}

