/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Random;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import thebetweenlands.common.world.event.EnvironmentEvent;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;

public abstract class TimedEnvironmentEvent
extends EnvironmentEvent {
    protected int ticks = 0;
    protected int startTicks = 0;

    public TimedEnvironmentEvent(EnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public void update(World world) {
        if (!this.getRegistry().isDisabled()) {
            --this.ticks;
            if (!world.field_72995_K && this.ticks % 20 == 0) {
                this.setDirty(true);
            }
            if (!world.field_72995_K && this.ticks <= 0) {
                this.startTicks = this.isActive() ? (this.ticks = this.getOffTime(world.field_73012_v)) : (this.ticks = this.getOnTime(world.field_73012_v));
                this.setActive(!this.isActive(), true);
            }
        }
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getStartTicks() {
        return this.startTicks;
    }

    public int getTicksElapsed() {
        return this.startTicks - this.ticks;
    }

    @Override
    public void setActive(boolean active, boolean markDirty) {
        super.setActive(active, false);
        if (!this.getWorld().field_72995_K) {
            this.startTicks = !this.isActive() ? (this.ticks = this.getOffTime(this.getWorld().field_73012_v)) : (this.ticks = this.getOnTime(this.getWorld().field_73012_v));
            if (markDirty) {
                this.markDirty();
            }
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        this.getData().func_74768_a("ticks", this.ticks);
        this.getData().func_74768_a("startTicks", this.startTicks);
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        this.ticks = this.getData().func_74762_e("ticks");
        this.startTicks = this.getData().func_74762_e("startTicks");
    }

    @Override
    public void loadEventPacket(PacketBuffer buffer) {
        super.loadEventPacket(buffer);
        this.ticks = buffer.readInt();
        this.startTicks = buffer.readInt();
    }

    @Override
    public void sendEventPacket(PacketBuffer buffer) {
        super.sendEventPacket(buffer);
        buffer.writeInt(this.ticks);
        buffer.writeInt(this.startTicks);
    }

    @Override
    public void setDefaults() {
        this.ticks = this.getOffTime(new Random());
    }

    public abstract int getOffTime(Random var1);

    public abstract int getOnTime(Random var1);
}

