/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.EnvironmentEvent;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;

public class EventSpoopy
extends EnvironmentEvent {
    private static final long SPOOPY_DATE = new GregorianCalendar(Calendar.getInstance().get(1), 9, 23, 0, 0).getTime().getTime();
    private World world;
    private World lastWorld;
    private boolean chatSent = false;
    private float skyTransparency = 0.0f;
    private float lastSkyTransparency = 0.0f;
    private boolean wasSet = false;

    public void setSkyTransparency(float transparency) {
        this.lastSkyTransparency = this.skyTransparency;
        this.skyTransparency = transparency;
    }

    public float getSkyTransparency(float partialTicks) {
        return (this.skyTransparency + (this.skyTransparency - this.lastSkyTransparency) * partialTicks) / 2.0f;
    }

    public EventSpoopy(EnvironmentEventRegistry registry) {
        super(registry);
    }

    public long getDayDiff() {
        return TimeUnit.DAYS.convert(Calendar.getInstance().getTime().getTime() - SPOOPY_DATE, TimeUnit.MILLISECONDS);
    }

    public static boolean isSpoopy(World world) {
        WorldProviderBetweenlands provider;
        if (world != null && (provider = WorldProviderBetweenlands.getProvider(world)) != null) {
            return provider.getEnvironmentEventRegistry().SPOOPY.isActive();
        }
        return false;
    }

    @Override
    public String getEventName() {
        return "Spook";
    }

    @Override
    public void setActive(boolean active, boolean markDirty) {
        EntityPlayer player;
        if (active && TheBetweenlands.proxy.getClientWorld() != null && (!this.isActive() || this.lastWorld != TheBetweenlands.proxy.getClientWorld()) && TheBetweenlands.proxy.getClientPlayer() != null && this.world != null && this.world.field_72995_K) {
            this.lastWorld = TheBetweenlands.proxy.getClientWorld();
            player = TheBetweenlands.proxy.getClientPlayer();
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.event.spook", new Object[0]));
        }
        if (active != this.isActive() && TheBetweenlands.proxy.getClientWorld() != null && TheBetweenlands.proxy.getClientPlayer() != null) {
            player = TheBetweenlands.proxy.getClientPlayer();
            int px = MathHelper.func_76128_c((double)player.field_70165_t) - 256;
            int py = MathHelper.func_76128_c((double)player.field_70163_u) - 256;
            int pz = MathHelper.func_76128_c((double)player.field_70161_v) - 256;
            TheBetweenlands.proxy.getClientWorld().func_147458_c(px, py, pz, px + 512, py + 512, pz + 512);
        }
        super.setActive(active, markDirty);
    }

    @Override
    public void update(World world) {
        super.update(world);
        this.world = world;
        if (!world.field_72995_K) {
            long dayDiff = this.getDayDiff();
            if (dayDiff >= 0L && dayDiff <= 8L) {
                if (!this.isActive() && !this.wasSet) {
                    this.setActive(true, true);
                    this.wasSet = true;
                }
            } else if (this.wasSet) {
                this.wasSet = false;
                this.setActive(false, true);
            }
        } else if (this.isActive()) {
            if (this.skyTransparency < 1.0f) {
                this.setSkyTransparency(this.skyTransparency + 0.003f);
            }
            if (this.skyTransparency > 1.0f) {
                this.setSkyTransparency(1.0f);
            }
        } else {
            if (this.skyTransparency > 0.0f) {
                this.setSkyTransparency(this.skyTransparency - 0.003f);
            }
            if (this.skyTransparency < 0.0f) {
                this.setSkyTransparency(0.0f);
            }
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        this.getData().func_74757_a("wasSet", this.wasSet);
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        this.wasSet = this.getData().func_74767_n("wasSet");
    }
}

