/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Random;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventAuroras
extends TimedEnvironmentEvent {
    private short auroraType = 0;

    public EventAuroras(EnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public String getEventName() {
        return "auroras";
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(42000) + 28000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(20000) + 8000;
    }

    @Override
    public void setActive(boolean active, boolean markDirty) {
        if (active && this.getRegistry().getActiveEvents().size() <= 1 || !active) {
            super.setActive(active, markDirty);
            if (active && !this.getWorld().field_72995_K) {
                this.auroraType = (short)this.getWorld().field_73012_v.nextInt(3);
            }
        }
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!world.field_72995_K && this.getRegistry().getActiveEvents().size() > 1 && this.ticks > 500) {
            this.ticks = 500;
            this.setDirty(true);
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        this.getData().func_74777_a("auroraType", this.auroraType);
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        this.auroraType = this.getData().func_74765_d("auroraType");
    }

    @Override
    public void loadEventPacket(PacketBuffer buffer) {
        super.loadEventPacket(buffer);
        this.auroraType = buffer.readShort();
    }

    @Override
    public void sendEventPacket(PacketBuffer buffer) {
        super.sendEventPacket(buffer);
        buffer.writeShort((int)this.auroraType);
    }

    public short getAuroraType() {
        return this.auroraType;
    }
}

