/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import thebetweenlands.common.world.event.EnvironmentEvent;
import thebetweenlands.common.world.event.EventAuroras;
import thebetweenlands.common.world.event.EventBloodSky;
import thebetweenlands.common.world.event.EventDenseFog;
import thebetweenlands.common.world.event.EventHeavyRain;
import thebetweenlands.common.world.event.EventSpoopy;

public class EnvironmentEventRegistry {
    public final EventDenseFog DENSE_FOG;
    public final EnvironmentEvent HEAVY_RAIN;
    public final EventAuroras AURORAS;
    public final EventBloodSky BLOODSKY;
    public final EventSpoopy SPOOPY;
    private World world;
    private final Map<String, EnvironmentEvent> REGISTERED_EVENTS = new HashMap<String, EnvironmentEvent>();
    private boolean disabled = false;

    public EnvironmentEventRegistry(World world) {
        this.world = world;
        this.DENSE_FOG = new EventDenseFog(this);
        this.HEAVY_RAIN = new EventHeavyRain(this);
        this.AURORAS = new EventAuroras(this);
        this.BLOODSKY = new EventBloodSky(this);
        this.SPOOPY = new EventSpoopy(this);
    }

    public World getWorld() {
        return this.world;
    }

    public void init() {
        this.register(this.DENSE_FOG);
        this.register(this.HEAVY_RAIN);
        this.register(this.AURORAS);
        this.register(this.BLOODSKY);
        this.register(this.SPOOPY);
    }

    public void register(EnvironmentEvent event) {
        this.REGISTERED_EVENTS.put(event.getEventName(), event);
    }

    public Map<String, EnvironmentEvent> getEvents() {
        return Collections.unmodifiableMap(this.REGISTERED_EVENTS);
    }

    public EnvironmentEvent forName(String eventName) {
        return this.REGISTERED_EVENTS.get(eventName);
    }

    public List<EnvironmentEvent> getActiveEvents() {
        return this.getEventsOfState(true);
    }

    public List<EnvironmentEvent> getEventsOfState(boolean isActive) {
        ArrayList<EnvironmentEvent> list = new ArrayList<EnvironmentEvent>();
        for (EnvironmentEvent event : this.REGISTERED_EVENTS.values()) {
            if (event.isActive() != isActive) continue;
            list.add(event);
        }
        return list;
    }

    public List<String> getEventNames() {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (EnvironmentEvent event : this.REGISTERED_EVENTS.values()) {
            eventNames.add(event.getEventName());
        }
        return eventNames;
    }

    public List<String> getEventNamesOfState(boolean isActive) {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (EnvironmentEvent event : this.REGISTERED_EVENTS.values()) {
            if (event.isActive() != isActive) continue;
            eventNames.add(event.getEventName());
        }
        return eventNames;
    }

    public String getGrammaticalActiveEventNameList() {
        StringBuilder list = new StringBuilder();
        EnvironmentEvent[] events = this.REGISTERED_EVENTS.values().toArray(new EnvironmentEvent[0]);
        for (int i = 0; i < events.length; ++i) {
            String eventName = events[i].getEventName();
            if (i > 0) {
                list.append(", ");
                if (i == events.length - 1) {
                    list.append("and ");
                }
            }
            list.append(eventName);
        }
        return list.toString();
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void enable() {
        this.disabled = false;
    }

    public void disable() {
        this.disabled = true;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

