/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import thebetweenlands.common.world.event.EnvironmentEventRegistry;

public abstract class EnvironmentEvent {
    private final EnvironmentEventRegistry registry;
    private final World world;
    private NBTTagCompound nbtt = new NBTTagCompound();
    private boolean active = false;
    private boolean dirty = false;
    private boolean loaded = false;

    public EnvironmentEvent(EnvironmentEventRegistry registry) {
        this.registry = registry;
        this.world = registry.getWorld();
    }

    public World getWorld() {
        return this.world;
    }

    public boolean isActive() {
        return this.active;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setActive(boolean active, boolean markDirty) {
        this.active = active;
        if (markDirty) {
            this.markDirty();
        }
    }

    public void setLoaded() {
        this.loaded = true;
    }

    public void update(World world) {
    }

    public NBTTagCompound getData() {
        return this.nbtt;
    }

    public final void writeToNBT(NBTTagCompound compound) {
        this.nbtt.func_74757_a("active", this.active);
        this.saveEventData();
        compound.func_74782_a("environmentEvent:" + this.getEventName(), (NBTBase)this.nbtt);
    }

    public final void readFromNBT(NBTTagCompound compound) {
        this.nbtt = compound.func_74775_l("environmentEvent:" + this.getEventName());
        this.active = this.nbtt.func_74767_n("active");
        this.loadEventData();
        this.loaded = true;
    }

    public void setDefaults() {
    }

    public void saveEventData() {
    }

    public void loadEventData() {
    }

    public void loadEventPacket(PacketBuffer buffer) {
    }

    public void sendEventPacket(PacketBuffer buffer) {
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public abstract String getEventName();

    public String getLocalizationEventName() {
        return "event." + this.getEventName() + ".name";
    }

    public EnvironmentEventRegistry getRegistry() {
        return this.registry;
    }
}

