/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning.spawners;

import com.google.common.base.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.world.biome.spawning.MobSpawnHandler;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class SurfaceSpawnEntry
extends MobSpawnHandler.BLSpawnEntry {
    private boolean canSpawnOnWater = false;
    private boolean canSpawnInWater = false;
    private Predicate<IBlockState> surfaceBlockPredicate = new Predicate<IBlockState>(){

        public boolean apply(IBlockState input) {
            return SurfaceType.MIXED_GROUND.matches(input);
        }
    };

    public SurfaceSpawnEntry(Class<? extends EntityLiving> entityType) {
        super(entityType);
    }

    public SurfaceSpawnEntry(Class<? extends EntityLiving> entityType, short weight) {
        super(entityType, weight);
    }

    public SurfaceSpawnEntry setSurfacePredicate(Predicate<IBlockState> surfacePredicate) {
        this.surfaceBlockPredicate = surfacePredicate;
        return this;
    }

    public SurfaceSpawnEntry setCanSpawnOnWater(boolean spawnOnWater) {
        this.canSpawnOnWater = spawnOnWater;
        return this;
    }

    public SurfaceSpawnEntry setCanSpawnInWater(boolean spawnInWater) {
        this.canSpawnInWater = spawnInWater;
        return this;
    }

    @Override
    public void update(World world, BlockPos pos) {
        int caveHeight = 110;
        if (pos.func_177956_o() <= caveHeight) {
            this.setWeight((short)0);
        } else {
            this.setWeight(this.getBaseWeight());
        }
    }

    @Override
    public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState spawnBlockState, IBlockState surfaceBlockState) {
        return this.surfaceBlockPredicate.apply((Object)surfaceBlockState) && !spawnBlockState.func_185904_a().func_76224_d() || this.canSpawnInWater && spawnBlockState.func_185904_a().func_76224_d() || this.canSpawnOnWater && surfaceBlockState.func_185904_a().func_76224_d() && !spawnBlockState.func_185904_a().func_76224_d();
    }
}

