/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning.spawners;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.world.biome.spawning.MobSpawnHandler;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class CaveSpawnEntry
extends MobSpawnHandler.BLSpawnEntry {
    private boolean canSpawnOnWater = false;
    private boolean canSpawnInWater = false;

    public CaveSpawnEntry(Class<? extends EntityLiving> entityType) {
        super(entityType);
    }

    public CaveSpawnEntry(Class<? extends EntityLiving> entityType, short baseWeight) {
        super(entityType, baseWeight);
    }

    public CaveSpawnEntry setCanSpawnOnWater(boolean spawnOnWater) {
        this.canSpawnOnWater = spawnOnWater;
        return this;
    }

    public CaveSpawnEntry setCanSpawnInWater(boolean spawnInWater) {
        this.canSpawnInWater = spawnInWater;
        return this;
    }

    @Override
    public void update(World world, BlockPos pos) {
        int surfaceHeight = 110;
        short spawnWeight = (short)(this.getBaseWeight() / 3);
        if (pos.func_177956_o() < surfaceHeight) {
            double percentage = 1.0 - (double)(surfaceHeight - pos.func_177956_o()) / (double)surfaceHeight;
            spawnWeight = (short)MathHelper.func_76143_f((double)((double)this.getBaseWeight() / (2.0 * percentage + 1.0)));
        } else {
            spawnWeight = 0;
        }
        this.setWeight(spawnWeight);
    }

    @Override
    public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState spawnBlockState, IBlockState surfaceBlockState) {
        return SurfaceType.MIXED_GROUND_AND_UNDERGROUND.matches(surfaceBlockState) && !spawnBlockState.func_185904_a().func_76224_d() || this.canSpawnInWater && spawnBlockState.func_185904_a().func_76224_d() || this.canSpawnOnWater && surfaceBlockState.func_185904_a().func_76224_d() && !spawnBlockState.func_185904_a().func_76224_d();
    }
}

